/*
 * Decompiled with CFR 0.152.
 */
package org.schicwp.dinky.model.type.fields;

import com.mongodb.BasicDBObject;
import java.util.Collection;
import java.util.UUID;
import org.schicwp.dinky.model.Content;
import org.schicwp.dinky.model.ContentMap;
import org.schicwp.dinky.model.type.FieldType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.gridfs.GridFsTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class BinaryFieldType
implements FieldType {
    @Autowired
    GridFsTemplate gridFsTemplate;

    @Override
    public String getName() {
        return "Binary";
    }

    @Override
    public boolean validateSubmission(Object object, ContentMap properties, Collection<String> errors) {
        if (object == null) {
            return true;
        }
        if (object instanceof MultipartFile) {
            return true;
        }
        if (object instanceof String) {
            String id = (String)object;
            if (this.gridFsTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)id))) == null) {
                errors.add("Value is not a file id");
                return false;
            }
        }
        return true;
    }

    @Override
    public Object convertSubmission(Object input, ContentMap properties, Content content) {
        if (input == null) {
            return null;
        }
        if (input instanceof String) {
            return input;
        }
        try {
            MultipartFile multipartFile = (MultipartFile)input;
            BasicDBObject metaData = new BasicDBObject();
            metaData.put("contentType", (Object)multipartFile.getContentType());
            metaData.put("filename", (Object)multipartFile.getOriginalFilename());
            metaData.put("contentId", (Object)content.getId());
            return this.gridFsTemplate.store(multipartFile.getInputStream(), UUID.randomUUID().toString(), multipartFile.getContentType(), (Object)metaData).toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

