/*
 * Decompiled with CFR 0.152.
 */
package org.schicwp.dinky.security;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.util.ArrayList;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class JWTDecoder {
    private final String SECRET;

    public JWTDecoder(String secret) {
        this.SECRET = secret;
    }

    public UsernamePasswordAuthenticationToken decode(String token) {
        DecodedJWT verify = JWT.require((Algorithm)Algorithm.HMAC512((byte[])this.SECRET.getBytes())).build().verify(token);
        String user = verify.getSubject();
        Claim roles = verify.getClaim("roles");
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        for (String s : (String[])roles.asArray(String.class)) {
            authorities.add(new SimpleGrantedAuthority(s));
        }
        if (user != null) {
            return new UsernamePasswordAuthenticationToken((Object)user, null, authorities);
        }
        return null;
    }
}

