/*
 * Decompiled with CFR 0.152.
 */
package org.schicwp.dinky.security;

import java.util.Arrays;
import java.util.logging.Logger;
import javax.servlet.Filter;
import org.schicwp.dinky.security.JWTAuthorizationFilter;
import org.schicwp.dinky.security.JWTDecoder;
import org.schicwp.dinky.security.JWTEncoder;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;

@Order(value=1)
@Configuration
public class ProviderConfig
extends WebSecurityConfigurerAdapter {
    private static final Logger logger = Logger.getLogger(ProviderConfig.class.getCanonicalName());
    @Value(value="${ad.domain}")
    private String AD_DOMAIN;
    @Value(value="${ad.url}")
    private String AD_URL;
    @Value(value="${dinky.security.key}")
    private String key;
    public static final String SIGN_UP_URL = "/api/v1/auth/token";

    protected void configure(HttpSecurity http) throws Exception {
        logger.severe("USING DUMMY SECURITY CONFIG, SHOULD NOT HAPPEN IN REAL WORLD");
        JWTEncoder.setAuthenticationManager(this.authenticationManager());
        JWTEncoder.setSecret(this.key);
        ((HttpSecurity)http.cors().and()).csrf().disable();
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)http.cors().and()).csrf().disable()).authorizeRequests().antMatchers(HttpMethod.POST, new String[]{SIGN_UP_URL})).permitAll().antMatchers(HttpMethod.GET, new String[]{"/"})).permitAll().antMatchers(HttpMethod.GET, new String[]{"/page/*"})).permitAll().antMatchers(HttpMethod.GET, new String[]{"/content/**"})).permitAll().antMatchers(HttpMethod.GET, new String[]{"/js/*"})).permitAll().antMatchers(HttpMethod.GET, new String[]{"/css/*"})).permitAll().antMatchers(HttpMethod.GET, new String[]{"/img/*"})).permitAll().antMatchers(HttpMethod.GET, new String[]{"/favicon.ico"})).permitAll().anyRequest()).authenticated().and()).addFilter((Filter)new JWTAuthorizationFilter(this.authenticationManager(), new JWTDecoder(this.key))).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS);
    }

    protected void configure(AuthenticationManagerBuilder authManagerBuilder) throws Exception {
        authManagerBuilder.inMemoryAuthentication().withUser((UserDetails)new User("joe", this.passwordEncoder().encode((CharSequence)"bob"), Arrays.asList(new SimpleGrantedAuthority("ARF"))));
    }

    @Bean
    public AuthenticationManager authenticationManager(AuthenticationManagerBuilder authenticationManagerBuilder) throws Exception {
        return (AuthenticationManager)authenticationManagerBuilder.build();
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }
}

