/*
 * Decompiled with CFR 0.152.
 */
package org.schicwp.dinky.web;

import java.util.Map;
import org.schicwp.dinky.search.SearchContent;
import org.schicwp.dinky.search.SearchService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/"})
public class PageController {
    @Autowired
    SearchService searchService;

    @GetMapping
    public String index(Model model, @RequestParam Map<String, Object> params) {
        model.addAttribute("content", (Object)this.searchService);
        model.addAttribute("params", params);
        return "index";
    }

    @GetMapping(value={"page/{pageName}"})
    public String page(@PathVariable(value="pageName") String pageName, Model model, @RequestParam Map<String, Object> params) {
        model.addAttribute("content", (Object)this.searchService);
        model.addAttribute("params", params);
        return String.format("pages/%s", pageName);
    }

    @GetMapping(value={"content/{index}/{id}"})
    public String page(@PathVariable(value="id") String id, @PathVariable(value="index") String index, Model model, @RequestParam Map<String, Object> params) {
        Page<SearchContent> contents = this.searchService.search(index, "id:" + id, 0, 1);
        if (contents.getContent().size() != 1) {
            throw new RuntimeException();
        }
        SearchContent item = (SearchContent)contents.getContent().get(0);
        model.addAttribute("item", (Object)item);
        model.addAttribute("content", (Object)this.searchService);
        model.addAttribute("params", params);
        return String.format("content/%s/show", item.getType());
    }
}

