/*
 * Decompiled with CFR 0.152.
 */
package org.schwering.irc.lib;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketException;
import org.schwering.irc.lib.IRCEventListener;
import org.schwering.irc.lib.IRCModeParser;
import org.schwering.irc.lib.IRCParser;
import org.schwering.irc.lib.IRCTrafficLogger;
import org.schwering.irc.lib.IRCUser;
import org.schwering.irc.lib.IRCUtil;

public class IRCConnection
extends Thread {
    private Socket socket;
    protected byte level = 0;
    protected String host;
    protected int[] ports;
    private BufferedReader in;
    private PrintWriter out;
    protected String encoding = "ISO-8859-1";
    private IRCEventListener[] listeners = new IRCEventListener[0];
    private int timeout = 900000;
    private boolean colorsEnabled = false;
    private boolean pongAutomatic = true;
    private String pass;
    private String nick;
    private String realname;
    private String username;
    private String socksProxyHost;
    private Integer socksProxyPort;
    private IRCTrafficLogger trafficLogger;

    public IRCConnection(String host, int[] ports, String pass, String nick, String username, String realname, String socksProxyHost, Integer socksProxyPort, IRCTrafficLogger trafficLogger) {
        if (host == null || ports == null || ports.length == 0) {
            throw new IllegalArgumentException("Host and ports may not be null.");
        }
        this.host = host;
        this.ports = ports;
        this.pass = pass != null && pass.length() == 0 ? null : pass;
        this.nick = nick;
        this.username = username;
        this.realname = realname;
        this.socksProxyHost = socksProxyHost;
        this.socksProxyPort = socksProxyPort;
        this.trafficLogger = trafficLogger;
    }

    public IRCConnection(String host, int portMin, int portMax, String pass, String nick, String username, String realname, String socksProxyHost, Integer socksProxyPort, IRCTrafficLogger trafficLogger) {
        this(host, IRCConnection.portRangeToArray(portMin, portMax), pass, nick, username, realname, socksProxyHost, socksProxyPort, trafficLogger);
    }

    private static int[] portRangeToArray(int portMin, int portMax) {
        if (portMin > portMax) {
            int tmp = portMin;
            portMin = portMax;
            portMax = tmp;
        }
        int[] ports = new int[portMax - portMin + 1];
        for (int i = 0; i < ports.length; ++i) {
            ports[i] = portMin + i;
        }
        return ports;
    }

    public void connect() throws IOException {
        if (this.level != 0) {
            throw new SocketException("Socket closed or already open (" + this.level + ")");
        }
        IOException exception = null;
        Socket s = null;
        Proxy proxy = null;
        if (this.socksProxyHost != null && this.socksProxyPort != null) {
            proxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(this.socksProxyHost, (int)this.socksProxyPort));
        }
        for (int i = 0; i < this.ports.length && s == null; ++i) {
            try {
                s = proxy != null ? new Socket(proxy) : new Socket();
                s.connect(new InetSocketAddress(this.host, this.ports[i]));
                exception = null;
                continue;
            }
            catch (IOException exc) {
                if (s != null) {
                    s.close();
                }
                s = null;
                exception = exc;
            }
        }
        if (exception != null) {
            throw exception;
        }
        this.prepare(s);
    }

    protected void prepare(Socket s) throws IOException {
        if (s == null) {
            throw new SocketException("Socket s is null, not connected");
        }
        this.socket = s;
        this.level = 1;
        s.setSoTimeout(this.timeout);
        if (this.trafficLogger != null) {
            this.in = new LoggingReader((Reader)new InputStreamReader(s.getInputStream(), this.encoding), this.trafficLogger);
            this.out = new LoggingWriter((Writer)new OutputStreamWriter(s.getOutputStream(), this.encoding), this.trafficLogger);
        } else {
            this.in = new BufferedReader(new InputStreamReader(s.getInputStream(), this.encoding));
            this.out = new PrintWriter(new OutputStreamWriter(s.getOutputStream(), this.encoding));
        }
        this.start();
        this.register();
    }

    private void register() {
        if (this.pass != null) {
            this.send("PASS " + this.pass);
        }
        this.send("NICK " + this.nick);
        this.send("USER " + this.username + " " + this.socket.getLocalAddress().getHostAddress() + " " + this.host + " :" + this.realname);
    }

    @Override
    public void run() {
        try {
            String line;
            while ((line = this.in.readLine()) != null) {
                this.get(line);
            }
        }
        catch (IOException exc) {
            if (this.trafficLogger != null) {
                this.trafficLogger.exception(exc);
            }
            this.close();
        }
        finally {
            this.close();
        }
    }

    public void send(String line) {
        try {
            IRCParser p;
            this.out.write(line + "\r\n");
            this.out.flush();
            if (this.level == 1 && "NICK".equalsIgnoreCase((p = new IRCParser(line)).getCommand())) {
                this.nick = p.getParameter(1).trim();
            }
        }
        catch (Exception exc) {
            if (this.trafficLogger != null) {
                this.trafficLogger.exception(exc);
            }
            throw new RuntimeException(exc);
        }
    }

    private synchronized void get(String line) {
        block51: {
            String command;
            IRCParser p;
            block53: {
                int i;
                block52: {
                    block50: {
                        try {
                            p = new IRCParser(line, this.colorsEnabled);
                        }
                        catch (Exception exc) {
                            return;
                        }
                        command = p.getCommand();
                        if (!"PRIVMSG".equalsIgnoreCase(command)) break block50;
                        IRCUser user = p.getUser();
                        String middle = p.getMiddle();
                        String trailing = p.getTrailing();
                        for (int i2 = this.listeners.length - 1; i2 >= 0; --i2) {
                            this.listeners[i2].onPrivmsg(middle, user, trailing);
                        }
                        break block51;
                    }
                    if (!"MODE".equalsIgnoreCase(command)) break block52;
                    String chan = p.getParameter(1);
                    if (IRCUtil.isChan(chan)) {
                        IRCUser user = p.getUser();
                        String param2 = p.getParameter(2);
                        String paramsFrom3 = p.getParametersFrom(3);
                        for (int i3 = this.listeners.length - 1; i3 >= 0; --i3) {
                            this.listeners[i3].onMode(chan, user, new IRCModeParser(param2, paramsFrom3));
                        }
                    } else {
                        IRCUser user = p.getUser();
                        String paramsFrom2 = p.getParametersFrom(2);
                        for (int i4 = this.listeners.length - 1; i4 >= 0; --i4) {
                            this.listeners[i4].onMode(user, chan, paramsFrom2);
                        }
                    }
                    break block51;
                }
                if (!"PING".equalsIgnoreCase(command)) break block53;
                String ping = p.getTrailing();
                if (this.pongAutomatic) {
                    this.doPong(ping);
                } else {
                    for (i = this.listeners.length - 1; i >= 0; --i) {
                        this.listeners[i].onPing(ping);
                    }
                }
                if (this.level != 1) break block51;
                this.level = (byte)2;
                for (i = this.listeners.length - 1; i >= 0; --i) {
                    this.listeners[i].onRegistered();
                }
                break block51;
            }
            if ("JOIN".equalsIgnoreCase(command)) {
                IRCUser user = p.getUser();
                String trailing = p.getTrailing();
                for (int i = this.listeners.length - 1; i >= 0; --i) {
                    this.listeners[i].onJoin(trailing, user);
                }
            } else if ("NICK".equalsIgnoreCase(command)) {
                IRCUser user = p.getUser();
                String changingNick = p.getNick();
                String newNick = p.getTrailing();
                if (changingNick.equalsIgnoreCase(this.nick)) {
                    this.nick = newNick;
                }
                for (int i = this.listeners.length - 1; i >= 0; --i) {
                    this.listeners[i].onNick(user, newNick);
                }
            } else if ("QUIT".equalsIgnoreCase(command)) {
                IRCUser user = p.getUser();
                String trailing = p.getTrailing();
                for (int i = this.listeners.length - 1; i >= 0; --i) {
                    this.listeners[i].onQuit(user, trailing);
                }
            } else if ("PART".equalsIgnoreCase(command)) {
                IRCUser user = p.getUser();
                String chan = p.getParameter(1);
                String msg = p.getParameterCount() > 1 ? p.getTrailing() : "";
                for (int i = this.listeners.length - 1; i >= 0; --i) {
                    this.listeners[i].onPart(chan, user, msg);
                }
            } else if ("NOTICE".equalsIgnoreCase(command)) {
                IRCUser user = p.getUser();
                String middle = p.getMiddle();
                String trailing = p.getTrailing();
                for (int i = this.listeners.length - 1; i >= 0; --i) {
                    this.listeners[i].onNotice(middle, user, trailing);
                }
            } else {
                int reply = IRCUtil.parseInt(command);
                if (reply >= 1 && reply < 400) {
                    String potNick = p.getParameter(1);
                    if ((this.level == 1 || this.level == 2) && this.nick.length() > potNick.length() && this.nick.substring(0, potNick.length()).equalsIgnoreCase(potNick)) {
                        this.nick = potNick;
                        if (this.level == 2) {
                            this.level = (byte)3;
                        }
                    }
                    if (this.level == 1 && this.nick.equals(potNick)) {
                        this.level = (byte)2;
                        for (int i = this.listeners.length - 1; i >= 0; --i) {
                            this.listeners[i].onRegistered();
                        }
                    }
                    String middle = p.getMiddle();
                    String trailing = p.getTrailing();
                    for (int i = this.listeners.length - 1; i >= 0; --i) {
                        this.listeners[i].onReply(reply, middle, trailing);
                    }
                } else if (reply >= 400 && reply < 600) {
                    String trailing = p.getTrailing();
                    for (int i = this.listeners.length - 1; i >= 0; --i) {
                        this.listeners[i].onError(reply, trailing);
                    }
                } else if ("KICK".equalsIgnoreCase(command)) {
                    IRCUser user = p.getUser();
                    String param1 = p.getParameter(1);
                    String param2 = p.getParameter(2);
                    String msg = p.getParameterCount() > 2 ? p.getTrailing() : "";
                    for (int i = this.listeners.length - 1; i >= 0; --i) {
                        this.listeners[i].onKick(param1, user, param2, msg);
                    }
                } else if ("INVITE".equalsIgnoreCase(command)) {
                    IRCUser user = p.getUser();
                    String middle = p.getMiddle();
                    String trailing = p.getTrailing();
                    for (int i = this.listeners.length - 1; i >= 0; --i) {
                        this.listeners[i].onInvite(trailing, user, middle);
                    }
                } else if ("TOPIC".equalsIgnoreCase(command)) {
                    IRCUser user = p.getUser();
                    String middle = p.getMiddle();
                    String trailing = p.getTrailing();
                    for (int i = this.listeners.length - 1; i >= 0; --i) {
                        this.listeners[i].onTopic(middle, user, trailing);
                    }
                } else if ("ERROR".equalsIgnoreCase(command)) {
                    String trailing = p.getTrailing();
                    for (int i = this.listeners.length - 1; i >= 0; --i) {
                        this.listeners[i].onError(trailing);
                    }
                } else {
                    String prefix = p.getPrefix();
                    String middle = p.getMiddle();
                    String trailing = p.getTrailing();
                    for (int i = this.listeners.length - 1; i >= 0; --i) {
                        this.listeners[i].unknown(prefix, command, middle, trailing);
                    }
                }
            }
        }
    }

    public synchronized void close() {
        try {
            if (!this.isInterrupted()) {
                this.interrupt();
            }
        }
        catch (Exception exc) {
            this.handleException(exc);
        }
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (Exception exc) {
            this.handleException(exc);
        }
        try {
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (Exception exc) {
            this.handleException(exc);
        }
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (Exception exc) {
            this.handleException(exc);
        }
        if (this.level != -1) {
            this.level = (byte)-1;
            for (int i = this.listeners.length - 1; i >= 0; --i) {
                this.listeners[i].onDisconnected();
            }
        }
        this.socket = null;
        this.in = null;
        this.out = null;
        this.listeners = new IRCEventListener[0];
    }

    private void handleException(Exception exc) {
        if (this.trafficLogger == null) {
            throw new RuntimeException(exc);
        }
        this.trafficLogger.exception(exc);
    }

    public synchronized void addIRCEventListener(IRCEventListener l) {
        if (l == null) {
            throw new IllegalArgumentException("Listener is null.");
        }
        int len = this.listeners.length;
        IRCEventListener[] oldListeners = this.listeners;
        this.listeners = new IRCEventListener[len + 1];
        System.arraycopy(oldListeners, 0, this.listeners, 0, len);
        this.listeners[len] = l;
    }

    public synchronized void addIRCEventListener(IRCEventListener l, int i) {
        if (l == null) {
            throw new IllegalArgumentException("Listener is null.");
        }
        if (i < 0 || i > this.listeners.length) {
            throw new IndexOutOfBoundsException("i is not in range");
        }
        int len = this.listeners.length;
        IRCEventListener[] oldListeners = this.listeners;
        this.listeners = new IRCEventListener[len + 1];
        if (i > 0) {
            System.arraycopy(oldListeners, 0, this.listeners, 0, i);
        }
        if (i < this.listeners.length) {
            System.arraycopy(oldListeners, i, this.listeners, i + 1, len - i);
        }
        this.listeners[i] = l;
    }

    public synchronized boolean removeIRCEventListener(IRCEventListener l) {
        if (l == null) {
            return false;
        }
        int index = -1;
        for (int i = 0; i < this.listeners.length; ++i) {
            if (!this.listeners[i].equals(l)) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return false;
        }
        this.listeners[index] = null;
        int len = this.listeners.length - 1;
        IRCEventListener[] newListeners = new IRCEventListener[len];
        int i = 0;
        int j = 0;
        while (i < len) {
            if (this.listeners[j] != null) {
                newListeners[i++] = this.listeners[j];
            }
            ++j;
        }
        this.listeners = newListeners;
        return true;
    }

    public void setColors(boolean colors) {
        this.colorsEnabled = colors;
    }

    public void setPong(boolean pong) {
        this.pongAutomatic = pong;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setTimeout(int millis) {
        if (this.socket != null) {
            try {
                this.socket.setSoTimeout(millis);
            }
            catch (IOException exc) {
                this.handleException(exc);
            }
        }
        this.timeout = millis;
    }

    public boolean isConnected() {
        return this.level >= 1;
    }

    public String getNick() {
        return this.nick;
    }

    public String getRealname() {
        return this.realname;
    }

    public String getUsername() {
        return this.username;
    }

    public String getHost() {
        return this.host;
    }

    public String getPassword() {
        return this.pass;
    }

    public int[] getPorts() {
        return this.ports;
    }

    public int getPort() {
        return this.socket != null ? this.socket.getPort() : 0;
    }

    public boolean getColors() {
        return this.colorsEnabled;
    }

    public boolean getPong() {
        return this.pongAutomatic;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public int getTimeout() {
        if (this.socket != null) {
            try {
                return this.socket.getSoTimeout();
            }
            catch (IOException exc) {
                this.handleException(exc);
                return -1;
            }
        }
        return this.timeout;
    }

    public InetAddress getLocalAddress() {
        return this.socket != null ? this.socket.getLocalAddress() : null;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[" + this.host + "," + this.getPort() + "," + this.username + "," + this.nick + "," + this.realname + "," + this.pass + "," + this.isConnected() + "]";
    }

    public void doAway() {
        this.send("AWAY");
    }

    public void doAway(String msg) {
        this.send("AWAY :" + msg);
    }

    public void doInvite(String nick, String chan) {
        this.send("INVITE " + nick + " " + chan);
    }

    public void doIson(String nick) {
        this.send("ISON " + nick);
    }

    public void doJoin(String chan) {
        this.send("JOIN " + chan);
    }

    public void doJoin(String chan, String key) {
        this.send("JOIN " + chan + " " + key);
    }

    public void doKick(String chan, String nick) {
        this.send("KICK " + chan + " " + nick);
    }

    public void doKick(String chan, String nick, String msg) {
        this.send("KICK " + chan + " " + nick + " :" + msg);
    }

    public void doList() {
        this.send("LIST");
    }

    public void doList(String chan) {
        this.send("LIST " + chan);
    }

    public void doNames() {
        this.send("NAMES");
    }

    public void doNames(String chan) {
        this.send("NAMES " + chan);
    }

    public void doPrivmsg(String target, String msg) {
        this.send("PRIVMSG " + target + " :" + msg);
    }

    public void doMode(String chan) {
        this.send("MODE " + chan);
    }

    public void doMode(String target, String mode) {
        this.send("MODE " + target + " " + mode);
    }

    public void doNick(String nick) {
        this.send("NICK " + nick);
    }

    public void doNotice(String target, String msg) {
        this.send("NOTICE " + target + " :" + msg);
    }

    public void doPart(String chan) {
        this.send("PART " + chan);
    }

    public void doPart(String chan, String msg) {
        this.send("PART " + chan + " :" + msg);
    }

    public void doPong(String ping) {
        this.send("PONG :" + ping);
    }

    public void doQuit() {
        this.send("QUIT");
    }

    public void doQuit(String msg) {
        this.send("QUIT :" + msg);
    }

    public void doTopic(String chan) {
        this.send("TOPIC " + chan);
    }

    public void doTopic(String chan, String topic) {
        this.send("TOPIC " + chan + " :" + topic);
    }

    public void doWho(String criteric) {
        this.send("WHO " + criteric);
    }

    public void doWhois(String nick) {
        this.send("WHOIS " + nick);
    }

    public void doWhowas(String nick) {
        this.send("WHOWAS " + nick);
    }

    public void doUserhost(String nick) {
        this.send("USERHOST " + nick);
    }

    private static class LoggingWriter
    extends PrintWriter {
        private final IRCTrafficLogger trafficLogger;

        public LoggingWriter(Writer out, IRCTrafficLogger trafficLogger) {
            super(out);
            this.trafficLogger = trafficLogger;
        }

        @Override
        public void write(String s) {
            String trimmedLine = s;
            if (s != null && s.endsWith("\r\n")) {
                trimmedLine = s.substring(0, s.length() - 2);
            }
            this.trafficLogger.out(trimmedLine);
            super.write(s);
        }
    }

    private static class LoggingReader
    extends BufferedReader {
        private final IRCTrafficLogger trafficLogger;

        public LoggingReader(Reader in, IRCTrafficLogger trafficLogger) {
            super(in);
            this.trafficLogger = trafficLogger;
        }

        @Override
        public String readLine() throws IOException {
            String line = super.readLine();
            this.trafficLogger.in(line);
            return line;
        }
    }
}

