/*
 * Decompiled with CFR 0.152.
 */
package org.schwering.irc.lib;

import java.util.ArrayList;
import org.schwering.irc.lib.IRCConstants;

public class IRCUtil
implements IRCConstants {
    private IRCUtil() {
    }

    public static boolean isChan(String str) {
        char c;
        return str.length() >= 2 && ((c = str.charAt(0)) == '#' || c == '&' || c == '!' || c == '+');
    }

    public static int parseInt(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException exc) {
            return -1;
        }
    }

    public static String stripColors(String str) {
        return IRCUtil.parseColors(new StringBuffer(str), false).toString();
    }

    public static StringBuffer stripColors(StringBuffer buf) {
        return IRCUtil.parseColors(buf, false);
    }

    public static String parseColors(String str) {
        return IRCUtil.parseColors(new StringBuffer(str)).toString();
    }

    public static StringBuffer parseColors(StringBuffer buf) {
        return IRCUtil.parseColors(buf, true);
    }

    static StringBuffer parseColors(StringBuffer buf, boolean removeCTCP) {
        int len = buf.length();
        int i = 0;
        int j = 0;
        while (i < len) {
            char c = buf.charAt(i);
            try {
                if (c == '\u0003') {
                    if ('0' <= (c = buf.charAt(++j)) && c <= '9' && '0' <= (c = buf.charAt(++j)) && c <= '9') {
                        c = buf.charAt(++j);
                    }
                    if (c == ',') {
                        c = buf.charAt(++j);
                    }
                    if ('0' <= c && c <= '9' && '0' <= (c = buf.charAt(++j)) && c <= '9') {
                        c = buf.charAt(++j);
                    }
                } else if (removeCTCP && c == '\u0001' || c == '\u001f' || c == '\u0002' || c == '\u000f' || c == '\u0016') {
                    ++j;
                }
            }
            catch (StringIndexOutOfBoundsException exc) {
                // empty catch block
            }
            if (j > i) {
                buf = buf.delete(i, j);
                len -= j - i;
                --i;
            }
            j = ++i;
        }
        return buf;
    }

    public static String[] split(String str, int delim, String trailing) {
        ArrayList<String> items = new ArrayList<String>(15);
        int last = 0;
        int len = str.length();
        for (int index = 0; index < len; ++index) {
            if (str.charAt(index) != delim) continue;
            items.add(str.substring(last, index));
            last = index + 1;
        }
        if (last != len) {
            items.add(str.substring(last));
        }
        if (trailing != null && trailing.length() != 0) {
            items.add(trailing);
        }
        String[] result = items.toArray(new String[0]);
        return result;
    }

    public static String[] split(String str, int delim) {
        return IRCUtil.split(str, delim, null);
    }
}

