/*
 * Decompiled with CFR 0.152.
 */
package org.schwering.irc.lib.ssl;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.schwering.irc.lib.IRCConnection;
import org.schwering.irc.lib.IRCTrafficLogger;
import org.schwering.irc.lib.ssl.SSLDefaultTrustManager;
import org.schwering.irc.lib.ssl.SSLNotSupportedException;
import org.schwering.irc.lib.ssl.SSLSocketFactoryFactory;
import org.schwering.irc.lib.ssl.SSLTrustManager;

public class SSLIRCConnection
extends IRCConnection {
    public static String protocol = "SSL";
    private List<SSLTrustManager> trustManagers = new ArrayList<SSLTrustManager>(1);

    public SSLIRCConnection(String host, int[] ports, String pass, String nick, String username, String realname, String socksProxyHost, Integer socksProxyPort, IRCTrafficLogger trafficLogger) {
        super(host, ports, pass, nick, username, realname, socksProxyHost, socksProxyPort, trafficLogger);
    }

    public SSLIRCConnection(String host, int portMin, int portMax, String pass, String nick, String username, String realname, String socksProxyHost, Integer socksProxyPort, IRCTrafficLogger trafficLogger) {
        super(host, portMin, portMax, pass, nick, username, realname, socksProxyHost, socksProxyPort, trafficLogger);
    }

    @Override
    public void connect() throws IOException {
        if (this.level != 0) {
            throw new SocketException("Socket closed or already open (" + this.level + ")");
        }
        IOException exception = null;
        if (this.trustManagers.size() == 0) {
            this.addTrustManager(new SSLDefaultTrustManager());
        }
        SSLSocketFactory sf = null;
        Socket s = null;
        for (int i = 0; i < this.ports.length && s == null; ++i) {
            try {
                if (sf == null) {
                    sf = SSLSocketFactoryFactory.createSSLSocketFactory(this.getTrustManagers());
                }
                s = (SSLSocket)sf.createSocket(this.host, this.ports[i]);
                ((SSLSocket)s).startHandshake();
                exception = null;
                continue;
            }
            catch (SSLNotSupportedException exc) {
                if (s != null) {
                    s.close();
                }
                s = null;
                throw exc;
            }
            catch (IOException exc) {
                if (s != null) {
                    s.close();
                }
                s = null;
                exception = exc;
            }
        }
        if (exception != null) {
            throw exception;
        }
        this.prepare(s);
    }

    public void addTrustManager(SSLTrustManager trustManager) {
        this.trustManagers.add(trustManager);
    }

    public boolean removeTrustManager(SSLTrustManager trustManager) {
        return this.trustManagers.remove(trustManager);
    }

    public SSLTrustManager[] getTrustManagers() {
        SSLTrustManager[] tm = new SSLTrustManager[this.trustManagers.size()];
        this.trustManagers.toArray(tm);
        return tm;
    }
}

