/*
 * Decompiled with CFR 0.152.
 */
package org.schwering.irc.lib.ssl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.SecureRandom;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;
import org.schwering.irc.lib.ssl.SSLIRCConnection;
import org.schwering.irc.lib.ssl.SSLNotSupportedException;
import org.schwering.irc.lib.ssl.SSLTrustManager;
import org.schwering.irc.lib.ssl.TrustManagerJava14Wrapper;
import org.schwering.irc.lib.ssl.TrustManagerJsseWrapper;

class SSLSocketFactoryFactory {
    private SSLSocketFactoryFactory() {
    }

    public static SSLSocketFactory createSSLSocketFactory(SSLTrustManager[] tm) throws SSLException, SSLNotSupportedException {
        boolean sslNotSupported = false;
        Exception exception = null;
        try {
            return SSLSocketFactoryFactory.createJava14SSLSocketFactory(tm);
        }
        catch (ClassNotFoundException cnfe) {
        }
        catch (NoSuchMethodException nsme) {
        }
        catch (InvocationTargetException ite) {
        }
        catch (IllegalAccessException eae) {
        }
        catch (Exception exc) {
            // empty catch block
        }
        try {
            return SSLSocketFactoryFactory.createJsseSSLSocketFactory(tm);
        }
        catch (ClassNotFoundException cnfe) {
            exception = cnfe;
            sslNotSupported = true;
        }
        catch (NoSuchMethodException nsme) {
            exception = nsme;
            sslNotSupported = true;
        }
        catch (InstantiationException ie) {
            exception = ie;
            sslNotSupported = true;
        }
        catch (InvocationTargetException ite) {
            exception = ite;
            sslNotSupported = true;
        }
        catch (IllegalAccessException eae) {
            exception = eae;
            sslNotSupported = true;
        }
        catch (Exception exc) {
            exception = exc;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        exception.printStackTrace(pw);
        pw.close();
        if (sslNotSupported) {
            throw new SSLNotSupportedException("Neither JSSE nor J2SE >= 1.4 installed:\n---\n" + sw.toString() + "---");
        }
        throw new SSLException("Exception while creating the SSLSocketFactory with JSSE:\n---\n" + sw.toString() + "---");
    }

    private static SSLSocketFactory createJava14SSLSocketFactory(SSLTrustManager[] tm) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<String> stringClass = String.class;
        Class<?> contextClass = Class.forName("javax.net.ssl.SSLContext");
        Class<?> keyManagerClass = Class.forName("javax.net.ssl.KeyManager");
        Class<?> keyManagerArrayClass = Array.newInstance(keyManagerClass, 0).getClass();
        Class<?> trustManagerClass = Class.forName("javax.net.ssl.TrustManager");
        Class<?> trustManagerArrayClass = Array.newInstance(trustManagerClass, 0).getClass();
        Class<SecureRandom> secureRandomClass = SecureRandom.class;
        Method getInstanceMethod = contextClass.getMethod("getInstance", stringClass);
        Method initMethod = contextClass.getMethod("init", keyManagerArrayClass, trustManagerArrayClass, secureRandomClass);
        Method getSocketFactoryMethod = contextClass.getMethod("getSocketFactory", new Class[0]);
        Class.forName("javax.net.ssl.X509TrustManager");
        TrustManagerJava14Wrapper[] tmWrappers = TrustManagerJava14Wrapper.wrap(tm);
        String protocol = SSLIRCConnection.protocol;
        Object context = getInstanceMethod.invoke(null, protocol);
        initMethod.invoke(context, null, tmWrappers, null);
        Object socketFactory = getSocketFactoryMethod.invoke(context, new Object[0]);
        return (SSLSocketFactory)socketFactory;
    }

    private static SSLSocketFactory createJsseSSLSocketFactory(SSLTrustManager[] tm) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, InvocationTargetException, IllegalAccessException {
        Class<?> securityClass = Class.forName("java.security.Security");
        Class<?> providerClass = Class.forName("java.security.Provider");
        Class<?> sslProviderClass = Class.forName("com.sun.net.ssl.internal.ssl.Provider");
        Method addProvider = securityClass.getMethod("addProvider", providerClass);
        Object provider = sslProviderClass.newInstance();
        addProvider.invoke(null, provider);
        Class<String> stringClass = String.class;
        Class<?> contextClass = Class.forName("com.sun.net.ssl.SSLContext");
        Class<?> keyManagerClass = Class.forName("com.sun.net.ssl.KeyManager");
        Class<?> keyManagerArrayClass = Array.newInstance(keyManagerClass, 0).getClass();
        Class<?> trustManagerClass = Class.forName("com.sun.net.ssl.TrustManager");
        Class<?> trustManagerArrayClass = Array.newInstance(trustManagerClass, 0).getClass();
        Class<SecureRandom> secureRandomClass = SecureRandom.class;
        Method getInstanceMethod = contextClass.getMethod("getInstance", stringClass);
        Method initMethod = contextClass.getMethod("init", keyManagerArrayClass, trustManagerArrayClass, secureRandomClass);
        Method getSocketFactoryMethod = contextClass.getMethod("getSocketFactory", new Class[0]);
        Class.forName("com.sun.net.ssl.X509TrustManager");
        TrustManagerJsseWrapper[] tmWrappers = TrustManagerJsseWrapper.wrap(tm);
        String protocol = SSLIRCConnection.protocol;
        Object context = getInstanceMethod.invoke(null, protocol);
        initMethod.invoke(context, null, tmWrappers, null);
        Object socketFactory = getSocketFactoryMethod.invoke(context, new Object[0]);
        return (SSLSocketFactory)socketFactory;
    }
}

