/*
 * Decompiled with CFR 0.152.
 */
package org.schwering.irc.lib.ssl;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;
import org.schwering.irc.lib.ssl.SSLTrustManager;

class TrustManagerJava14Wrapper
implements X509TrustManager {
    private SSLTrustManager trustManager;

    public static TrustManagerJava14Wrapper[] wrap(SSLTrustManager[] tm) {
        TrustManagerJava14Wrapper[] w = new TrustManagerJava14Wrapper[tm.length];
        for (int i = 0; i < tm.length; ++i) {
            w[i] = new TrustManagerJava14Wrapper(tm[i]);
        }
        return w;
    }

    public TrustManagerJava14Wrapper(SSLTrustManager trustManager) {
        if (trustManager == null) {
            throw new IllegalArgumentException("trustManager == null");
        }
        this.trustManager = trustManager;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        throw new CertificateException("This trust manager _is_ for clients. What other client should be trusted?");
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (!this.trustManager.isTrusted(chain)) {
            throw new CertificateException("The certificate chain is not trusted!");
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.trustManager.getAcceptedIssuers();
    }
}

