/*
 * Decompiled with CFR 0.152.
 */
package org.schwering.irc.lib.util;

import org.schwering.irc.lib.util.IRCUtil;

public class IRCModeParser {
    private String line;
    private char[] operatorsArr;
    private char[] modesArr;
    private String[] argsArr;

    public IRCModeParser(String line) {
        this.line = line = line.trim();
        int index = line.indexOf(32);
        if (index >= 2) {
            String modes = line.substring(0, index);
            String args = line.substring(index + 1);
            this.parse(modes, args);
        } else if (line.length() >= 2) {
            String modes = line;
            String args = "";
            this.parse(modes, args);
        } else {
            this.argsArr = new String[0];
            this.operatorsArr = new char[0];
            this.modesArr = new char[0];
        }
    }

    public IRCModeParser(String modes, String args) {
        this.line = modes + " " + args;
        this.parse(modes, args);
    }

    private void parse(String modes, String args) {
        String[] argsTmp = IRCUtil.split(args, 32);
        int modesLen = modes.length();
        int modesCount = this.getModesCount(modes);
        int operator = 43;
        this.operatorsArr = new char[modesCount];
        this.modesArr = new char[modesCount];
        this.argsArr = new String[modesCount];
        int j = 0;
        int n = 0;
        for (int i = 0; i < modesLen; ++i) {
            char c = modes.charAt(i);
            if (c == '+' || c == '-') {
                operator = c;
                continue;
            }
            this.operatorsArr[n] = operator;
            this.modesArr[n] = c;
            this.argsArr[n] = c == 'o' || c == 'v' || c == 'b' || c == 'k' || c == 'l' && operator == 43 ? (j < argsTmp.length ? argsTmp[j++] : "") : "";
            ++n;
        }
    }

    private int getModesCount(String modes) {
        int count = 0;
        int len = modes.length();
        for (int i = 0; i < len; ++i) {
            char c = modes.charAt(i);
            if (c == '+' || c == '-') continue;
            ++count;
        }
        return count;
    }

    public int getCount() {
        return this.operatorsArr.length;
    }

    public char getOperatorAt(int i) {
        return this.operatorsArr[i - 1];
    }

    public char getModeAt(int i) {
        return this.modesArr[i - 1];
    }

    public String getArgAt(int i) {
        return this.argsArr[i - 1];
    }

    public String getLine() {
        return this.line;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getLine() + "]";
    }
}

