/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.NotYetConnectedException;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.scion.jpan.Path;
import org.scion.jpan.PathPolicy;
import org.scion.jpan.RequestPath;
import org.scion.jpan.ResponsePath;
import org.scion.jpan.ScionException;
import org.scion.jpan.ScionService;
import org.scion.jpan.ScionSocketOptions;
import org.scion.jpan.ScionUtil;
import org.scion.jpan.Scmp;
import org.scion.jpan.internal.ExtensionHeader;
import org.scion.jpan.internal.InternalConstants;
import org.scion.jpan.internal.ScionHeaderParser;
import org.scion.jpan.internal.ScmpParser;

abstract class AbstractDatagramChannel<C extends AbstractDatagramChannel<?>>
implements Closeable {
    private final DatagramChannel channel;
    private ByteBuffer bufferReceive;
    private ByteBuffer bufferSend;
    private final Object stateLock = new Object();
    private final ReentrantLock readLock = new ReentrantLock();
    private final ReentrantLock writeLock = new ReentrantLock();
    private RequestPath connectionPath;
    private InetAddress localAddress;
    private boolean isBoundToAddress = false;
    private boolean cfgReportFailedValidation = false;
    private PathPolicy pathPolicy = PathPolicy.DEFAULT;
    private ScionService service;
    private int cfgExpirationSafetyMargin = ScionUtil.getPropertyOrEnv("org.scion.pathExpiryMargin", "SCION_PATH_EXPIRY_MARGIN", 10);
    private int cfgTrafficClass;
    private Consumer<Scmp.Message> errorListener;
    private boolean cfgRemoteDispatcher = false;
    private InetSocketAddress overrideExternalAddress = null;

    protected AbstractDatagramChannel(ScionService service) throws IOException {
        this(service, DatagramChannel.open());
    }

    protected AbstractDatagramChannel(ScionService service, DatagramChannel channel) {
        this.channel = channel;
        this.service = service;
        this.bufferReceive = ByteBuffer.allocateDirect(2000);
        this.bufferSend = ByteBuffer.allocateDirect(2000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configureBlocking(boolean block) throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.channel.configureBlocking(block);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isBlocking() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.channel.isBlocking();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PathPolicy getPathPolicy() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.pathPolicy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPathPolicy(PathPolicy pathPolicy) throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.pathPolicy = pathPolicy;
            if (this.isConnected()) {
                this.connectionPath = pathPolicy.filter(this.getOrCreateService().getPaths(this.connectionPath));
                this.updateConnection(this.connectionPath, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ScionService getOrCreateService() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.service == null) {
                this.service = ScionService.defaultService();
            }
            return this.service;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScionService getService() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.service;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DatagramChannel channel() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.channel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public C bind(InetSocketAddress address) throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.channel.bind(address);
            this.isBoundToAddress = address != null;
            this.localAddress = ((InetSocketAddress)this.channel.getLocalAddress()).getAddress();
            return (C)this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureBound() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.localAddress == null) {
                this.bind(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetSocketAddress getLocalAddress() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.localAddress == null) {
                return null;
            }
            int port = ((InetSocketAddress)this.channel.getLocalAddress()).getPort();
            return new InetSocketAddress(this.localAddress, port);
        }
    }

    public InetSocketAddress getRemoteAddress() throws IOException {
        Path path = this.getConnectionPath();
        if (path != null) {
            return new InetSocketAddress(path.getRemoteAddress(), path.getRemotePort());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.channel.disconnect();
            this.connectionPath = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.channel.isOpen();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.channel.disconnect();
            this.channel.close();
            this.connectionPath = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public C connect(SocketAddress addr) throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.checkConnected(false);
            if (!(addr instanceof InetSocketAddress)) {
                throw new IllegalArgumentException("connect() requires an InetSocketAddress or a ScionSocketAddress.");
            }
            return this.connect(this.pathPolicy.filter(this.getOrCreateService().getPaths((InetSocketAddress)addr)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public C connect(RequestPath path) throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.checkConnected(false);
            this.ensureBound();
            this.updateConnection(path, false);
            return (C)this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path getConnectionPath() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.connectionPath;
        }
    }

    protected ResponsePath receiveFromChannel(ByteBuffer buffer, InternalConstants.HdrTypes expectedHdrType) throws IOException {
        this.ensureBound();
        while (true) {
            buffer.clear();
            InetSocketAddress srcAddress = (InetSocketAddress)this.channel.receive(buffer);
            if (srcAddress == null) {
                return null;
            }
            buffer.flip();
            if (!this.validate(buffer.asReadOnlyBuffer())) continue;
            InternalConstants.HdrTypes hdrType = ScionHeaderParser.extractNextHeader(buffer);
            buffer.position(ScionHeaderParser.extractHeaderLength(buffer));
            hdrType = this.receiveExtensionHeader(buffer, hdrType);
            ResponsePath path = ScionHeaderParser.extractResponsePath(buffer, srcAddress);
            if (hdrType == expectedHdrType) {
                return path;
            }
            this.receiveScmp(buffer, path);
        }
    }

    protected InternalConstants.HdrTypes receiveExtensionHeader(ByteBuffer buffer, InternalConstants.HdrTypes hdrType) {
        ExtensionHeader extHdr;
        if ((hdrType == InternalConstants.HdrTypes.END_TO_END || hdrType == InternalConstants.HdrTypes.HOP_BY_HOP) && (hdrType = (extHdr = ExtensionHeader.consume(buffer)).nextHdr()) != InternalConstants.HdrTypes.SCMP) {
            throw new UnsupportedOperationException("Extension header not supported: " + hdrType);
        }
        return hdrType;
    }

    protected void receiveScmp(ByteBuffer buffer, Path path) {
        Scmp.Type type = ScmpParser.extractType(buffer);
        Scmp.Message msg = Scmp.createMessage(type, path);
        ScmpParser.consume(buffer, msg);
        this.checkListeners(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkListeners(Scmp.Message scmpMsg) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.errorListener != null && scmpMsg.getTypeCode().isError()) {
                this.errorListener.accept(scmpMsg);
            }
        }
    }

    @Deprecated
    public void configureRemoteDispatcher(boolean hasDispatcher) {
        this.cfgRemoteDispatcher = hasDispatcher;
    }

    @Deprecated
    public void setOverrideSourceAddress(InetSocketAddress address) {
        this.overrideExternalAddress = address;
    }

    protected int sendRaw(ByteBuffer buffer, InetSocketAddress address, Path path) throws IOException {
        if (this.cfgRemoteDispatcher && path != null && path.getRawPath().length == 0) {
            return this.channel.send(buffer, new InetSocketAddress(address.getAddress(), 30041));
        }
        return this.channel.send(buffer, address);
    }

    protected int sendRaw(ByteBuffer buffer, InetSocketAddress address) throws IOException {
        return this.sendRaw(buffer, address, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Consumer<Scmp.Message> setScmpErrorListener(Consumer<Scmp.Message> listener) {
        Object object = this.stateLock;
        synchronized (object) {
            Consumer<Scmp.Message> old = this.errorListener;
            this.errorListener = listener;
            return old;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkOpen() throws ClosedChannelException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.channel.isOpen()) {
                throw new ClosedChannelException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkConnected(boolean requiredState) {
        Object object = this.stateLock;
        synchronized (object) {
            boolean isConnected;
            boolean bl = isConnected = this.connectionPath != null;
            if (requiredState != isConnected) {
                if (isConnected) {
                    throw new AlreadyConnectedException();
                }
                throw new NotYetConnectedException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.connectionPath != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getOption(SocketOption<T> option) throws IOException {
        this.checkOpen();
        Object object = this.stateLock;
        synchronized (object) {
            if (option instanceof ScionSocketOptions.SciSocketOption) {
                if (ScionSocketOptions.SN_API_THROW_PARSER_FAILURE.equals(option)) {
                    return (T)Boolean.valueOf(this.cfgReportFailedValidation);
                }
                if (ScionSocketOptions.SN_PATH_EXPIRY_MARGIN.equals(option)) {
                    return (T)Integer.valueOf(this.cfgExpirationSafetyMargin);
                }
                if (ScionSocketOptions.SN_TRAFFIC_CLASS.equals(option)) {
                    return (T)Integer.valueOf(this.cfgTrafficClass);
                }
                throw new UnsupportedOperationException();
            }
            if (StandardSocketOptions.SO_BROADCAST.equals(option)) {
                throw new UnsupportedOperationException();
            }
            return this.channel.getOption(option);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> C setOption(SocketOption<T> option, T t) throws IOException {
        this.checkOpen();
        Object object = this.stateLock;
        synchronized (object) {
            if (option instanceof ScionSocketOptions.SciSocketOption) {
                if (ScionSocketOptions.SN_API_THROW_PARSER_FAILURE.equals(option)) {
                    this.cfgReportFailedValidation = (Boolean)t;
                } else if (ScionSocketOptions.SN_PATH_EXPIRY_MARGIN.equals(option)) {
                    this.cfgExpirationSafetyMargin = (Integer)t;
                } else {
                    if (!ScionSocketOptions.SN_TRAFFIC_CLASS.equals(option)) throw new UnsupportedOperationException();
                    int trafficClass = (Integer)t;
                    if (trafficClass < 0 || trafficClass > 255) {
                        throw new IllegalArgumentException("trafficClass is not in range 0 -- 255");
                    }
                    this.cfgTrafficClass = trafficClass;
                }
            } else {
                if (StandardSocketOptions.SO_BROADCAST.equals(option)) {
                    throw new UnsupportedOperationException();
                }
                this.channel.setOption((SocketOption)option, (Object)t);
            }
            return (C)this;
        }
    }

    protected final ByteBuffer bufferSend() {
        return this.bufferSend;
    }

    protected final ByteBuffer bufferReceive() {
        return this.bufferReceive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resizeBuffers(InetAddress address) throws SocketException {
        int mtu = NetworkInterface.getByInetAddress(address).getMTU();
        this.readLock().lock();
        try {
            if (this.bufferReceive.capacity() < mtu) {
                this.bufferReceive = ByteBuffer.allocateDirect(mtu);
            }
        }
        finally {
            this.readLock().unlock();
        }
        this.writeLock().lock();
        try {
            if (this.bufferSend.capacity() < mtu) {
                this.bufferSend = ByteBuffer.allocateDirect(mtu);
            }
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Path checkPathAndBuildHeader(ByteBuffer buffer, Path path, int payloadLength, InternalConstants.HdrTypes hdrType) throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (path instanceof RequestPath) {
                path = this.ensureUpToDate((RequestPath)path);
            }
            this.buildHeader(buffer, path, payloadLength, hdrType);
            return path;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildHeader(ByteBuffer buffer, Path path, int payloadLength, InternalConstants.HdrTypes hdrType) throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            int srcPort;
            InetAddress srcAddress;
            long srcIA;
            this.ensureBound();
            buffer.clear();
            if (path instanceof ResponsePath) {
                ResponsePath rPath = (ResponsePath)path;
                srcIA = rPath.getLocalIsdAs();
                srcAddress = rPath.getLocalAddress();
                srcPort = rPath.getLocalPort();
            } else {
                srcIA = this.getOrCreateService().getLocalIsdAs();
                if (this.overrideExternalAddress != null) {
                    srcAddress = this.overrideExternalAddress.getAddress();
                    srcPort = this.overrideExternalAddress.getPort();
                } else {
                    srcAddress = this.localAddress.isAnyLocalAddress() ? this.getOrCreateService().getExternalIP(path.getFirstHopAddress()) : this.localAddress;
                    srcPort = ((InetSocketAddress)this.channel.getLocalAddress()).getPort();
                    if (srcPort == 0) {
                        throw new IllegalStateException("Local port is 0. This happens after calling disconnect(). Please connect() or bind() before send() or write().");
                    }
                }
            }
            byte[] rawPath = path.getRawPath();
            ScionHeaderParser.write(buffer, payloadLength, rawPath.length, srcIA, srcAddress.getAddress(), path.getRemoteIsdAs(), path.getRemoteAddress().getAddress(), hdrType, this.cfgTrafficClass);
            ScionHeaderParser.writePath(buffer, rawPath);
            if (hdrType == InternalConstants.HdrTypes.UDP) {
                int dstPort = path.getRemotePort();
                ScionHeaderParser.writeUdpOverlayHeader(buffer, payloadLength, srcPort, dstPort);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RequestPath ensureUpToDate(RequestPath path) throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (Instant.now().getEpochSecond() + (long)this.cfgExpirationSafetyMargin <= path.getExpiration()) {
                return path;
            }
            RequestPath newPath = this.pathPolicy.filter(this.getOrCreateService().getPaths(path));
            if (this.isConnected()) {
                this.updateConnection(newPath, true);
            }
            return newPath;
        }
    }

    private void updateConnection(RequestPath newPath, boolean mustBeConnected) throws IOException {
        if (mustBeConnected && !this.isConnected()) {
            throw new IllegalStateException();
        }
        this.connectionPath = newPath;
        InetAddress oldLocalAddress = this.localAddress;
        if (!this.isBoundToAddress) {
            this.localAddress = this.getOrCreateService().getExternalIP(newPath.getFirstHopAddress());
            if (!Objects.equals(this.localAddress, oldLocalAddress)) {
                this.resizeBuffers(this.localAddress);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean validate(ByteBuffer buffer) throws ScionException {
        Object object = this.stateLock;
        synchronized (object) {
            String validationResult = ScionHeaderParser.validate(buffer.asReadOnlyBuffer());
            if (validationResult != null && this.cfgReportFailedValidation) {
                throw new ScionException(validationResult);
            }
            return validationResult == null;
        }
    }

    protected ReentrantLock readLock() {
        return this.readLock;
    }

    protected ReentrantLock writeLock() {
        return this.writeLock;
    }
}

