/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import org.scion.jpan.AbstractDatagramChannel;
import org.scion.jpan.Path;
import org.scion.jpan.RequestPath;
import org.scion.jpan.ResponsePath;
import org.scion.jpan.ScionException;
import org.scion.jpan.ScionService;
import org.scion.jpan.internal.InternalConstants;
import org.scion.jpan.internal.ScionHeaderParser;

public class DatagramChannel
extends AbstractDatagramChannel<DatagramChannel>
implements ByteChannel,
Closeable {
    protected DatagramChannel(ScionService service, java.nio.channels.DatagramChannel channel) throws IOException {
        super(service, channel);
    }

    public static DatagramChannel open() throws IOException {
        return DatagramChannel.open(null);
    }

    public static DatagramChannel open(ScionService service) throws IOException {
        return DatagramChannel.open(service, java.nio.channels.DatagramChannel.open());
    }

    public static DatagramChannel open(ScionService service, java.nio.channels.DatagramChannel channel) throws IOException {
        return new DatagramChannel(service, channel);
    }

    @Override
    public void configureBlocking(boolean block) throws IOException {
        super.configureBlocking(block);
    }

    @Override
    public boolean isBlocking() {
        return super.isBlocking();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponsePath receive(ByteBuffer userBuffer) throws IOException {
        this.readLock().lock();
        try {
            ByteBuffer buffer = this.bufferReceive();
            ResponsePath receivePath = this.receiveFromChannel(buffer, InternalConstants.HdrTypes.UDP);
            if (receivePath == null) {
                ResponsePath responsePath = null;
                return responsePath;
            }
            ScionHeaderParser.extractUserPayload(buffer, userBuffer);
            buffer.clear();
            ResponsePath responsePath = receivePath;
            return responsePath;
        }
        finally {
            this.readLock().unlock();
        }
    }

    public void send(ByteBuffer srcBuffer, SocketAddress destination) throws IOException {
        if (!(destination instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Address must be of type InetSocketAddress.");
        }
        InetSocketAddress dst = (InetSocketAddress)destination;
        RequestPath path = this.getPathPolicy().filter(this.getOrCreateService().getPaths(dst));
        this.send(srcBuffer, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path send(ByteBuffer srcBuffer, Path path) throws IOException {
        this.writeLock().lock();
        try {
            ByteBuffer buffer = this.bufferSend();
            Path actualPath = this.checkPathAndBuildHeader(buffer, path, srcBuffer.remaining() + 8, InternalConstants.HdrTypes.UDP);
            try {
                buffer.put(srcBuffer);
            }
            catch (BufferOverflowException e) {
                throw new IOException("Packet is larger than max send buffer size.");
            }
            buffer.flip();
            this.sendRaw(buffer, actualPath.getFirstHopAddress(), actualPath);
            Path path2 = actualPath;
            return path2;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        this.checkOpen();
        this.checkConnected(true);
        int oldPos = dst.position();
        this.receive(dst);
        return dst.position() - oldPos;
    }

    @Override
    public synchronized int write(ByteBuffer src) throws IOException {
        this.writeLock().lock();
        try {
            this.checkOpen();
            this.checkConnected(true);
            ByteBuffer buffer = this.bufferSend();
            int len = src.remaining();
            this.checkPathAndBuildHeader(buffer, this.getConnectionPath(), len + 8, InternalConstants.HdrTypes.UDP);
            buffer.put(src);
            buffer.flip();
            int sent = this.sendRaw(buffer, this.getConnectionPath().getFirstHopAddress(), this.getConnectionPath());
            if (sent < buffer.limit() || buffer.remaining() > 0) {
                throw new ScionException("Failed to send all data.");
            }
            int n = len - buffer.remaining();
            return n;
        }
        catch (BufferOverflowException e) {
            throw new IOException("Source buffer larger than MTU", e);
        }
        finally {
            this.writeLock().unlock();
        }
    }
}

