/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.scion.jpan.ScionUtil;

public abstract class Path {
    private final byte[] pathRaw;
    private final long dstIsdAs;
    private final InetAddress dstAddress;
    private final int dstPort;

    protected Path(byte[] rawPath, long dstIsdAs, InetAddress dstIP, int dstPort) {
        this.pathRaw = rawPath;
        this.dstIsdAs = dstIsdAs;
        this.dstAddress = dstIP;
        this.dstPort = dstPort;
    }

    public byte[] getRawPath() {
        return this.pathRaw;
    }

    public abstract InetSocketAddress getFirstHopAddress() throws UnknownHostException;

    public int getRemotePort() {
        return this.dstPort;
    }

    public InetAddress getRemoteAddress() {
        return this.dstAddress;
    }

    public long getRemoteIsdAs() {
        return this.dstIsdAs;
    }

    public String toString() {
        return "Path{rmtIsdAs=" + ScionUtil.toStringIA(this.dstIsdAs) + ", rmtAddress=" + this.dstAddress + ", rmtPort=" + this.dstPort + ", pathRaw=" + Arrays.toString(this.pathRaw) + '}';
    }
}

