/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.scion.jpan.RequestPath;

public interface PathPolicy {
    public static final PathPolicy FIRST = new First();
    public static final PathPolicy MAX_BANDWIDTH = new MaxBandwith();
    public static final PathPolicy MIN_LATENCY = new MinLatency();
    public static final PathPolicy MIN_HOPS;
    public static final PathPolicy DEFAULT;

    public RequestPath filter(List<RequestPath> var1);

    static {
        DEFAULT = MIN_HOPS = new MinHopCount();
    }

    public static class IsdDisallow
    implements PathPolicy {
        private final Set<Integer> disallowedIsds;

        public IsdDisallow(Set<Integer> disallowedIsds) {
            this.disallowedIsds = disallowedIsds;
        }

        @Override
        public RequestPath filter(List<RequestPath> paths) {
            return paths.stream().filter(this::checkPath).findAny().orElseThrow(NoSuchElementException::new);
        }

        private boolean checkPath(RequestPath path) {
            for (RequestPath.PathInterface pif : path.getInterfacesList()) {
                int isd = (int)(pif.getIsdAs() >>> 48);
                if (!this.disallowedIsds.contains(isd)) continue;
                return false;
            }
            return true;
        }
    }

    public static class IsdAllow
    implements PathPolicy {
        private final Set<Integer> allowedIsds;

        public IsdAllow(Set<Integer> allowedIsds) {
            this.allowedIsds = allowedIsds;
        }

        @Override
        public RequestPath filter(List<RequestPath> paths) {
            return paths.stream().filter(this::checkPath).findAny().orElseThrow(NoSuchElementException::new);
        }

        private boolean checkPath(RequestPath path) {
            for (RequestPath.PathInterface pif : path.getInterfacesList()) {
                int isd = (int)(pif.getIsdAs() >>> 48);
                if (this.allowedIsds.contains(isd)) continue;
                return false;
            }
            return true;
        }
    }

    public static class MinHopCount
    implements PathPolicy {
        @Override
        public RequestPath filter(List<RequestPath> paths) {
            return paths.stream().min(Comparator.comparing(path -> path.getInternalHopsList().size())).orElseThrow(NoSuchElementException::new);
        }
    }

    public static class MinLatency
    implements PathPolicy {
        @Override
        public RequestPath filter(List<RequestPath> paths) {
            return paths.stream().min(Comparator.comparing(path -> path.getLatencyList().stream().mapToLong(l -> l > 0 ? (long)l.intValue() : Integer.MAX_VALUE).reduce(0L, Long::sum))).orElseThrow(NoSuchElementException::new);
        }
    }

    public static class MaxBandwith
    implements PathPolicy {
        @Override
        public RequestPath filter(List<RequestPath> paths) {
            return paths.stream().max(Comparator.comparing(path -> Collections.min(path.getBandwidthList()))).orElseThrow(NoSuchElementException::new);
        }
    }

    public static class First
    implements PathPolicy {
        @Override
        public RequestPath filter(List<RequestPath> paths) {
            return (RequestPath)paths.stream().findFirst().orElseThrow(NoSuchElementException::new);
        }
    }
}

