/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.scion.jpan.ScionRuntimeException;
import org.scion.jpan.ScionUtil;

public class ScionAddress {
    private final long isdAs;
    private final String hostName;
    private final InetAddress ipAddress;

    private ScionAddress(long isdAs, String hostName, InetAddress ip) {
        this.hostName = hostName;
        this.ipAddress = ip;
        this.isdAs = isdAs;
    }

    static ScionAddress create(long isdAs, InetAddress address) {
        return new ScionAddress(isdAs, address.getHostName(), address);
    }

    static ScionAddress create(long isdAs, String hostName, String ipString) {
        try {
            InetAddress ip = InetAddress.getByName(ipString);
            return new ScionAddress(isdAs, hostName, ip);
        }
        catch (UnknownHostException e) {
            throw new ScionRuntimeException(e);
        }
    }

    public long getIsdAs() {
        return this.isdAs;
    }

    public String getHostName() {
        return this.hostName;
    }

    public InetAddress getInetAddress() {
        return this.ipAddress;
    }

    public int getIsd() {
        return ScionUtil.extractIsd(this.isdAs);
    }
}

