/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan;

import io.grpc.Channel;
import io.grpc.ChannelCredentials;
import io.grpc.Grpc;
import io.grpc.InsecureChannelCredentials;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.scion.jpan.DatagramChannel;
import org.scion.jpan.RequestPath;
import org.scion.jpan.ScionAddress;
import org.scion.jpan.ScionException;
import org.scion.jpan.ScionRuntimeException;
import org.scion.jpan.ScionUtil;
import org.scion.jpan.internal.DNSHelper;
import org.scion.jpan.internal.HostsFileParser;
import org.scion.jpan.internal.ScionBootstrapper;
import org.scion.jpan.internal.Segments;
import org.scion.jpan.internal.SimpleCache;
import org.scion.jpan.proto.control_plane.SegmentLookupServiceGrpc;
import org.scion.jpan.proto.daemon.Daemon;
import org.scion.jpan.proto.daemon.DaemonServiceGrpc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScionService {
    private static final Logger LOG = LoggerFactory.getLogger((String)ScionService.class.getName());
    private static final String DNS_TXT_KEY = "scion";
    private static final Object LOCK = new Object();
    private static final String ERR_INVALID_TXT = "Invalid TXT entry: ";
    private static final String ERR_INVALID_TXT_LOG = "Invalid TXT entry: {}";
    private static final String ERR_INVALID_TXT_LOG2 = "Invalid TXT entry: {} {}";
    private static ScionService defaultService = null;
    private final ScionBootstrapper bootstrapper;
    private final DaemonServiceGrpc.DaemonServiceBlockingStub daemonStub;
    private final SegmentLookupServiceGrpc.SegmentLookupServiceBlockingStub segmentStub;
    private final ManagedChannel channel;
    private static final long ISD_AS_NOT_SET = -1L;
    private final AtomicLong localIsdAs = new AtomicLong(-1L);
    private Thread shutdownHook;
    private final java.nio.channels.DatagramChannel[] ifDiscoveryChannel = new java.nio.channels.DatagramChannel[]{null};
    private final HostsFileParser hostsFile = new HostsFileParser();
    private final SimpleCache<String, ScionAddress> scionAddressCache = new SimpleCache(100);

    protected ScionService(String addressOrHost, Mode mode) {
        if (mode == Mode.DAEMON) {
            this.channel = Grpc.newChannelBuilder((String)addressOrHost, (ChannelCredentials)InsecureChannelCredentials.create()).build();
            this.daemonStub = DaemonServiceGrpc.newBlockingStub((Channel)this.channel);
            this.segmentStub = null;
            this.bootstrapper = null;
            LOG.info("Path service started with daemon {} {}", (Object)this.channel, (Object)addressOrHost);
        } else {
            if (mode == Mode.BOOTSTRAP_VIA_DNS) {
                this.bootstrapper = ScionBootstrapper.createViaDns(addressOrHost);
            } else if (mode == Mode.BOOTSTRAP_SERVER_IP) {
                this.bootstrapper = ScionBootstrapper.createViaBootstrapServerIP(addressOrHost);
            } else if (mode == Mode.BOOTSTRAP_TOPO_FILE) {
                Path file = Paths.get(addressOrHost, new String[0]);
                this.bootstrapper = ScionBootstrapper.createViaTopoFile(file);
            } else {
                throw new UnsupportedOperationException();
            }
            String csHost = this.bootstrapper.getControlServerAddress();
            this.localIsdAs.set(this.bootstrapper.getLocalIsdAs());
            this.channel = Grpc.newChannelBuilder((String)csHost, (ChannelCredentials)InsecureChannelCredentials.create()).build();
            this.daemonStub = null;
            this.segmentStub = SegmentLookupServiceGrpc.newBlockingStub((Channel)this.channel);
            LOG.info("Path service started with control service {} {}", (Object)this.channel, (Object)csHost);
        }
        this.shutdownHook = this.addShutdownHook();
        try {
            this.getLocalIsdAs();
        }
        catch (RuntimeException e) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    static ScionService defaultService() {
        Object object = LOCK;
        synchronized (object) {
            if (defaultService != null) {
                return defaultService;
            }
            String fileName = ScionUtil.getPropertyOrEnv("org.scion.bootstrap.topoFile", "SCION_BOOTSTRAP_TOPO_FILE");
            if (fileName != null) {
                defaultService = new ScionService(fileName, Mode.BOOTSTRAP_TOPO_FILE);
                return defaultService;
            }
            String server = ScionUtil.getPropertyOrEnv("org.scion.bootstrap.host", "SCION_BOOTSTRAP_HOST");
            if (server != null) {
                defaultService = new ScionService(server, Mode.BOOTSTRAP_SERVER_IP);
                return defaultService;
            }
            String naptrName = ScionUtil.getPropertyOrEnv("org.scion.bootstrap.naptr.name", "SCION_BOOTSTRAP_NAPTR_NAME");
            if (naptrName != null) {
                defaultService = new ScionService(naptrName, Mode.BOOTSTRAP_VIA_DNS);
                return defaultService;
            }
            String daemon = ScionUtil.getPropertyOrEnv("org.scion.daemon", "SCION_DAEMON", "localhost:30255");
            try {
                defaultService = new ScionService(daemon, Mode.DAEMON);
                return defaultService;
            }
            catch (ScionRuntimeException e) {
                LOG.info(e.getMessage());
                if (ScionUtil.getPropertyOrEnv("SCION_USE_OS_SEARCH_DOMAINS", "org.scion.test.useOsSearchDomains", true)) {
                    String dnsResolver = DNSHelper.searchForDiscoveryService();
                    defaultService = new ScionService(dnsResolver, Mode.BOOTSTRAP_SERVER_IP);
                    return defaultService;
                }
                throw new ScionRuntimeException("Could not connect to daemon, DNS or bootstrap resource.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeDefault() {
        Object object = LOCK;
        synchronized (object) {
            if (defaultService != null) {
                try {
                    defaultService.close();
                }
                catch (IOException e) {
                    throw new ScionRuntimeException(e);
                }
                finally {
                    defaultService = null;
                }
            }
        }
    }

    private Thread addShutdownHook() {
        Thread hook = new Thread(() -> {
            try {
                if (defaultService != null) {
                    ScionService.defaultService.shutdownHook = null;
                    defaultService.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        Runtime.getRuntime().addShutdownHook(hook);
        return hook;
    }

    public void close() throws IOException {
        try {
            if (!this.channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS) && !this.channel.shutdownNow().awaitTermination(5L, TimeUnit.SECONDS)) {
                LOG.error("Failed to shut down ScionService gRPC ManagedChannel");
            }
            if (this.shutdownHook != null) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
    }

    public DatagramChannel openChannel() throws IOException {
        return DatagramChannel.open(this);
    }

    public DatagramChannel openChannel(java.nio.channels.DatagramChannel channel) throws IOException {
        return DatagramChannel.open(this, channel);
    }

    Daemon.ASResponse getASInfo() {
        Daemon.ASResponse response;
        Daemon.ASRequest request = Daemon.ASRequest.newBuilder().setIsdAs(0L).build();
        try {
            response = this.daemonStub.aS(request);
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() == Status.Code.UNAVAILABLE) {
                throw new ScionRuntimeException("Could not connect to SCION daemon: " + e.getMessage(), e);
            }
            throw new ScionRuntimeException("Error while getting AS info: " + e.getMessage(), e);
        }
        return response;
    }

    Map<Long, Daemon.Interface> getInterfaces() {
        Daemon.InterfacesResponse response;
        Daemon.InterfacesRequest request = Daemon.InterfacesRequest.newBuilder().build();
        try {
            response = this.daemonStub.interfaces(request);
        }
        catch (StatusRuntimeException e) {
            throw new ScionRuntimeException(e);
        }
        return response.getInterfacesMap();
    }

    private List<Daemon.Path> getPathList(long srcIsdAs, long dstIsdAs) {
        if (this.daemonStub != null) {
            return this.getPathListDaemon(srcIsdAs, dstIsdAs);
        }
        return this.getPathListCS(srcIsdAs, dstIsdAs);
    }

    List<Daemon.Path> getPathListDaemon(long srcIsdAs, long dstIsdAs) {
        Daemon.PathsResponse response;
        Daemon.PathsRequest request = Daemon.PathsRequest.newBuilder().setSourceIsdAs(srcIsdAs).setDestinationIsdAs(dstIsdAs).build();
        try {
            response = this.daemonStub.paths(request);
        }
        catch (StatusRuntimeException e) {
            throw new ScionRuntimeException(e);
        }
        return response.getPathsList();
    }

    public List<RequestPath> getPaths(InetSocketAddress dstAddress) throws IOException {
        ScionAddress sa = this.getScionAddress(dstAddress.getHostName());
        return this.getPaths(sa.getIsdAs(), sa.getInetAddress(), dstAddress.getPort());
    }

    public List<RequestPath> getPaths(long dstIsdAs, InetSocketAddress dstScionAddress) {
        return this.getPaths(dstIsdAs, dstScionAddress.getAddress(), dstScionAddress.getPort());
    }

    public List<RequestPath> getPaths(RequestPath path) {
        return this.getPaths(path.getRemoteIsdAs(), path.getRemoteAddress(), path.getRemotePort());
    }

    public List<RequestPath> getPaths(long dstIsdAs, InetAddress dstAddress, int dstPort) {
        long srcIsdAs = this.getLocalIsdAs();
        List<Daemon.Path> paths = this.getPathList(srcIsdAs, dstIsdAs);
        if (paths.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RequestPath> scionPaths = new ArrayList<RequestPath>(paths.size());
        for (int i = 0; i < paths.size(); ++i) {
            scionPaths.add(RequestPath.create(paths.get(i), dstIsdAs, dstAddress, dstPort));
        }
        return scionPaths;
    }

    Map<String, Daemon.ListService> getServices() throws ScionException {
        Daemon.ServicesResponse response;
        Daemon.ServicesRequest request = Daemon.ServicesRequest.newBuilder().build();
        try {
            response = this.daemonStub.services(request);
        }
        catch (StatusRuntimeException e) {
            throw new ScionException(e);
        }
        return response.getServicesMap();
    }

    public long getLocalIsdAs() {
        if (this.localIsdAs.get() == -1L) {
            this.localIsdAs.set(this.getASInfo().getIsdAs());
        }
        return this.localIsdAs.get();
    }

    public long getIsdAs(String hostName) throws ScionException {
        ScionAddress scionAddress = this.scionAddressCache.get(hostName);
        if (scionAddress != null) {
            return scionAddress.getIsdAs();
        }
        String txtFromProperties = this.findTxtRecordInProperties(hostName);
        if (txtFromProperties != null) {
            Long result = this.parseTxtRecordToIA(txtFromProperties);
            if (result != null) {
                return result;
            }
            throw new ScionException(ERR_INVALID_TXT + txtFromProperties);
        }
        HostsFileParser.HostEntry entry = this.hostsFile.find(hostName);
        if (entry != null) {
            return entry.getIsdAs();
        }
        if (this.isLocalhost(hostName)) {
            return this.getLocalIsdAs();
        }
        Long fromDNS = DNSHelper.queryTXT(hostName, DNS_TXT_KEY, this::parseTxtRecordToIA);
        if (fromDNS != null) {
            return fromDNS;
        }
        throw new ScionException("No DNS TXT entry \"scion\" found for host: " + hostName);
    }

    public ScionAddress getScionAddress(String hostName) throws ScionException {
        ScionAddress scionAddress = this.scionAddressCache.get(hostName);
        if (scionAddress != null) {
            return scionAddress;
        }
        String txtFromProperties = this.findTxtRecordInProperties(hostName);
        if (txtFromProperties != null) {
            ScionAddress address = this.parseTxtRecord(txtFromProperties, hostName);
            if (address == null) {
                throw new ScionException(ERR_INVALID_TXT + txtFromProperties);
            }
            return address;
        }
        HostsFileParser.HostEntry entry = this.hostsFile.find(hostName);
        if (entry != null) {
            return ScionAddress.create(entry.getIsdAs(), entry.getAddress());
        }
        if (this.isLocalhost(hostName)) {
            return ScionAddress.create(this.getLocalIsdAs(), hostName, hostName);
        }
        ScionAddress fromDNS = DNSHelper.queryTXT(hostName, DNS_TXT_KEY, x -> this.parseTxtRecord((String)x, hostName));
        if (fromDNS != null) {
            return this.addToCache(fromDNS);
        }
        throw new ScionException("No DNS TXT entry \"scion\" found for host: " + hostName);
    }

    private ScionAddress addToCache(ScionAddress address) {
        this.scionAddressCache.put(address.getHostName(), address);
        this.scionAddressCache.put(address.getInetAddress().getHostAddress(), address);
        return address;
    }

    private boolean isLocalhost(String hostName) {
        return hostName.startsWith("127.0.0.") || "::1".equals(hostName) || "0:0:0:0:0:0:0:1".equals(hostName) || "localhost".equals(hostName) || "ip6-localhost".equals(hostName);
    }

    private String findTxtRecordInProperties(String hostName) throws ScionException {
        int prevChar;
        String props = System.getProperty("DEBUG_SCION_MOCK_DNS_TXT");
        if (props == null) {
            return null;
        }
        int posHost = props.indexOf(hostName);
        char nextChar = props.charAt(posHost + hostName.length());
        int n = prevChar = posHost <= 0 ? 59 : (int)props.charAt(posHost - 1);
        if (!(posHost < 0 || nextChar != '=' && nextChar != '\"' || prevChar != 59 && prevChar != 44)) {
            int posEnd;
            int posStart;
            if (prevChar == 44) {
                posStart = props.substring(0, posHost).lastIndexOf("=\"");
                posEnd = props.indexOf(59, posHost);
            } else {
                posStart = props.indexOf(61, posHost + 1);
                posEnd = props.indexOf(59, posStart + 1);
            }
            String txtRecord = posEnd > 0 ? props.substring(posStart + 1, posEnd) : props.substring(posStart + 1);
            if (!txtRecord.startsWith("\"scion=") || !txtRecord.endsWith("\"")) {
                throw new ScionException(ERR_INVALID_TXT + txtRecord);
            }
            return txtRecord.substring(DNS_TXT_KEY.length() + 2, txtRecord.length() - 1);
        }
        return null;
    }

    private ScionAddress parseTxtRecord(String txtEntry, String hostName) {
        int posComma = txtEntry.indexOf(44);
        if (posComma < 0) {
            LOG.info(ERR_INVALID_TXT_LOG, (Object)txtEntry);
            return null;
        }
        try {
            long isdAs = ScionUtil.parseIA(txtEntry.substring(0, posComma));
            return ScionAddress.create(isdAs, hostName, txtEntry.substring(posComma + 1));
        }
        catch (IllegalArgumentException e) {
            LOG.info(ERR_INVALID_TXT_LOG2, (Object)txtEntry, (Object)e.getMessage());
            return null;
        }
    }

    private Long parseTxtRecordToIA(String txtEntry) {
        int posComma = txtEntry.indexOf(44);
        if (posComma < 0) {
            LOG.info(ERR_INVALID_TXT_LOG, (Object)txtEntry);
            return null;
        }
        return ScionUtil.parseIA(txtEntry.substring(0, posComma));
    }

    List<Daemon.Path> getPathListCS(long srcIsdAs, long dstIsdAs) {
        return Segments.getPaths(this.segmentStub, this.bootstrapper, srcIsdAs, dstIsdAs);
    }

    InetAddress getExternalIP(InetSocketAddress firstHopAddress) {
        java.nio.channels.DatagramChannel[] datagramChannelArray = this.ifDiscoveryChannel;
        synchronized (this.ifDiscoveryChannel) {
            try {
                if (this.ifDiscoveryChannel[0] == null) {
                    this.ifDiscoveryChannel[0] = java.nio.channels.DatagramChannel.open();
                }
                this.ifDiscoveryChannel[0].connect(firstHopAddress);
                SocketAddress address = this.ifDiscoveryChannel[0].getLocalAddress();
                this.ifDiscoveryChannel[0].disconnect();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return ((InetSocketAddress)address).getAddress();
            }
            catch (IOException e) {
                throw new ScionRuntimeException(e);
            }
        }
    }

    protected static enum Mode {
        DAEMON,
        BOOTSTRAP_SERVER_IP,
        BOOTSTRAP_VIA_DNS,
        BOOTSTRAP_TOPO_FILE;

    }
}

