/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.scion.jpan.AbstractDatagramChannel;
import org.scion.jpan.Path;
import org.scion.jpan.PathPolicy;
import org.scion.jpan.RequestPath;
import org.scion.jpan.ResponsePath;
import org.scion.jpan.Scion;
import org.scion.jpan.ScionService;
import org.scion.jpan.Scmp;
import org.scion.jpan.internal.InternalConstants;
import org.scion.jpan.internal.PathHeaderParser;
import org.scion.jpan.internal.ScionHeaderParser;
import org.scion.jpan.internal.ScmpParser;

public class ScmpChannel
implements AutoCloseable {
    private int timeOutMs = 1000;
    private final InternalChannel channel;

    ScmpChannel(RequestPath path) throws IOException {
        this(Scion.defaultService(), path, 12345);
    }

    ScmpChannel(ScionService service, RequestPath path, int port) throws IOException {
        this.channel = new InternalChannel(service, path, port);
    }

    public Scmp.EchoMessage sendEchoRequest(int sequenceNumber, ByteBuffer data) throws IOException {
        RequestPath path = (RequestPath)this.channel.getConnectionPath();
        Scmp.EchoMessage request = Scmp.EchoMessage.createRequest(sequenceNumber, path, data);
        this.sendScmpRequest(() -> this.channel.sendEchoRequest(request), Scmp.TypeCode.TYPE_129);
        return request;
    }

    public List<Scmp.TracerouteMessage> sendTracerouteRequest() throws IOException {
        ArrayList<Scmp.TracerouteMessage> requests = new ArrayList<Scmp.TracerouteMessage>();
        RequestPath path = (RequestPath)this.channel.getConnectionPath();
        ArrayList<PathHeaderParser.Node> nodes = PathHeaderParser.getTraceNodes(path.getRawPath());
        for (int i = 0; i < nodes.size(); ++i) {
            Scmp.TracerouteMessage request = Scmp.TracerouteMessage.createRequest(i, path);
            requests.add(request);
            PathHeaderParser.Node node = (PathHeaderParser.Node)nodes.get(i);
            this.sendScmpRequest(() -> this.channel.sendTracerouteRequest(request, node), Scmp.TypeCode.TYPE_131);
            if (request.isTimedOut()) break;
        }
        return requests;
    }

    private void sendScmpRequest(IOCallable<Scmp.TimedMessage> sender, Scmp.TypeCode expectedTypeCode) throws IOException {
        long sendNanos = System.nanoTime();
        Scmp.TimedMessage result = sender.call();
        long nanos = System.nanoTime() - sendNanos;
        if (result.getTypeCode() == expectedTypeCode) {
            result.setNanoSeconds(nanos);
        } else if (result.isTimedOut()) {
            result.setNanoSeconds((long)this.timeOutMs * 1000000L);
        } else {
            throw new IOException("SCMP error: " + result.getTypeCode().getText());
        }
    }

    public void setTimeOut(int milliSeconds) {
        this.timeOutMs = milliSeconds;
    }

    public int getTimeOut() {
        return this.timeOutMs;
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    public Consumer<Scmp.Message> setScmpErrorListener(Consumer<Scmp.Message> listener) {
        return this.channel.setScmpErrorListener(listener);
    }

    public <T> void setOption(SocketOption<T> option, T t) throws IOException {
        this.channel.setOption(option, t);
    }

    public RequestPath getConnectionPath() {
        return (RequestPath)this.channel.getConnectionPath();
    }

    public InetSocketAddress getLocalAddress() throws IOException {
        return this.channel.getLocalAddress();
    }

    public InetSocketAddress getRemoteAddress() throws IOException {
        return this.channel.getRemoteAddress();
    }

    public synchronized PathPolicy getPathPolicy() {
        return this.channel.getPathPolicy();
    }

    public synchronized void setPathPolicy(PathPolicy pathPolicy) throws IOException {
        this.channel.setPathPolicy(pathPolicy);
    }

    @Deprecated
    public synchronized void setOverrideSourceAddress(InetSocketAddress overrideSourceAddress) {
        this.channel.setOverrideSourceAddress(overrideSourceAddress);
    }

    private class InternalChannel
    extends AbstractDatagramChannel<InternalChannel> {
        private final Selector selector;

        protected InternalChannel(ScionService service, RequestPath path, int port) throws IOException {
            super(service);
            this.selector = Selector.open();
            super.channel().configureBlocking(false);
            super.channel().register(this.selector, 1);
            super.bind(new InetSocketAddress("[::]", port));
            super.connect(path);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized Scmp.TimedMessage sendEchoRequest(Scmp.EchoMessage request) throws IOException {
            try {
                Path path = request.getPath();
                super.channel().connect(path.getFirstHopAddress());
                ByteBuffer buffer = this.bufferSend();
                int len = 8 + request.getData().length;
                this.buildHeader(buffer, request.getPath(), len, InternalConstants.HdrTypes.SCMP);
                ScmpParser.buildScmpPing(buffer, this.getLocalAddress().getPort(), request.getSequenceNumber(), request.getData());
                buffer.flip();
                request.setSizeSent(buffer.remaining());
                this.sendRaw(buffer, path.getFirstHopAddress());
                this.receiveRequest(request);
                request.setSizeReceived(this.bufferReceive().position());
                Scmp.EchoMessage echoMessage = request;
                return echoMessage;
            }
            finally {
                if (super.channel().isConnected()) {
                    super.channel().disconnect();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized Scmp.TimedMessage sendTracerouteRequest(Scmp.TracerouteMessage request, PathHeaderParser.Node node) throws IOException {
            try {
                Path path = request.getPath();
                super.channel().connect(path.getFirstHopAddress());
                ByteBuffer buffer = this.bufferSend();
                int len = 24;
                this.buildHeader(buffer, path, len, InternalConstants.HdrTypes.SCMP);
                int interfaceNumber = request.getSequenceNumber();
                ScmpParser.buildScmpTraceroute(buffer, this.getLocalAddress().getPort(), interfaceNumber);
                buffer.flip();
                int posPath = ScionHeaderParser.extractPathHeaderPosition(buffer);
                buffer.put(posPath + node.posHopFlags, node.hopFlags);
                this.sendRaw(buffer, path.getFirstHopAddress());
                this.receiveRequest(request);
                Scmp.TracerouteMessage tracerouteMessage = request;
                return tracerouteMessage;
            }
            finally {
                if (super.channel().isConnected()) {
                    super.channel().disconnect();
                }
            }
        }

        synchronized void receiveRequest(Scmp.TimedMessage request) throws IOException {
            ResponsePath receivePath = this.receiveWithTimeout(this.bufferReceive());
            if (receivePath != null) {
                ScmpParser.consume(this.bufferReceive(), request);
                request.setPath(receivePath);
                this.checkListeners(request);
            } else {
                request.setTimedOut();
            }
        }

        private ResponsePath receiveWithTimeout(ByteBuffer buffer) throws IOException {
            InetSocketAddress srcAddress;
            while (true) {
                buffer.clear();
                if (this.selector.select(ScmpChannel.this.timeOutMs) == 0) {
                    return null;
                }
                Iterator<SelectionKey> iter = this.selector.selectedKeys().iterator();
                if (!iter.hasNext()) continue;
                SelectionKey key = iter.next();
                iter.remove();
                if (!key.isReadable()) continue;
                DatagramChannel incoming = (DatagramChannel)key.channel();
                srcAddress = (InetSocketAddress)incoming.receive(buffer);
                buffer.flip();
                if (!this.validate(buffer)) continue;
                InternalConstants.HdrTypes hdrType = ScionHeaderParser.extractNextHeader(buffer);
                buffer.position(ScionHeaderParser.extractHeaderLength(buffer));
                hdrType = super.receiveExtensionHeader(buffer, hdrType);
                if (hdrType == InternalConstants.HdrTypes.SCMP) break;
            }
            return ScionHeaderParser.extractResponsePath(buffer, srcAddress);
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.selector.close();
        }
    }

    @FunctionalInterface
    private static interface IOCallable<V> {
        public V call() throws IOException;
    }
}

