/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan.internal;

public class ByteUtil {
    public static int readInt(int input, int bitOffset, int bitCount) {
        int mask = -1 >>> 32 - bitCount;
        int shift = 32 - bitOffset - bitCount;
        return input >>> shift & mask;
    }

    public static long readLong(long input, int bitOffset, int bitCount) {
        long mask = -1L >>> 64 - bitCount;
        int shift = 64 - bitOffset - bitCount;
        return input >>> shift & mask;
    }

    public static boolean readBoolean(int input, int bitOffset) {
        int shift = 32 - bitOffset - 1;
        int mask = 1;
        return (input >>> shift & mask) != 0;
    }

    public static int writeInt(int dst, int bitOffset, int bitLength, int value) {
        int mask = value << 32 - bitOffset - bitLength;
        return dst | mask;
    }

    public static int write16(int dst, int bitOffset, int value) {
        int mask = (value & 0xFFFF) << 32 - bitOffset - 16;
        return dst | mask;
    }

    public static int writeBool(int dst, int bitOffset, boolean value) {
        int mask = value ? 1 << 31 - bitOffset : 0;
        return dst | mask;
    }

    public static long writeInt(long dst, int bitOffset, int bitLength, int value) {
        long mask = Integer.toUnsignedLong(value) << 64 - bitOffset - bitLength;
        return dst | mask;
    }

    public static long writeLong(long dst, int bitOffset, int bitLength, long value) {
        long mask = value << 64 - bitOffset - bitLength;
        return dst | mask;
    }

    public static long writeBool(long dst, int bitOffset, boolean value) {
        long mask = value ? 1L << 31 - bitOffset : 0L;
        return dst | mask;
    }

    public static byte toByte(int code) {
        return (byte)(code <= 127 ? code : code - 256);
    }

    public static short toShort(long code) {
        return (short)(code <= 32767L ? code : code - 65536L);
    }

    public static int toInt(long code) {
        return (int)(code <= Integer.MAX_VALUE ? code : code - 0x100000000L);
    }

    public static int toUnsigned(byte code) {
        return code >= 0 ? code : code + 256;
    }

    public static int toUnsigned(short code) {
        return code >= 0 ? code : code + 65536;
    }

    public static class MutLong {
        public long v;

        MutLong(long v) {
            this.v = v;
        }

        public long get() {
            return this.v;
        }

        public void set(long l) {
            this.v = l;
        }
    }
}

