/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan.internal;

import java.io.IOException;
import java.net.InetAddress;
import java.util.function.Function;
import org.scion.jpan.ScionRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.AAAARecord;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.NAPTRRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.TXTRecord;
import org.xbill.DNS.TextParseException;

public class DNSHelper {
    private static final Logger LOG = LoggerFactory.getLogger(DNSHelper.class);
    private static final String STR_X_SCION = "x-sciondiscovery";
    private static final String STR_X_SCION_TCP = "x-sciondiscovery:tcp";
    private static final String ERR_PARSING_TXT = "Error parsing TXT entry: ";
    private static final String ERR_PARSING_TXT_LOG = "Error parsing TXT entry: {}";
    private static final String ERR_PARSING_TXT_LOG2 = "Error parsing TXT entry: {} {}";

    private DNSHelper() {
    }

    public static <R> R queryTXT(String hostName, String key, Function<String, R> valueParser) {
        String nameStr = hostName.endsWith(".") ? hostName : hostName + ".";
        try {
            return DNSHelper.queryTXT(Name.fromString((String)nameStr), key, valueParser);
        }
        catch (TextParseException e) {
            LOG.info(ERR_PARSING_TXT_LOG, (Object)e.getMessage());
            return null;
        }
    }

    public static <R> R queryTXT(Name name, String key, Function<String, R> valueParser) {
        Record[] records = new Lookup(name, 16).run();
        if (records == null) {
            return null;
        }
        for (int i = 0; i < records.length; ++i) {
            String data;
            R result;
            TXTRecord txt = (TXTRecord)records[i];
            String entry = txt.rdataToString();
            if (!entry.startsWith("\"" + key + "=")) continue;
            if (entry.endsWith("\"") && (result = valueParser.apply(data = entry.substring(key.length() + 2, entry.length() - 1))) != null) {
                return result;
            }
            LOG.info(ERR_PARSING_TXT_LOG, (Object)entry);
        }
        return null;
    }

    public static InetAddress queryA(Name hostName) {
        Record[] recordsA = new Lookup(hostName, 1).run();
        if (recordsA == null) {
            throw new ScionRuntimeException("No DNS A entry found for host: " + hostName);
        }
        return ((ARecord)recordsA[0]).getAddress();
    }

    public static InetAddress queryAAAA(Name hostName) {
        Record[] recordsA = new Lookup(hostName, 28).run();
        if (recordsA == null) {
            throw new ScionRuntimeException("No DNS AAAA entry found for host: " + hostName);
        }
        return ((AAAARecord)recordsA[0]).getAddress();
    }

    public static String searchForDiscoveryService() {
        for (Name domain : Lookup.getDefaultSearchPath()) {
            String a = DNSHelper.getScionDiscoveryAddress(domain);
            if (a == null) continue;
            return a;
        }
        return null;
    }

    public static String getScionDiscoveryAddress(String hostName) throws IOException {
        return DNSHelper.getScionDiscoveryAddress(Name.fromString((String)hostName));
    }

    private static String getScionDiscoveryAddress(Name hostName) {
        Record[] records = new Lookup(hostName, 35).run();
        if (records == null) {
            return null;
        }
        for (int i = 0; i < records.length; ++i) {
            NAPTRRecord nr = (NAPTRRecord)records[i];
            String naptrService = nr.getService();
            if (!STR_X_SCION_TCP.equals(naptrService)) continue;
            String naptrFlag = nr.getFlags();
            int port = DNSHelper.getScionDiscoveryPort(hostName);
            if ("A".equals(naptrFlag)) {
                InetAddress addr = DNSHelper.queryA(nr.getReplacement());
                return addr.getHostAddress() + ":" + port;
            }
            if (!"AAAA".equals(naptrFlag)) continue;
            InetAddress addr = DNSHelper.queryAAAA(nr.getReplacement());
            return "[" + addr.getHostAddress() + "]:" + port;
        }
        return null;
    }

    private static int getScionDiscoveryPort(Name hostName) {
        Integer discoveryPort = DNSHelper.queryTXT(hostName, STR_X_SCION, (String txtEntry) -> {
            try {
                int port = Integer.parseInt(txtEntry);
                if (port < 0 || port > 65536) {
                    LOG.info(ERR_PARSING_TXT_LOG, txtEntry);
                    return null;
                }
                return port;
            }
            catch (NumberFormatException e) {
                LOG.info(ERR_PARSING_TXT_LOG2, txtEntry, (Object)e.getMessage());
                return null;
            }
        });
        if (discoveryPort == null) {
            throw new ScionRuntimeException("Could not find valid TXT x-sciondiscovery record for host: " + hostName);
        }
        return discoveryPort;
    }
}

