/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan.internal;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.scion.jpan.ScionRuntimeException;
import org.scion.jpan.ScionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostsFileParser {
    private static final Logger LOG = LoggerFactory.getLogger(HostsFileParser.class);
    private static final String PATH_LINUX = "/etc/scion/hosts";
    private final String HOSTS_FILES = ScionUtil.getPropertyOrEnv("org.scion.hostsFiles", "SCION_HOSTS_FILES");
    private final Map<String, HostEntry> entries = new HashMap<String, HostEntry>();

    public HostsFileParser() {
        this.init();
    }

    private void init() {
        String os = System.getProperty("os.name");
        String hostsFiles = this.HOSTS_FILES != null && !this.HOSTS_FILES.isEmpty() ? this.HOSTS_FILES : ("Linux".equals(os) ? PATH_LINUX : "");
        for (String file : hostsFiles.split(";")) {
            Path path = Paths.get(file, new String[0]);
            if (!Files.exists(path, new LinkOption[0]) || !Files.isRegularFile(path, new LinkOption[0])) {
                LOG.info("/etc/scion/hosts not found.");
                return;
            }
            try (Stream<String> lines = Files.lines(path);){
                lines.forEach(this::parseLine);
            }
            catch (IOException e) {
                throw new ScionRuntimeException(e);
            }
        }
    }

    private void parseLine(String line) {
        try {
            String hostName;
            String s = line.trim();
            if (s.isEmpty() || s.startsWith("#")) {
                return;
            }
            String[] lineParts = s.split("\\s+");
            HostsFileParser.check(lineParts.length >= 2, "Expected ` `");
            String[] addrParts = lineParts[0].split(",");
            HostsFileParser.check(addrParts.length == 2, "Expected `,`");
            long isdIa = ScionUtil.parseIA(addrParts[0]);
            HostsFileParser.check(addrParts[1].startsWith("["), "Expected `[` before address");
            HostsFileParser.check(addrParts[1].endsWith("]"), "Expected `]` after address");
            String addrStr = addrParts[1].substring(1, addrParts[1].length() - 1).trim();
            HostsFileParser.check(!addrStr.isEmpty(), "Address is empty");
            InetAddress inetAddr = InetAddress.getByName(addrStr);
            for (int i = 1; i < lineParts.length && !(hostName = lineParts[i]).startsWith("#"); ++i) {
                this.entries.put(hostName, new HostEntry(isdIa, inetAddr, hostName));
            }
            this.entries.put(inetAddr.getHostName(), new HostEntry(isdIa, inetAddr, inetAddr.getHostName()));
            this.entries.put(addrStr, new HostEntry(isdIa, inetAddr, addrStr));
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException | UnknownHostException e) {
            LOG.info("ERROR {} while parsing file {}: {}", new Object[]{e.getMessage(), PATH_LINUX, line});
        }
    }

    private static void check(boolean pass, String msg) {
        if (!pass) {
            throw new IllegalArgumentException(msg);
        }
    }

    public HostEntry find(String hostName) {
        return this.entries.get(hostName);
    }

    public static class HostEntry {
        private final long isdAs;
        private final String hostName;
        private final InetAddress address;

        HostEntry(long isdAs, InetAddress address, String hostName) {
            this.isdAs = isdAs;
            this.hostName = hostName;
            this.address = address;
        }

        public long getIsdAs() {
            return this.isdAs;
        }

        public String getHostName() {
            return this.hostName;
        }

        public InetAddress getAddress() {
            return this.address;
        }
    }
}

