/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan.internal;

import java.nio.ByteBuffer;
import org.scion.jpan.Scmp;
import org.scion.jpan.internal.ByteUtil;
import org.scion.jpan.internal.InternalConstants;

public class ScmpParser {
    private ScmpParser() {
    }

    public static void buildExtensionHeader(ByteBuffer buffer, InternalConstants.HdrTypes nextHdr) {
        int len = 8;
        buffer.put(ByteUtil.toByte(nextHdr.code));
        buffer.put(ByteUtil.toByte((len + 3) / 4 - 1));
        buffer.putShort((short)0);
        buffer.putInt(0);
    }

    public static void buildScmpPing(ByteBuffer buffer, int identifier, int sequenceNumber, byte[] data) {
        buffer.put(ByteUtil.toByte(Scmp.Type.INFO_128.id()));
        buffer.put(ByteUtil.toByte(0));
        buffer.putShort((short)0);
        buffer.putShort((short)identifier);
        buffer.putShort((short)sequenceNumber);
        buffer.put(data);
    }

    public static void buildScmpPing(ByteBuffer buffer, int identifier, int sequenceNumber, ByteBuffer data) {
        buffer.put(ByteUtil.toByte(Scmp.Type.INFO_128.id()));
        buffer.put(ByteUtil.toByte(0));
        buffer.putShort((short)0);
        buffer.putShort((short)identifier);
        buffer.putShort((short)sequenceNumber);
        buffer.put(data);
    }

    public static void buildScmpTraceroute(ByteBuffer buffer, int identifier, int sequenceNumber) {
        buffer.put(ByteUtil.toByte(Scmp.Type.INFO_130.id()));
        buffer.put(ByteUtil.toByte(0));
        buffer.putShort((short)0);
        buffer.putShort((short)identifier);
        buffer.putShort((short)sequenceNumber);
        buffer.putLong(0L);
        buffer.putLong(0L);
    }

    public static Scmp.Type extractType(ByteBuffer data) {
        return Scmp.Type.parse(ByteUtil.toUnsigned(data.get(data.position())));
    }

    public static void consume(ByteBuffer data, Scmp.Message holder) {
        int type = ByteUtil.toUnsigned(data.get());
        int code = ByteUtil.toUnsigned(data.get());
        data.getShort();
        Scmp.Type st = Scmp.Type.parse(type);
        Scmp.TypeCode sc = Scmp.TypeCode.parse(type, code);
        int short1 = ByteUtil.toUnsigned(data.getShort());
        int short2 = ByteUtil.toUnsigned(data.getShort());
        holder.setMessageArgs(sc, short1, short2);
        switch (st) {
            case INFO_128: 
            case INFO_129: {
                Scmp.EchoMessage echo = (Scmp.EchoMessage)holder;
                if (echo.getData() == null) {
                    echo.setData(new byte[data.remaining()]);
                }
                data.get(echo.getData());
                break;
            }
            case INFO_130: 
            case INFO_131: {
                long isdAs = data.getLong();
                long ifID = data.getLong();
                Scmp.TracerouteMessage trace = (Scmp.TracerouteMessage)holder;
                trace.setTracerouteArgs(isdAs, ifID);
                break;
            }
        }
    }
}

