/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan.internal;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Timestamp;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.scion.jpan.ScionRuntimeException;
import org.scion.jpan.ScionUtil;
import org.scion.jpan.internal.ByteUtil;
import org.scion.jpan.internal.MultiMap;
import org.scion.jpan.internal.ScionBootstrapper;
import org.scion.jpan.proto.control_plane.Seg;
import org.scion.jpan.proto.control_plane.SegmentLookupServiceGrpc;
import org.scion.jpan.proto.crypto.Signed;
import org.scion.jpan.proto.daemon.Daemon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Segments {
    private static final Logger LOG = LoggerFactory.getLogger((String)Segments.class.getName());

    private Segments() {
    }

    public static List<Daemon.Path> getPaths(SegmentLookupServiceGrpc.SegmentLookupServiceBlockingStub segmentStub, ScionBootstrapper brLookup, long srcIsdAs, long dstIsdAs) {
        long srcWildcard = Segments.toWildcard(srcIsdAs);
        long dstWildcard = Segments.toWildcard(dstIsdAs);
        int srcISD = ScionUtil.extractIsd(srcIsdAs);
        int dstISD = ScionUtil.extractIsd(dstIsdAs);
        if (srcIsdAs == dstIsdAs) {
            Daemon.Path.Builder path = Daemon.Path.newBuilder();
            path.setMtu(brLookup.getLocalMtu());
            path.setExpiration(Timestamp.newBuilder().setSeconds(Instant.now().getEpochSecond()).build());
            return Collections.singletonList(path.build());
        }
        long from = srcIsdAs;
        long to = dstIsdAs;
        ArrayList<List<Seg.PathSegment>> segments = new ArrayList<List<Seg.PathSegment>>();
        if (!brLookup.isLocalAsCore()) {
            List<Seg.PathSegment> segmentsUp = Segments.getSegments(segmentStub, srcIsdAs, srcWildcard);
            boolean[] containsIsdAs = Segments.containsIsdAs(segmentsUp, srcIsdAs, dstIsdAs);
            if (containsIsdAs[1]) {
                return Segments.combineSegment(segmentsUp, brLookup);
            }
            segments.add(segmentsUp);
            from = srcWildcard;
        }
        if (srcISD == dstISD) {
            List<Seg.PathSegment> segmentsCoreOrDown = Segments.getSegments(segmentStub, from, dstIsdAs);
            if (!segmentsCoreOrDown.isEmpty()) {
                segments.add(segmentsCoreOrDown);
                List<Daemon.Path> paths = Segments.combineSegments(segments, srcIsdAs, dstIsdAs, brLookup);
                if (!paths.isEmpty()) {
                    return paths;
                }
                segments.remove(segments.size() - 1);
                List<Seg.PathSegment> segmentsCore = Segments.getSegments(segmentStub, from, dstWildcard);
                segments.add(segmentsCore);
                segments.add(segmentsCoreOrDown);
                return Segments.combineSegments(segments, srcIsdAs, dstIsdAs, brLookup);
            }
            List<Seg.PathSegment> segmentsCore = Segments.getSegments(segmentStub, from, dstWildcard);
            boolean[] coreHasIA = Segments.containsIsdAs(segmentsCore, from, dstIsdAs);
            segments.add(segmentsCore);
            if (coreHasIA[1]) {
                return Segments.combineSegments(segments, srcIsdAs, dstIsdAs, brLookup);
            }
            from = dstWildcard;
            List<Seg.PathSegment> segmentsDown = Segments.getSegments(segmentStub, from, dstIsdAs);
            segments.add(segmentsDown);
            return Segments.combineSegments(segments, srcIsdAs, dstIsdAs, brLookup);
        }
        List<Seg.PathSegment> segmentsCore = Segments.getSegments(segmentStub, from, dstWildcard);
        boolean[] localCores = Segments.containsIsdAs(segmentsCore, srcIsdAs, dstIsdAs);
        segments.add(segmentsCore);
        if (localCores[1]) {
            return Segments.combineSegments(segments, srcIsdAs, dstIsdAs, brLookup);
        }
        List<Seg.PathSegment> segmentsDown = Segments.getSegments(segmentStub, dstWildcard, dstIsdAs);
        segments.add(segmentsDown);
        return Segments.combineSegments(segments, srcIsdAs, dstIsdAs, brLookup);
    }

    private static List<Seg.PathSegment> getSegments(SegmentLookupServiceGrpc.SegmentLookupServiceBlockingStub segmentStub, long srcIsdAs, long dstIsdAs) {
        if (LOG.isInfoEnabled()) {
            LOG.info("Requesting segments: {} {}", (Object)ScionUtil.toStringIA(srcIsdAs), (Object)ScionUtil.toStringIA(dstIsdAs));
        }
        Seg.SegmentsRequest request = Seg.SegmentsRequest.newBuilder().setSrcIsdAs(srcIsdAs).setDstIsdAs(dstIsdAs).build();
        try {
            long t0 = System.nanoTime();
            Seg.SegmentsResponse response = segmentStub.segments(request);
            long t1 = System.nanoTime();
            LOG.info("CS request took {} ms.", (Object)((t1 - t0) / 1000000L));
            if (response.getSegmentsMap().size() > 1) {
                throw new UnsupportedOperationException();
            }
            return Segments.getPathSegments(response);
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode().equals((Object)Status.Code.UNKNOWN) && e.getMessage().contains("TRC not found")) {
                String msg = ScionUtil.toStringIA(srcIsdAs) + " / " + ScionUtil.toStringIA(dstIsdAs);
                throw new ScionRuntimeException("Error while getting Segments: unknown src/dst ISD-AS: " + msg, e);
            }
            if (e.getStatus().getCode().equals((Object)Status.Code.UNAVAILABLE)) {
                throw new ScionRuntimeException("Error while getting Segments: cannot connect to SCION network", e);
            }
            throw new ScionRuntimeException("Error while getting Segment info: " + e.getMessage(), e);
        }
    }

    private static List<Seg.PathSegment> getPathSegments(Seg.SegmentsResponse response) {
        ArrayList<Seg.PathSegment> pathSegments = new ArrayList<Seg.PathSegment>();
        for (Map.Entry<Integer, Seg.SegmentsResponse.Segments> seg : response.getSegmentsMap().entrySet()) {
            pathSegments.addAll(seg.getValue().getSegmentsList());
        }
        return pathSegments;
    }

    private static List<Daemon.Path> combineSegments(List<List<Seg.PathSegment>> segments, long srcIsdAs, long dstIsdAs, ScionBootstrapper brLookup) {
        if (segments.size() == 1) {
            return Segments.combineSegment(segments.get(0), brLookup);
        }
        if (segments.size() == 2) {
            return Segments.combineTwoSegments(segments.get(0), segments.get(1), srcIsdAs, dstIsdAs, brLookup);
        }
        return Segments.combineThreeSegments(segments.get(0), segments.get(1), segments.get(2), srcIsdAs, dstIsdAs, brLookup);
    }

    private static List<Daemon.Path> combineSegment(List<Seg.PathSegment> segments, ScionBootstrapper brLookup) {
        ArrayList<Daemon.Path> paths = new ArrayList<Daemon.Path>();
        for (Seg.PathSegment pathSegment : segments) {
            paths.add(Segments.buildPath(brLookup, pathSegment));
        }
        return paths;
    }

    private static List<Daemon.Path> combineTwoSegments(List<Seg.PathSegment> segments0, List<Seg.PathSegment> segments1, long srcIsdAs, long dstIsdAs, ScionBootstrapper brLookup) {
        MultiMap<Long, Seg.PathSegment> segmentsMap1 = Segments.createSegmentsMap(segments1, dstIsdAs);
        ArrayList<Daemon.Path> paths = new ArrayList<Daemon.Path>();
        for (Seg.PathSegment pathSegment0 : segments0) {
            long middleIsdAs = Segments.getOtherIsdAs(srcIsdAs, pathSegment0);
            for (Seg.PathSegment pathSegment1 : segmentsMap1.get(middleIsdAs)) {
                paths.add(Segments.buildPath(brLookup, pathSegment0, pathSegment1));
            }
        }
        return paths;
    }

    private static List<Daemon.Path> combineThreeSegments(List<Seg.PathSegment> segmentsUp, List<Seg.PathSegment> segmentsCore, List<Seg.PathSegment> segmentsDown, long srcIsdAs, long dstIsdAs, ScionBootstrapper brLookup) {
        MultiMap<Long, Seg.PathSegment> upSegments = Segments.createSegmentsMap(segmentsUp, srcIsdAs);
        MultiMap<Long, Seg.PathSegment> downSegments = Segments.createSegmentsMap(segmentsDown, dstIsdAs);
        ArrayList<Daemon.Path> paths = new ArrayList<Daemon.Path>();
        for (Seg.PathSegment pathSeg : segmentsCore) {
            long[] endIAs = Segments.getEndingIAs(pathSeg);
            if (upSegments.contains(endIAs[0]) && downSegments.contains(endIAs[1])) {
                Segments.buildPath(paths, upSegments.get(endIAs[0]), pathSeg, downSegments.get(endIAs[1]), brLookup);
                continue;
            }
            if (!upSegments.contains(endIAs[1]) || !downSegments.contains(endIAs[0])) continue;
            Segments.buildPath(paths, upSegments.get(endIAs[1]), pathSeg, downSegments.get(endIAs[0]), brLookup);
        }
        return paths;
    }

    private static void buildPath(List<Daemon.Path> paths, List<Seg.PathSegment> segmentsUp, Seg.PathSegment segCore, List<Seg.PathSegment> segmentsDown, ScionBootstrapper brLookup) {
        for (Seg.PathSegment segUp : segmentsUp) {
            for (Seg.PathSegment segDown : segmentsDown) {
                paths.add(Segments.buildPath(brLookup, segUp, segCore, segDown));
            }
        }
    }

    private static Daemon.Path buildPath(ScionBootstrapper brLookup, Seg.PathSegment ... segments) {
        int i;
        Daemon.Path.Builder path = Daemon.Path.newBuilder();
        ByteBuffer raw = ByteBuffer.allocate(1000);
        Seg.SegmentInformation[] infos = new Seg.SegmentInformation[segments.length];
        for (int i2 = 0; i2 < segments.length; ++i2) {
            infos[i2] = Segments.getInfo(segments[i2]);
        }
        int pathMetaHeader = 0;
        for (int i3 = 0; i3 < segments.length; ++i3) {
            int hopCount = segments[i3].getAsEntriesCount();
            pathMetaHeader |= hopCount << 6 * (2 - i3);
        }
        raw.putInt(pathMetaHeader);
        boolean[] reversed = new boolean[segments.length];
        long startIA = brLookup.getLocalIsdAs();
        ByteUtil.MutLong endingIA = new ByteUtil.MutLong(-1L);
        for (i = 0; i < infos.length; ++i) {
            reversed[i] = Segments.isReversed(segments[i], startIA, endingIA);
            Segments.writeInfoField(raw, infos[i], reversed[i]);
            startIA = endingIA.get();
        }
        path.setMtu(brLookup.getLocalMtu());
        for (i = 0; i < segments.length; ++i) {
            Segments.writeHopFields(path, raw, 6 + i * 8, segments[i], reversed[i], infos[i]);
        }
        raw.flip();
        path.setRaw(ByteString.copyFrom((ByteBuffer)raw));
        String firstHop = brLookup.getBorderRouterAddress((int)path.getInterfaces(0).getId());
        Daemon.Underlay underlay = Daemon.Underlay.newBuilder().setAddress(firstHop).build();
        Daemon.Interface interfaceAddr = Daemon.Interface.newBuilder().setAddress(underlay).build();
        path.setInterface(interfaceAddr);
        return path.build();
    }

    private static boolean isReversed(Seg.PathSegment pathSegment, long startIA, ByteUtil.MutLong endIA) {
        Seg.ASEntrySignedBody body0 = Segments.getBody(pathSegment.getAsEntriesList().get(0));
        Seg.ASEntry asEntryN = pathSegment.getAsEntriesList().get(pathSegment.getAsEntriesCount() - 1);
        Seg.ASEntrySignedBody bodyN = Segments.getBody(asEntryN);
        if (body0.getIsdAs() == startIA) {
            endIA.set(bodyN.getIsdAs());
            return false;
        }
        if (bodyN.getIsdAs() == startIA) {
            endIA.set(body0.getIsdAs());
            return true;
        }
        throw new UnsupportedOperationException("Relevant IA is not an ending IA!");
    }

    private static long calcExpTime(long baseTime, int deltaTime) {
        return baseTime + (long)(1 + deltaTime) * 24L * 60L * 60L / 256L;
    }

    private static void writeInfoField(ByteBuffer raw, Seg.SegmentInformation info, boolean reversed) {
        int inf0 = (reversed ? 0 : 1) << 24 | info.getSegmentId();
        raw.putInt(inf0);
        raw.putInt(ByteUtil.toInt(info.getTimestamp()));
    }

    private static void writeHopFields(Daemon.Path.Builder path, ByteBuffer raw, int bytePosSegID, Seg.PathSegment pathSegment, boolean reversed, Seg.SegmentInformation info) {
        int n = pathSegment.getAsEntriesCount();
        int minExpiry = Integer.MAX_VALUE;
        for (int i = 0; i < n; ++i) {
            boolean addInterfaces;
            int pos = reversed ? n - i - 1 : i;
            Seg.ASEntrySignedBody body = Segments.getBody(pathSegment.getAsEntriesList().get(pos));
            Seg.HopField hopField = body.getHopEntry().getHopField();
            raw.put((byte)0);
            raw.put(ByteUtil.toByte(hopField.getExpTime()));
            raw.putShort(ByteUtil.toShort(hopField.getIngress()));
            raw.putShort(ByteUtil.toShort(hopField.getEgress()));
            ByteString mac = hopField.getMac();
            for (int j = 0; j < 6; ++j) {
                raw.put(mac.byteAt(j));
            }
            if (reversed && i > 0) {
                raw.put(bytePosSegID, ByteUtil.toByte(raw.get(bytePosSegID) ^ mac.byteAt(0)));
                raw.put(bytePosSegID + 1, ByteUtil.toByte(raw.get(bytePosSegID + 1) ^ mac.byteAt(1)));
            }
            minExpiry = Math.min(minExpiry, hopField.getExpTime());
            path.setMtu(Math.min(path.getMtu(), body.getMtu()));
            boolean bl = addInterfaces = reversed && pos > 0 || !reversed && pos < n - 1;
            if (!addInterfaces) continue;
            Daemon.PathInterface.Builder pib = Daemon.PathInterface.newBuilder();
            pib.setId(reversed ? hopField.getIngress() : hopField.getEgress());
            path.addInterfaces(pib.setIsdAs(body.getIsdAs()).build());
            Daemon.PathInterface.Builder pib2 = Daemon.PathInterface.newBuilder();
            int pos2 = reversed ? pos - 1 : pos + 1;
            Seg.ASEntrySignedBody body2 = Segments.getBody(pathSegment.getAsEntriesList().get(pos2));
            Seg.HopField hopField2 = body2.getHopEntry().getHopField();
            pib2.setId(reversed ? hopField2.getEgress() : hopField2.getIngress());
            path.addInterfaces(pib2.setIsdAs(body2.getIsdAs()).build());
        }
        long time = Segments.calcExpTime(info.getTimestamp(), minExpiry);
        if (time < path.getExpiration().getSeconds()) {
            path.setExpiration(Timestamp.newBuilder().setSeconds((long)minExpiry).build());
        }
    }

    private static MultiMap<Long, Seg.PathSegment> createSegmentsMap(List<Seg.PathSegment> pathSegments, long knownIsdAs) {
        MultiMap<Long, Seg.PathSegment> map = new MultiMap<Long, Seg.PathSegment>();
        for (Seg.PathSegment pathSeg : pathSegments) {
            long unknownIsdAs = Segments.getOtherIsdAs(knownIsdAs, pathSeg);
            if (unknownIsdAs == -1L) continue;
            map.put(unknownIsdAs, pathSeg);
        }
        return map;
    }

    private static long getOtherIsdAs(long isdAs, Seg.PathSegment seg) {
        long[] endings = Segments.getEndingIAs(seg);
        if (endings[0] == isdAs) {
            return endings[1];
        }
        if (endings[1] == isdAs) {
            return endings[0];
        }
        return -1L;
    }

    static long[] getEndingIAs(Seg.PathSegment seg) {
        Seg.ASEntry asEntryFirst = seg.getAsEntries(0);
        Seg.ASEntry asEntryLast = seg.getAsEntries(seg.getAsEntriesCount() - 1);
        if (!asEntryFirst.hasSigned() || !asEntryLast.hasSigned()) {
            throw new UnsupportedOperationException("Unsigned entries not (yet) supported");
        }
        Seg.ASEntrySignedBody bodyFirst = Segments.getBody(asEntryFirst.getSigned());
        Seg.ASEntrySignedBody bodyLast = Segments.getBody(asEntryLast.getSigned());
        return new long[]{bodyFirst.getIsdAs(), bodyLast.getIsdAs()};
    }

    private static Seg.ASEntrySignedBody getBody(Signed.SignedMessage sm) {
        try {
            Signed.HeaderAndBodyInternal habi = Signed.HeaderAndBodyInternal.parseFrom(sm.getHeaderAndBody());
            return Seg.ASEntrySignedBody.parseFrom(habi.getBody());
        }
        catch (InvalidProtocolBufferException e) {
            throw new ScionRuntimeException(e);
        }
    }

    private static Seg.ASEntrySignedBody getBody(Seg.ASEntry asEntry) {
        Signed.SignedMessage sm = asEntry.getSigned();
        return Segments.getBody(sm);
    }

    private static Seg.SegmentInformation getInfo(Seg.PathSegment pathSegment) {
        try {
            return Seg.SegmentInformation.parseFrom(pathSegment.getSegmentInfo());
        }
        catch (InvalidProtocolBufferException e) {
            throw new ScionRuntimeException(e);
        }
    }

    private static boolean[] containsIsdAs(List<Seg.PathSegment> segments, long srcIsdAs, long dstIsdAs) {
        boolean[] found = new boolean[]{false, false};
        for (Seg.PathSegment seg : segments) {
            Seg.ASEntry asEntryFirst = seg.getAsEntries(0);
            Seg.ASEntry asEntryLast = seg.getAsEntries(seg.getAsEntriesCount() - 1);
            if (!asEntryFirst.hasSigned() || !asEntryLast.hasSigned()) {
                throw new UnsupportedOperationException("Unsigned entries are not supported");
            }
            long iaFirst = Segments.getBody(asEntryFirst.getSigned()).getIsdAs();
            long iaLast = Segments.getBody(asEntryLast.getSigned()).getIsdAs();
            found[0] = found[0] | (iaFirst == srcIsdAs || iaLast == srcIsdAs);
            found[1] = found[1] | (iaFirst == dstIsdAs || iaLast == dstIsdAs);
        }
        return found;
    }

    private static long toWildcard(long isdAs) {
        return isdAs >>> 48 << 48;
    }
}

