/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan.socket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import org.scion.jpan.DatagramChannel;
import org.scion.jpan.ResponsePath;
import org.scion.jpan.ScionService;
import org.scion.jpan.internal.InternalConstants;
import org.scion.jpan.internal.ScionHeaderParser;

class SelectingDatagramChannel
extends DatagramChannel {
    private final Selector selector = Selector.open();
    private int timeoutMs = 0;

    SelectingDatagramChannel(ScionService service) throws IOException {
        super(service, java.nio.channels.DatagramChannel.open());
        super.channel().configureBlocking(false);
        super.channel().register(this.selector, 1);
    }

    public void setTimeOut(int timeoutMilliseconds) {
        this.timeoutMs = timeoutMilliseconds;
    }

    public int getTimeOut() {
        return this.timeoutMs;
    }

    private ResponsePath receiveFromTimeoutChannel(ByteBuffer buffer, InternalConstants.HdrTypes expectedHdrType) throws IOException {
        while (true) {
            buffer.clear();
            if (this.selector.select(this.timeoutMs) == 0) {
                return null;
            }
            Iterator<SelectionKey> iter = this.selector.selectedKeys().iterator();
            if (!iter.hasNext()) continue;
            SelectionKey key = iter.next();
            iter.remove();
            if (!key.isReadable()) continue;
            java.nio.channels.DatagramChannel incoming = (java.nio.channels.DatagramChannel)key.channel();
            InetSocketAddress srcAddress = (InetSocketAddress)incoming.receive(buffer);
            buffer.flip();
            if (!this.validate(buffer)) continue;
            InternalConstants.HdrTypes hdrType = ScionHeaderParser.extractNextHeader(buffer);
            buffer.position(ScionHeaderParser.extractHeaderLength(buffer));
            hdrType = this.receiveExtensionHeader(buffer, hdrType);
            ResponsePath path = ScionHeaderParser.extractResponsePath(buffer, srcAddress);
            if (hdrType == expectedHdrType) {
                return path;
            }
            this.receiveScmp(buffer, path);
        }
    }

    @Override
    public synchronized ResponsePath receive(ByteBuffer userBuffer) throws IOException {
        ResponsePath receivePath = this.receiveFromTimeoutChannel(this.bufferReceive(), InternalConstants.HdrTypes.UDP);
        if (receivePath == null) {
            return null;
        }
        ScionHeaderParser.extractUserPayload(this.bufferReceive(), userBuffer);
        this.bufferReceive().clear();
        return receivePath;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.selector.close();
    }

    ScionService getOrCreateService2() {
        return super.getOrCreateService();
    }
}

