/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.scion.jpan.PathMetadata;
import org.scion.jpan.ScionRuntimeException;
import org.scion.jpan.ScionSocketAddress;

public abstract class Path {
    private final byte[] pathRaw;
    private final ScionSocketAddress dstAddress;

    protected Path(byte[] rawPath, long dstIsdAs, InetAddress dstIP, int dstPort) {
        this.pathRaw = rawPath;
        this.dstAddress = ScionSocketAddress.from(this, dstIsdAs, dstIP, dstPort);
    }

    public byte[] getRawPath() {
        return this.pathRaw;
    }

    public abstract InetSocketAddress getFirstHopAddress() throws UnknownHostException;

    public int getRemotePort() {
        return this.dstAddress.getPort();
    }

    public InetAddress getRemoteAddress() {
        return this.dstAddress.getAddress();
    }

    public long getRemoteIsdAs() {
        return this.dstAddress.getIsdAs();
    }

    public ScionSocketAddress getRemoteSocketAddress() {
        return this.dstAddress;
    }

    public abstract PathMetadata getMetadata();

    public String toString() {
        try {
            return "Path{rmtAddress=" + this.dstAddress + ", firstHop=" + this.getFirstHopAddress() + ", pathRaw=" + Arrays.toString(this.getRawPath()) + '}';
        }
        catch (UnknownHostException e) {
            throw new ScionRuntimeException(e);
        }
    }
}

