/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan;

import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.scion.jpan.internal.IPHelper;
import org.scion.jpan.proto.daemon.Daemon;

public class PathMetadata {
    private final Daemon.Path pathProtoc;
    private final byte[] pathRaw;
    private final InetSocketAddress firstHop;

    static PathMetadata create(Daemon.Path path, InetAddress dstIP, int dstPort) {
        return new PathMetadata(path, dstIP, dstPort);
    }

    private PathMetadata(Daemon.Path path, InetAddress dstIP, int dstPort) {
        this.pathProtoc = path;
        this.pathRaw = path.getRaw().toByteArray();
        this.firstHop = this.getRawPath().length == 0 ? new InetSocketAddress(dstIP, dstPort) : this.getFirstHopAddress(path);
    }

    private InetSocketAddress getFirstHopAddress(Daemon.Path internalPath) {
        try {
            String underlayAddressString = internalPath.getInterface().getAddress().getAddress();
            int splitIndex = underlayAddressString.indexOf(58);
            InetAddress ip = IPHelper.toInetAddress(underlayAddressString.substring(0, splitIndex));
            int port = Integer.parseUnsignedInt(underlayAddressString.substring(splitIndex + 1));
            return new InetSocketAddress(ip, port);
        }
        catch (UnknownHostException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Daemon.Path protoPath() {
        if (this.pathProtoc == null) {
            throw new IllegalStateException("Information is only available for paths that were retrieved directly from a path server.");
        }
        return this.pathProtoc;
    }

    public InetSocketAddress getFirstHopAddress() throws UnknownHostException {
        return this.firstHop;
    }

    public byte[] getRawPath() {
        return this.pathRaw;
    }

    public Interface getInterface() {
        return new Interface(this.protoPath().getInterface());
    }

    public List<PathInterface> getInterfacesList() {
        return Collections.unmodifiableList(this.protoPath().getInterfacesList().stream().map(x$0 -> new PathInterface((Daemon.PathInterface)x$0)).collect(Collectors.toList()));
    }

    public int getMtu() {
        return this.protoPath().getMtu();
    }

    public long getExpiration() {
        return this.protoPath().getExpiration().getSeconds();
    }

    public List<Integer> getLatencyList() {
        return Collections.unmodifiableList(this.protoPath().getLatencyList().stream().map(time -> (int)(time.getSeconds() * 1000L + (long)(time.getNanos() / 1000000))).collect(Collectors.toList()));
    }

    public List<Long> getBandwidthList() {
        return this.protoPath().getBandwidthList();
    }

    public List<GeoCoordinates> getGeoList() {
        return Collections.unmodifiableList(this.protoPath().getGeoList().stream().map(x$0 -> new GeoCoordinates((Daemon.GeoCoordinates)x$0)).collect(Collectors.toList()));
    }

    public List<LinkType> getLinkTypeList() {
        return Collections.unmodifiableList(this.protoPath().getLinkTypeList().stream().map(linkType -> LinkType.values()[linkType.getNumber()]).collect(Collectors.toList()));
    }

    public List<Integer> getInternalHopsList() {
        return this.protoPath().getInternalHopsList();
    }

    public List<String> getNotesList() {
        return this.protoPath().getNotesList();
    }

    public EpicAuths getEpicAuths() {
        return new EpicAuths(this.protoPath().getEpicAuths());
    }

    public static class GeoCoordinates {
        private final float latitude;
        private final float longitude;
        private final String address;

        private GeoCoordinates(Daemon.GeoCoordinates geoCoordinates) {
            this.latitude = geoCoordinates.getLatitude();
            this.longitude = geoCoordinates.getLongitude();
            this.address = geoCoordinates.getAddress();
        }

        public float getLatitude() {
            return this.latitude;
        }

        public float getLongitude() {
            return this.longitude;
        }

        public String getAddress() {
            return this.address;
        }
    }

    public static class PathInterface {
        private final long isdAs;
        private final long id;

        private PathInterface(Daemon.PathInterface pathInterface) {
            this.isdAs = pathInterface.getIsdAs();
            this.id = pathInterface.getId();
        }

        public long getIsdAs() {
            return this.isdAs;
        }

        public long getId() {
            return this.id;
        }
    }

    public static class Interface {
        private final String address;

        private Interface(Daemon.Interface inter) {
            this.address = inter.getAddress().getAddress();
        }

        public String getAddress() {
            return this.address;
        }
    }

    public static class EpicAuths {
        private final byte[] authPhvf;
        private final byte[] authLhvf;

        private EpicAuths(Daemon.EpicAuths epicAuths) {
            this.authPhvf = epicAuths.getAuthPhvf().toByteArray();
            this.authLhvf = epicAuths.getAuthLhvf().toByteArray();
        }

        public byte[] getAuthPhvf() {
            return this.authPhvf;
        }

        public byte[] getAuthLhvf() {
            return this.authLhvf;
        }
    }

    public static enum LinkType {
        LINK_TYPE_UNSPECIFIED,
        LINK_TYPE_DIRECT,
        LINK_TYPE_MULTI_HOP,
        LINK_TYPE_OPEN_NET;

    }
}

