/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.scion.jpan.Path;
import org.scion.jpan.PathMetadata;

public interface PathPolicy {
    public static final String NO_PATH = "No path found to destination.";
    public static final PathPolicy FIRST = new First();
    public static final PathPolicy MAX_BANDWIDTH = new MaxBandwith();
    public static final PathPolicy MIN_LATENCY = new MinLatency();
    public static final PathPolicy MIN_HOPS;
    public static final PathPolicy DEFAULT;

    public Path filter(List<Path> var1);

    static {
        DEFAULT = MIN_HOPS = new MinHopCount();
    }

    public static class IsdDisallow
    implements PathPolicy {
        private final Set<Integer> disallowedIsds;

        public IsdDisallow(Set<Integer> disallowedIsds) {
            this.disallowedIsds = disallowedIsds;
        }

        @Override
        public Path filter(List<Path> paths) {
            return paths.stream().filter(this::checkPath).findAny().orElseThrow(() -> new NoSuchElementException(PathPolicy.NO_PATH));
        }

        private boolean checkPath(Path path) {
            for (PathMetadata.PathInterface pif : path.getMetadata().getInterfacesList()) {
                int isd = (int)(pif.getIsdAs() >>> 48);
                if (!this.disallowedIsds.contains(isd)) continue;
                return false;
            }
            return true;
        }
    }

    public static class IsdAllow
    implements PathPolicy {
        private final Set<Integer> allowedIsds;

        public IsdAllow(Set<Integer> allowedIsds) {
            this.allowedIsds = allowedIsds;
        }

        @Override
        public Path filter(List<Path> paths) {
            return paths.stream().filter(this::checkPath).findAny().orElseThrow(() -> new NoSuchElementException(PathPolicy.NO_PATH));
        }

        private boolean checkPath(Path path) {
            for (PathMetadata.PathInterface pif : path.getMetadata().getInterfacesList()) {
                int isd = (int)(pif.getIsdAs() >>> 48);
                if (this.allowedIsds.contains(isd)) continue;
                return false;
            }
            return true;
        }
    }

    public static class MinHopCount
    implements PathPolicy {
        @Override
        public Path filter(List<Path> paths) {
            return paths.stream().min(Comparator.comparing(path -> path.getMetadata().getInternalHopsList().size())).orElseThrow(() -> new NoSuchElementException(PathPolicy.NO_PATH));
        }
    }

    public static class MinLatency
    implements PathPolicy {
        @Override
        public Path filter(List<Path> paths) {
            return paths.stream().min(Comparator.comparing(path -> path.getMetadata().getLatencyList().stream().mapToLong(l -> l > 0 ? (long)l.intValue() : Integer.MAX_VALUE).reduce(0L, Long::sum))).orElseThrow(() -> new NoSuchElementException(PathPolicy.NO_PATH));
        }
    }

    public static class MaxBandwith
    implements PathPolicy {
        @Override
        public Path filter(List<Path> paths) {
            return paths.stream().max(Comparator.comparing(path -> Collections.min(path.getMetadata().getBandwidthList()))).orElseThrow(() -> new NoSuchElementException(PathPolicy.NO_PATH));
        }
    }

    public static class First
    implements PathPolicy {
        @Override
        public Path filter(List<Path> paths) {
            return (Path)paths.stream().findFirst().orElseThrow(() -> new NoSuchElementException(PathPolicy.NO_PATH));
        }
    }
}

