/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.scion.jpan.AbstractDatagramChannel;
import org.scion.jpan.Path;
import org.scion.jpan.PathPolicy;
import org.scion.jpan.RequestPath;
import org.scion.jpan.ResponsePath;
import org.scion.jpan.Scion;
import org.scion.jpan.ScionException;
import org.scion.jpan.ScionService;
import org.scion.jpan.Scmp;
import org.scion.jpan.internal.InternalConstants;
import org.scion.jpan.internal.PathHeaderParser;
import org.scion.jpan.internal.ScionHeaderParser;
import org.scion.jpan.internal.ScmpParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScmpChannel
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ScmpChannel.class);
    private int timeOutMs = 1000;
    private final InternalChannel channel;
    @Deprecated
    private final RequestPath path;

    ScmpChannel() throws IOException {
        this(Scion.defaultService(), 12345);
    }

    ScmpChannel(ScionService service, int port) throws IOException {
        this.channel = new InternalChannel(service, port);
        this.path = null;
    }

    @Deprecated
    ScmpChannel(RequestPath path) throws IOException {
        this(Scion.defaultService(), path, 12345);
    }

    @Deprecated
    ScmpChannel(ScionService service, RequestPath path, int port) throws IOException {
        this.channel = new InternalChannel(service, port);
        this.path = path;
    }

    @Deprecated
    public Scmp.EchoMessage sendEchoRequest(int sequenceNumber, ByteBuffer data) throws IOException {
        return this.sendEchoRequest(this.path, sequenceNumber, data);
    }

    public Scmp.EchoMessage sendEchoRequest(Path path, int sequenceNumber, ByteBuffer data) throws IOException {
        Scmp.EchoMessage request = Scmp.EchoMessage.createRequest(sequenceNumber, path, data);
        this.sendScmpRequest(() -> this.channel.sendEchoRequest(request), Scmp.TypeCode.TYPE_129);
        return request;
    }

    @Deprecated
    public List<Scmp.TracerouteMessage> sendTracerouteRequest() throws IOException {
        return this.sendTracerouteRequest(this.path);
    }

    public List<Scmp.TracerouteMessage> sendTracerouteRequest(Path path) throws IOException {
        ArrayList<Scmp.TracerouteMessage> requests = new ArrayList<Scmp.TracerouteMessage>();
        ArrayList<PathHeaderParser.Node> nodes = PathHeaderParser.getTraceNodes(path.getRawPath());
        for (int i = 0; i < nodes.size(); ++i) {
            Scmp.TracerouteMessage request = Scmp.TracerouteMessage.createRequest(i, path);
            requests.add(request);
            PathHeaderParser.Node node = (PathHeaderParser.Node)nodes.get(i);
            this.sendScmpRequest(() -> this.channel.sendTracerouteRequest(request, node), Scmp.TypeCode.TYPE_131);
            if (request.isTimedOut()) break;
        }
        return requests;
    }

    private void sendScmpRequest(IOCallable<Scmp.TimedMessage> sender, Scmp.TypeCode expectedTypeCode) throws IOException {
        long sendNanos = System.nanoTime();
        Scmp.TimedMessage result = sender.call();
        long nanos = System.nanoTime() - sendNanos;
        if (result.getTypeCode() == expectedTypeCode) {
            result.setNanoSeconds(nanos);
        } else if (result.isTimedOut()) {
            result.setNanoSeconds((long)this.timeOutMs * 1000000L);
        } else {
            throw new IOException("SCMP error: " + result.getTypeCode().getText());
        }
    }

    public void setTimeOut(int milliSeconds) {
        this.timeOutMs = milliSeconds;
    }

    public int getTimeOut() {
        return this.timeOutMs;
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    public Consumer<Scmp.Message> setScmpErrorListener(Consumer<Scmp.Message> listener) {
        return this.channel.setScmpErrorListener(listener);
    }

    public Predicate<Scmp.EchoMessage> setScmpEchoListener(Predicate<Scmp.EchoMessage> listener) {
        return this.channel.setScmpEchoListener(listener);
    }

    public <T> void setOption(SocketOption<T> option, T t) throws IOException {
        this.channel.setOption(option, t);
    }

    public void setUpScmpEchoResponder() throws IOException {
        this.channel.sendEchoResponses();
    }

    public Path getConnectionPath() {
        return this.channel.getConnectionPath();
    }

    public InetSocketAddress getLocalAddress() throws IOException {
        return this.channel.getLocalAddress();
    }

    public InetSocketAddress getRemoteAddress() throws IOException {
        return this.channel.getRemoteAddress();
    }

    public PathPolicy getPathPolicy() {
        return this.channel.getPathPolicy();
    }

    public void setPathPolicy(PathPolicy pathPolicy) throws IOException {
        this.channel.setPathPolicy(pathPolicy);
    }

    @Deprecated
    public void setOverrideSourceAddress(InetSocketAddress overrideSourceAddress) {
        this.channel.setOverrideSourceAddress(overrideSourceAddress);
    }

    private class InternalChannel
    extends AbstractDatagramChannel<InternalChannel> {
        private final Selector selector;
        private Predicate<Scmp.EchoMessage> echoListener;

        protected InternalChannel(ScionService service, int port) throws IOException {
            super(service);
            this.selector = Selector.open();
            super.channel().configureBlocking(false);
            super.channel().register(this.selector, 1);
            super.bind(new InetSocketAddress("[::]", port));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Scmp.TimedMessage sendEchoRequest(Scmp.EchoMessage request) throws IOException {
            this.writeLock().lock();
            try {
                Path path = request.getPath();
                if (path.getRawPath().length == 0 && path.getFirstHopAddress().getAddress().isAnyLocalAddress()) {
                    throw new ScionException("Cannot ping service address in local AS: " + path.getFirstHopAddress());
                }
                super.channel().connect(path.getFirstHopAddress());
                ByteBuffer buffer = this.getBufferSend(2000);
                int len = 8 + request.getData().length;
                this.buildHeader(buffer, request.getPath(), len, InternalConstants.HdrTypes.SCMP);
                int localPort = super.getLocalAddress().getPort();
                ScmpParser.buildScmpPing(buffer, Scmp.Type.INFO_128, localPort, request.getSequenceNumber(), request.getData());
                buffer.flip();
                request.setSizeSent(buffer.remaining());
                this.sendRaw(buffer, path);
                int sizeReceived = this.receive(request);
                request.setSizeReceived(sizeReceived);
                Scmp.EchoMessage echoMessage = request;
                return echoMessage;
            }
            finally {
                this.writeLock().unlock();
                if (super.channel().isConnected()) {
                    super.channel().disconnect();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Scmp.TimedMessage sendTracerouteRequest(Scmp.TracerouteMessage request, PathHeaderParser.Node node) throws IOException {
            this.writeLock().lock();
            try {
                Path path = request.getPath();
                super.channel().connect(path.getFirstHopAddress());
                ByteBuffer buffer = this.getBufferSend(2000);
                int len = 24;
                this.buildHeader(buffer, path, len, InternalConstants.HdrTypes.SCMP);
                int interfaceNumber = request.getSequenceNumber();
                int localPort = super.getLocalAddress().getPort();
                ScmpParser.buildScmpTraceroute(buffer, Scmp.Type.INFO_130, localPort, interfaceNumber);
                buffer.flip();
                int posPath = ScionHeaderParser.extractPathHeaderPosition(buffer);
                buffer.put(posPath + node.posHopFlags, node.hopFlags);
                this.sendRaw(buffer, path);
                this.receive(request);
                Scmp.TracerouteMessage tracerouteMessage = request;
                return tracerouteMessage;
            }
            finally {
                this.writeLock().unlock();
                if (super.channel().isConnected()) {
                    super.channel().disconnect();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int receive(Scmp.TimedMessage request) throws IOException {
            this.readLock().lock();
            try {
                ByteBuffer buffer = this.getBufferReceive(2000);
                ResponsePath receivePath = this.receiveWithTimeout(buffer);
                if (receivePath != null) {
                    ScmpParser.consume(buffer, request);
                    request.setPath(receivePath);
                    this.checkListeners(request);
                } else {
                    request.setTimedOut();
                }
                int n = buffer.position();
                return n;
            }
            finally {
                this.readLock().unlock();
            }
        }

        private ResponsePath receiveWithTimeout(ByteBuffer buffer) throws IOException {
            InetSocketAddress srcAddress;
            while (true) {
                buffer.clear();
                if (this.selector.select(ScmpChannel.this.timeOutMs) == 0) {
                    return null;
                }
                Iterator<SelectionKey> iter = this.selector.selectedKeys().iterator();
                if (!iter.hasNext()) continue;
                SelectionKey key = iter.next();
                iter.remove();
                if (!key.isReadable()) continue;
                DatagramChannel incoming = (DatagramChannel)key.channel();
                srcAddress = (InetSocketAddress)incoming.receive(buffer);
                buffer.flip();
                if (!this.validate(buffer)) continue;
                InternalConstants.HdrTypes hdrType = ScionHeaderParser.extractNextHeader(buffer);
                buffer.position(ScionHeaderParser.extractHeaderLength(buffer));
                hdrType = super.receiveExtensionHeader(buffer, hdrType);
                if (hdrType == InternalConstants.HdrTypes.SCMP) break;
            }
            return ScionHeaderParser.extractResponsePath(buffer, srcAddress);
        }

        void sendEchoResponses() throws IOException {
            this.readLock().lock();
            this.writeLock().lock();
            int timeOut = ScmpChannel.this.timeOutMs;
            ScmpChannel.this.setTimeOut(Integer.MAX_VALUE);
            try {
                while (true) {
                    ByteBuffer buffer;
                    ResponsePath path;
                    if ((path = this.receiveWithTimeout(buffer = this.getBufferReceive(2000))) == null) {
                        return;
                    }
                    Scmp.Type type = ScmpParser.extractType(buffer);
                    log.info("Received SCMP message {} from {}", (Object)type, (Object)path.getRemoteAddress());
                    if (type == Scmp.Type.INFO_128) {
                        Scmp.EchoMessage msg = (Scmp.EchoMessage)Scmp.createMessage(Scmp.Type.INFO_128, path);
                        ScmpParser.consume(buffer, msg);
                        if (!this.checkEchoListener(msg)) continue;
                        int len = 8 + msg.getData().length;
                        this.buildHeader(buffer, msg.getPath(), len, InternalConstants.HdrTypes.SCMP);
                        int port = msg.getIdentifier();
                        ScmpParser.buildScmpPing(buffer, Scmp.Type.INFO_129, port, msg.getSequenceNumber(), msg.getData());
                        buffer.flip();
                        msg.setSizeSent(buffer.remaining());
                        this.sendRaw(buffer, path);
                        log.info("Responded to SCMP {} from {}", (Object)type, (Object)path.getRemoteAddress());
                        continue;
                    }
                    log.info("Dropped SCMP message with type {} from {}", (Object)type, (Object)path.getRemoteAddress());
                }
            }
            finally {
                ScmpChannel.this.setTimeOut(timeOut);
                this.writeLock().unlock();
                this.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean checkEchoListener(Scmp.EchoMessage scmpMsg) {
            InternalChannel internalChannel = this;
            synchronized (internalChannel) {
                if (this.echoListener != null && scmpMsg.getTypeCode() == Scmp.TypeCode.TYPE_128) {
                    return this.echoListener.test(scmpMsg);
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Predicate<Scmp.EchoMessage> setScmpEchoListener(Predicate<Scmp.EchoMessage> listener) {
            InternalChannel internalChannel = this;
            synchronized (internalChannel) {
                Predicate<Scmp.EchoMessage> old = this.echoListener;
                this.echoListener = listener;
                return old;
            }
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.selector.close();
        }
    }

    @FunctionalInterface
    private static interface IOCallable<V> {
        public V call() throws IOException;
    }
}

