/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan.internal;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.xbill.DNS.Address;

public class IPHelper {
    private IPHelper() {
    }

    public static boolean isLocalhost(String hostName) {
        return hostName.startsWith("127.0.0.") || "::1".equals(hostName) || "0:0:0:0:0:0:0:1".equals(hostName) || "localhost".equals(hostName) || "ip6-localhost".equals(hostName);
    }

    public static byte[] lookupLocalhost(String hostName) {
        if ("localhost".equals(hostName)) {
            return new byte[]{127, 0, 0, 1};
        }
        if (hostName.startsWith("127.0.0.")) {
            return Address.toByteArray((String)hostName, (int)1);
        }
        if ("::1".equals(hostName) || "0:0:0:0:0:0:0:1".equals(hostName) || "ip6-localhost".equals(hostName)) {
            return new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
        }
        return null;
    }

    public static byte[] toByteArray(String s) {
        if ("localhost".equals(s)) {
            return new byte[]{127, 0, 0, 1};
        }
        if ("ip6-localhost".equals(s)) {
            return new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
        }
        if (s.startsWith("[")) {
            if (s.endsWith("]")) {
                s = s.substring(1, s.length() - 1);
            } else {
                return null;
            }
        }
        int family = Address.isDottedQuad((String)s) ? 1 : 2;
        return Address.toByteArray((String)s, (int)family);
    }

    public static InetAddress toInetAddress(String s) throws UnknownHostException {
        byte[] bytes = IPHelper.toByteArray(s);
        return InetAddress.getByAddress(bytes);
    }
}

