/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan.internal;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.scion.jpan.internal.ByteUtil;

public class PathRawParser {
    private static final String NL = System.lineSeparator();
    private int currINF;
    private int currHF;
    private int reserved;
    private final int[] segLen = new int[3];
    private final InfoField[] info = new InfoField[3];
    private final HopField[] hops = new HopField[64];
    private int nHops;
    private int len;

    public static PathRawParser create(byte[] rawPath) {
        PathRawParser p = new PathRawParser();
        if (rawPath.length != 0) {
            p.read(ByteBuffer.wrap(rawPath));
        }
        return p;
    }

    private PathRawParser() {
        this.info[0] = new InfoField();
        this.info[1] = new InfoField();
        this.info[2] = new InfoField();
        Arrays.setAll(this.hops, value -> new HopField());
    }

    private void read(ByteBuffer data) {
        int i;
        int start = data.position();
        int i0 = data.getInt();
        this.currINF = ByteUtil.readInt(i0, 0, 2);
        this.currHF = ByteUtil.readInt(i0, 2, 6);
        this.reserved = ByteUtil.readInt(i0, 8, 6);
        this.segLen[0] = ByteUtil.readInt(i0, 14, 6);
        this.segLen[1] = ByteUtil.readInt(i0, 20, 6);
        this.segLen[2] = ByteUtil.readInt(i0, 26, 6);
        for (i = 0; i < this.segLen.length && this.segLen[i] > 0; ++i) {
            this.info[i].read(data);
        }
        this.nHops = this.segLen[0] + this.segLen[1] + this.segLen[2];
        for (i = 0; i < this.nHops; ++i) {
            this.hops[i].read(data);
        }
        this.len = data.position() - start;
    }

    public String toString() {
        int i;
        StringBuilder s = new StringBuilder();
        s.append("currINF=").append(this.currINF).append("  currHP=").append(this.currHF);
        s.append("  reserved=").append(this.reserved);
        for (i = 0; i < this.segLen.length; ++i) {
            s.append("  seg").append(i).append("Len=").append(this.segLen[i]);
        }
        for (i = 0; i < this.segLen.length; ++i) {
            if (this.segLen[i] <= 0) continue;
            s.append(NL).append("  info").append(i).append("=").append(this.info[i]);
        }
        for (i = 0; i < this.nHops; ++i) {
            s.append(NL).append("    hop=").append(this.hops[i]);
        }
        return s.toString();
    }

    public int length() {
        return this.len;
    }

    public InfoField getInfoField(int i) {
        return this.info[i];
    }

    public int getHopFieldCount() {
        return this.nHops;
    }

    public int getHopCount() {
        return this.nHops - this.getSegmentCount();
    }

    public HopField getHopField(int i) {
        return this.hops[i];
    }

    public int getSegmentCount() {
        int nSegmentCount = 1;
        nSegmentCount += this.segLen[1] > 0 ? 1 : 0;
        return nSegmentCount += this.segLen[2] > 0 ? 1 : 0;
    }

    public int getSegLen(int i) {
        return this.segLen[i];
    }

    public static class InfoField {
        private boolean p;
        private boolean c;
        private int segID;
        private int timestampRaw;

        InfoField() {
        }

        public void read(ByteBuffer data) {
            int i0 = data.getInt();
            int i1 = data.getInt();
            this.p = ByteUtil.readBoolean(i0, 6);
            this.c = ByteUtil.readBoolean(i0, 7);
            this.segID = ByteUtil.readInt(i0, 16, 16);
            this.timestampRaw = i1;
        }

        public int length() {
            return 8;
        }

        public String toString() {
            long ts = Integer.toUnsignedLong(this.timestampRaw);
            return "P=" + this.p + ", C=" + this.c + ", segID=" + this.segID + ", timestamp=" + ts;
        }

        public long getTimestamp() {
            return Integer.toUnsignedLong(this.timestampRaw);
        }

        public boolean hasConstructionDirection() {
            return this.c;
        }

        public boolean getFlagC() {
            return this.c;
        }
    }

    public static class HopField {
        private boolean flagI;
        private boolean flagE;
        private int expiryTime;
        private int consIngress;
        private int consEgress;
        private long mac;

        HopField() {
        }

        public void read(ByteBuffer data) {
            int i0 = data.getInt();
            long l1 = data.getLong();
            this.flagI = ByteUtil.readBoolean(i0, 6);
            this.flagE = ByteUtil.readBoolean(i0, 7);
            this.expiryTime = ByteUtil.readInt(i0, 8, 8);
            this.consIngress = ByteUtil.readInt(i0, 16, 16);
            this.consEgress = (int)ByteUtil.readLong(l1, 0, 16);
            this.mac = ByteUtil.readLong(l1, 16, 48);
        }

        public String toString() {
            String s = "I=" + this.flagI + ", E=" + this.flagE + ", expiryTime=" + this.expiryTime;
            s = s + ", consIngress=" + this.consIngress + ", consEgress=" + this.consEgress + ", mac=" + this.mac;
            return s;
        }

        public int length() {
            return 12;
        }

        public int getIngress() {
            return this.consIngress;
        }

        public int getEgress() {
            return this.consEgress;
        }

        public boolean hasIngressAlert() {
            return this.flagI;
        }

        public boolean hasEgressAlert() {
            return this.flagE;
        }
    }
}

