/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan.internal;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import org.scion.jpan.ResponsePath;
import org.scion.jpan.Scmp;
import org.scion.jpan.internal.ByteUtil;
import org.scion.jpan.internal.InternalConstants;

public class ScionHeaderParser {
    private ScionHeaderParser() {
    }

    public static void extractUserPayload(ByteBuffer data, ByteBuffer userBuffer) {
        int i1 = data.getInt(4);
        int hdrLen = ByteUtil.readInt(i1, 8, 8);
        int hdrLenBytes = hdrLen * 4;
        int udpHeaderLength = 8;
        int payLoadStart = hdrLenBytes + udpHeaderLength;
        int pos = data.position();
        data.position(payLoadStart);
        int maxUserLen = userBuffer.remaining();
        if (data.limit() - payLoadStart <= maxUserLen) {
            userBuffer.put(data);
        } else {
            int oldLimit = data.limit();
            data.limit(payLoadStart + maxUserLen);
            userBuffer.put(data);
            data.limit(oldLimit);
        }
        data.position(pos);
    }

    public static ResponsePath extractResponsePath(ByteBuffer data, InetSocketAddress firstHopAddress) {
        int dstPort;
        int srcPort;
        InetAddress dstIP;
        InetAddress srcIP;
        int pos = data.position();
        int i1 = data.getInt(4);
        int i2 = data.getInt(8);
        int nextHeader = ByteUtil.readInt(i1, 0, 8);
        InternalConstants.HdrTypes hdrType = InternalConstants.HdrTypes.parse(nextHeader);
        int hdrLen = ByteUtil.readInt(i1, 8, 8);
        int hdrLenBytes = hdrLen * 4;
        int dl = ByteUtil.readInt(i2, 10, 2);
        int sl = ByteUtil.readInt(i2, 14, 2);
        long dstIsdAs = data.getLong(12);
        long srcIsdAs = data.getLong(20);
        data.position(28);
        byte[] bytesDst = new byte[(dl + 1) * 4];
        data.get(bytesDst);
        byte[] bytesSrc = new byte[(sl + 1) * 4];
        data.get(bytesSrc);
        try {
            srcIP = InetAddress.getByAddress(bytesSrc);
            dstIP = InetAddress.getByAddress(bytesDst);
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException(e);
        }
        byte[] path = new byte[hdrLenBytes - data.position()];
        if (path.length > 0) {
            data.get(path);
            ScionHeaderParser.reversePathInPlace(ByteBuffer.wrap(path));
        }
        data.position(hdrLenBytes);
        if (hdrType == InternalConstants.HdrTypes.UDP) {
            srcPort = Short.toUnsignedInt(data.getShort());
            dstPort = Short.toUnsignedInt(data.getShort());
        } else if (hdrType == InternalConstants.HdrTypes.SCMP) {
            data.position(hdrLenBytes + 4);
            dstPort = Short.toUnsignedInt(data.getShort());
            srcPort = 30041;
        } else {
            throw new UnsupportedOperationException();
        }
        data.position(pos);
        return ResponsePath.create(path, dstIsdAs, dstIP, dstPort, srcIsdAs, srcIP, srcPort, firstHopAddress);
    }

    public static InternalConstants.HdrTypes extractNextHeader(ByteBuffer data) {
        int nextHeader = ByteUtil.toUnsigned(data.get(4));
        return InternalConstants.HdrTypes.parse(nextHeader);
    }

    public static InetSocketAddress extractDestinationSocketAddress(ByteBuffer data) throws UnknownHostException {
        int start = data.position();
        InternalConstants.HdrTypes hdrType = ScionHeaderParser.extractNextHeader(data);
        int i1 = data.getInt(start + 4);
        int i2 = data.getInt(start + 8);
        int hdrLen = ByteUtil.readInt(i1, 8, 8);
        int hdrLenBytes = hdrLen * 4;
        int dl = ByteUtil.readInt(i2, 10, 2);
        data.position(start + 28);
        byte[] bytesDst = new byte[(dl + 1) * 4];
        data.get(bytesDst);
        InetAddress dstIP = InetAddress.getByAddress(bytesDst);
        int dstPort = ScionHeaderParser.extractDstPort(data, start + hdrLenBytes, hdrType);
        data.position(start);
        return new InetSocketAddress(dstIP, dstPort);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int extractDstPort(ByteBuffer data, int scmpHdrOffset, InternalConstants.HdrTypes hdrType) {
        if (hdrType == InternalConstants.HdrTypes.UDP) {
            data.position(scmpHdrOffset + 2);
            return Short.toUnsignedInt(data.getShort());
        }
        if (hdrType != InternalConstants.HdrTypes.SCMP) throw new UnsupportedOperationException();
        data.position(scmpHdrOffset);
        int type = ByteUtil.toUnsigned(data.get());
        Scmp.Type t = Scmp.Type.parse(type);
        if (t == Scmp.Type.INFO_128) return 30041;
        if (t == Scmp.Type.INFO_130) {
            return 30041;
        }
        if (t == Scmp.Type.INFO_129 || t == Scmp.Type.INFO_131) {
            data.position(scmpHdrOffset + 4);
            return Short.toUnsignedInt(data.getShort());
        }
        int code = ByteUtil.toUnsigned(data.get());
        Scmp.TypeCode tc = Scmp.TypeCode.parse(type, code);
        if (!tc.isError()) throw new UnsupportedOperationException(hdrType.name() + " " + tc.getText());
        return -1;
    }

    public static int extractHeaderLength(ByteBuffer data) {
        int hdrLen = ByteUtil.toUnsigned(data.get(5));
        return hdrLen * 4;
    }

    public static int extractPathHeaderPosition(ByteBuffer data) {
        int nextHeader = ByteUtil.toUnsigned(data.get(4));
        if (nextHeader != InternalConstants.HdrTypes.UDP.code() && nextHeader != InternalConstants.HdrTypes.SCMP.code()) {
            throw new UnsupportedOperationException("This method UDP ans SCMP headers");
        }
        int pathType = ByteUtil.toUnsigned(data.get(8));
        if (pathType == InternalConstants.PathTypes.Empty.code()) {
            return -1;
        }
        int i2 = data.getInt(8);
        int dl = ByteUtil.readInt(i2, 10, 2);
        int sl = ByteUtil.readInt(i2, 14, 2);
        int dstLen = (dl + 1) * 4;
        int srcLen = (sl + 1) * 4;
        return 28 + dstLen + srcLen;
    }

    public static String validate(ByteBuffer data) {
        int payLoadLen;
        String PRE = "SCION packet validation failed: ";
        int start = data.position();
        if (data.limit() - start < 36) {
            return "SCION packet validation failed: Invalid packet length: packet too short: " + (data.limit() - start);
        }
        int i0 = data.getInt();
        int i1 = data.getInt();
        int i2 = data.getInt();
        int version = ByteUtil.readInt(i0, 0, 4);
        if (version != 0) {
            return "SCION packet validation failed: version: expected 0, got " + version;
        }
        int nextHeader = ByteUtil.readInt(i1, 0, 8);
        if (nextHeader != InternalConstants.HdrTypes.UDP.code() && nextHeader != InternalConstants.HdrTypes.HOP_BY_HOP.code() && nextHeader != InternalConstants.HdrTypes.END_TO_END.code() && nextHeader != InternalConstants.HdrTypes.SCMP.code()) {
            return "SCION packet validation failed: nextHeader: expected {17, 200, 201, 202}, got " + nextHeader;
        }
        int hdrLen = ByteUtil.readInt(i1, 8, 8);
        int hdrLenBytes = hdrLen * 4;
        if (hdrLenBytes + (payLoadLen = ByteUtil.readInt(i1, 16, 16)) != data.limit() - start) {
            return "SCION packet validation failed: Invalid packet length: length = " + (data.limit() - start) + ", header says " + (hdrLenBytes + payLoadLen);
        }
        int pathType = ByteUtil.readInt(i2, 0, 8);
        if (pathType != 1 && pathType != 0) {
            return "SCION packet validation failed: Invalid path type: expected 0 or 1, got " + pathType;
        }
        int dt = ByteUtil.readInt(i2, 8, 2);
        int dl = ByteUtil.readInt(i2, 10, 2);
        int st = ByteUtil.readInt(i2, 12, 2);
        int sl = ByteUtil.readInt(i2, 14, 2);
        int dtdl = dt << 2 | dl;
        int stsl = st << 2 | sl;
        if (dtdl != 0 && dtdl != 3) {
            return "SCION packet validation failed: Invalid destination address type: expected 0b000 or 0b111, got " + Integer.toBinaryString(dtdl);
        }
        if (stsl != 0 && stsl != 3) {
            return "SCION packet validation failed: Invalid source address type: expected 0b000 or 0b111, got " + Integer.toBinaryString(dtdl);
        }
        int reserved = ByteUtil.readInt(i2, 16, 16);
        if (reserved != 0) {
            return "SCION packet validation failed: Invalid reserved field: expected '0b0000_0000_0000_0000', got " + Integer.toBinaryString(reserved);
        }
        long dstIsdAs = data.getLong();
        long srcIsdAs = data.getLong();
        byte[] bytesDst = new byte[(dl + 1) * 4];
        data.get(bytesDst);
        byte[] bytesSrc = new byte[(sl + 1) * 4];
        data.get(bytesSrc);
        try {
            InetAddress.getByAddress(bytesDst);
        }
        catch (UnknownHostException e) {
            return "SCION packet validation failed: Error decoding destination IP address: " + e.getMessage();
        }
        try {
            InetAddress.getByAddress(bytesSrc);
        }
        catch (UnknownHostException e) {
            return "SCION packet validation failed: Error decoding source IP address: " + e.getMessage();
        }
        byte[] path = new byte[start + hdrLenBytes - data.position()];
        data.get(path);
        if (path.length == 0 && pathType != 0) {
            return "SCION packet validation failed: Path is empty but path type is: " + pathType;
        }
        if (path.length > 0 && pathType != 1) {
            return "SCION packet validation failed: Path is not empty but path type is: " + pathType;
        }
        if (nextHeader == InternalConstants.HdrTypes.UDP.code()) {
            data.position(start + hdrLenBytes);
            int srcPort = Short.toUnsignedInt(data.getShort());
            int dstPort = Short.toUnsignedInt(data.getShort());
            if (srcPort == 0) {
                return "SCION packet validation failed: Invalid source port: " + srcPort;
            }
            if (dstPort == 0) {
                return "SCION packet validation failed: Invalid destination port: " + dstPort;
            }
        }
        data.position(start);
        return null;
    }

    public static void write(ByteBuffer data, int userPacketLength, int pathHeaderLength, long srcIsdAs, byte[] srcAddress, long dstIsdAs, byte[] dstAddress, InternalConstants.HdrTypes hdrType, int trafficClass) {
        int sl = srcAddress.length / 4 - 1;
        int dl = dstAddress.length / 4 - 1;
        int i0 = 0;
        int i1 = 0;
        int i2 = 0;
        i0 = ByteUtil.writeInt(i0, 0, 4, 0);
        i0 = ByteUtil.writeInt(i0, 4, 8, trafficClass);
        i0 = ByteUtil.writeInt(i0, 12, 20, 1);
        data.putInt(i0);
        i1 = ByteUtil.writeInt(i1, 0, 8, hdrType.code);
        int newHdrLen = (ScionHeaderParser.calcLen(pathHeaderLength, sl, dl) - 1) / 4 + 1;
        i1 = ByteUtil.writeInt(i1, 8, 8, newHdrLen);
        i1 = ByteUtil.writeInt(i1, 16, 16, userPacketLength);
        data.putInt(i1);
        i2 = ByteUtil.writeInt(i2, 0, 8, pathHeaderLength > 0 ? 1 : 0);
        i2 = ByteUtil.writeInt(i2, 8, 2, 0);
        i2 = ByteUtil.writeInt(i2, 10, 2, dl);
        i2 = ByteUtil.writeInt(i2, 12, 2, 0);
        i2 = ByteUtil.writeInt(i2, 14, 2, sl);
        i2 = ByteUtil.writeInt(i2, 16, 16, 0);
        data.putInt(i2);
        data.putLong(dstIsdAs);
        data.putLong(srcIsdAs);
        data.put(dstAddress);
        data.put(srcAddress);
    }

    private static int calcLen(int pathHeaderLength, int sl, int dl) {
        int len = 12;
        len += 16;
        len += (dl + 1) * 4;
        len += (sl + 1) * 4;
        return len += pathHeaderLength;
    }

    public static void reversePathInPlace(ByteBuffer data) {
        long info0R;
        long info2;
        int seg0LenR;
        int pos = data.position();
        int i0 = data.getInt();
        int seg0Len = ByteUtil.readInt(i0, 14, 6);
        int seg1Len = ByteUtil.readInt(i0, 20, 6);
        int seg2Len = ByteUtil.readInt(i0, 26, 6);
        int i0R = 0;
        i0R = ByteUtil.writeInt(i0R, 0, 2, 0);
        i0R = ByteUtil.writeInt(i0R, 2, 6, 0);
        i0R = ByteUtil.writeInt(i0R, 8, 6, 0);
        int n = seg2Len > 0 ? seg2Len : (seg0LenR = seg1Len > 0 ? seg1Len : seg0Len);
        int seg1LenR = seg2Len > 0 ? seg1Len : (seg1Len > 0 ? seg0Len : seg1Len);
        int seg2LenR = seg2Len > 0 ? seg0Len : seg2Len;
        i0R = ByteUtil.writeInt(i0R, 14, 6, seg0LenR);
        i0R = ByteUtil.writeInt(i0R, 20, 6, seg1LenR);
        i0R = ByteUtil.writeInt(i0R, 26, 6, seg2LenR);
        data.putInt(pos, i0R);
        int posInfo = data.position();
        long info0 = data.getLong();
        long info1 = seg1Len > 0 ? data.getLong() : 0L;
        long l = info2 = seg2Len > 0 ? data.getLong() : 0L;
        long l2 = seg2Len > 0 ? info2 : (info0R = seg1Len > 0 ? info1 : info0);
        long info1R = seg2Len > 0 ? info1 : (seg1Len > 0 ? info0 : info1);
        long info2R = seg2Len > 0 ? info0 : info2;
        data.position(posInfo);
        long currDirMask = 0x100000000000000L;
        data.putLong(info0R ^ currDirMask);
        if (seg1LenR > 0) {
            data.putLong(info1R ^ currDirMask);
        }
        if (seg2LenR > 0) {
            data.putLong(info2R ^ currDirMask);
        }
        int posHops = data.position();
        int nHops = seg0Len + seg1Len + seg2Len;
        int i = 0;
        for (int j = nHops - 1; i < j; ++i, --j) {
            int posI = posHops + i * 3 * 4;
            int posJ = posHops + j * 3 * 4;
            for (int x = 0; x < 3; ++x) {
                int dummy = data.getInt(posI + x * 4);
                data.putInt(posI + x * 4, data.getInt(posJ + x * 4));
                data.putInt(posJ + x * 4, dummy);
            }
        }
        data.position(pos);
    }

    public static void writePath(ByteBuffer data, byte[] path) {
        data.put(path);
    }

    public static void writeUdpOverlayHeader(ByteBuffer data, int packetLength, int srcPort, int dstPort) {
        int i0 = 0;
        int i1 = 0;
        i0 = ByteUtil.writeInt(i0, 0, 16, srcPort);
        i0 = ByteUtil.writeInt(i0, 16, 16, dstPort);
        i1 = ByteUtil.writeInt(i1, 0, 16, packetLength + 8);
        int checkSum = 0;
        i1 = ByteUtil.write16(i1, 16, checkSum);
        data.putInt(i0);
        data.putInt(i1);
    }
}

