/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan;

import com.google.protobuf.Empty;
import io.grpc.Channel;
import io.grpc.ChannelCredentials;
import io.grpc.Grpc;
import io.grpc.InsecureChannelCredentials;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.DatagramChannel;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.scion.jpan.Path;
import org.scion.jpan.PathPolicy;
import org.scion.jpan.RequestPath;
import org.scion.jpan.ScionAddress;
import org.scion.jpan.ScionDatagramChannel;
import org.scion.jpan.ScionException;
import org.scion.jpan.ScionRuntimeException;
import org.scion.jpan.ScionSocketAddress;
import org.scion.jpan.ScionUtil;
import org.scion.jpan.internal.DNSHelper;
import org.scion.jpan.internal.HostsFileParser;
import org.scion.jpan.internal.IPHelper;
import org.scion.jpan.internal.LocalTopology;
import org.scion.jpan.internal.ScionBootstrapper;
import org.scion.jpan.internal.Segments;
import org.scion.jpan.internal.Shim;
import org.scion.jpan.internal.SimpleCache;
import org.scion.jpan.proto.control_plane.SegmentLookupServiceGrpc;
import org.scion.jpan.proto.daemon.Daemon;
import org.scion.jpan.proto.daemon.DaemonServiceGrpc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScionService {
    private static final Logger LOG = LoggerFactory.getLogger((String)ScionService.class.getName());
    private static final String DNS_TXT_KEY = "scion";
    private static final Object LOCK = new Object();
    private static final String ERR_INVALID_TXT = "Invalid TXT entry: ";
    private static final String ERR_INVALID_TXT_LOG = "Invalid TXT entry: {}";
    private static final String ERR_INVALID_TXT_LOG2 = "Invalid TXT entry: {} {}";
    private static ScionService defaultService = null;
    private final ScionBootstrapper bootstrapper;
    private final DaemonServiceGrpc.DaemonServiceBlockingStub daemonStub;
    private final SegmentLookupServiceGrpc.SegmentLookupServiceBlockingStub segmentStub;
    private LocalTopology.DispatcherPortRange portRange;
    private final boolean minimizeRequests;
    private final ManagedChannel channel;
    private static final long ISD_AS_NOT_SET = -1L;
    private final AtomicLong localIsdAs = new AtomicLong(-1L);
    private Thread shutdownHook;
    private DatagramChannel ifDiscoveryChannel = null;
    private final Map<InetAddress, InetAddress> ifDiscoveryMap = new HashMap<InetAddress, InetAddress>();
    private final HostsFileParser hostsFile = new HostsFileParser();
    private final SimpleCache<String, ScionAddress> scionAddressCache = new SimpleCache(100);

    protected ScionService(String addressOrHost, Mode mode) {
        this.minimizeRequests = ScionUtil.getPropertyOrEnv("EXPERIMENTAL_SCION_RESOLVER_MINIMIZE_REQUESTS", "org.scion.resolver.experimentalMinimizeRequests", false);
        if (mode == Mode.DAEMON) {
            addressOrHost = IPHelper.ensurePortOrDefault(addressOrHost, 30255);
            LOG.info("Bootstrapping with daemon: target={}", (Object)addressOrHost);
            this.channel = Grpc.newChannelBuilder((String)addressOrHost, (ChannelCredentials)InsecureChannelCredentials.create()).build();
            this.daemonStub = DaemonServiceGrpc.newBlockingStub((Channel)this.channel);
            this.segmentStub = null;
            this.bootstrapper = null;
        } else {
            LOG.info("Bootstrapping with control service: mode={} target={}", (Object)mode.name(), (Object)addressOrHost);
            if (mode == Mode.BOOTSTRAP_VIA_DNS) {
                this.bootstrapper = ScionBootstrapper.createViaDns(addressOrHost);
            } else if (mode == Mode.BOOTSTRAP_SERVER_IP) {
                this.bootstrapper = ScionBootstrapper.createViaBootstrapServerIP(addressOrHost);
            } else if (mode == Mode.BOOTSTRAP_TOPO_FILE) {
                java.nio.file.Path file = Paths.get(addressOrHost, new String[0]);
                this.bootstrapper = ScionBootstrapper.createViaTopoFile(file);
            } else {
                throw new UnsupportedOperationException();
            }
            String csHost = this.bootstrapper.getLocalTopology().getControlServerAddress();
            LOG.info("Bootstrapping with control service: {}", (Object)csHost);
            this.localIsdAs.set(this.bootstrapper.getLocalTopology().getIsdAs());
            this.channel = Grpc.newChannelBuilder((String)csHost, (ChannelCredentials)InsecureChannelCredentials.create()).build();
            this.daemonStub = null;
            this.segmentStub = SegmentLookupServiceGrpc.newBlockingStub((Channel)this.channel);
        }
        this.shutdownHook = this.addShutdownHook();
        try {
            this.getLocalIsdAs();
            this.checkStartShim();
        }
        catch (RuntimeException e) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    private void checkStartShim() {
        boolean start;
        String config = ScionUtil.getPropertyOrEnv("org.scion.shim", "SCION_SHIM");
        boolean hasAllPorts = this.getLocalPortRange().hasPortRangeALL();
        boolean bl = config != null ? Boolean.parseBoolean(config) : (start = !hasAllPorts);
        if (start) {
            Shim.install(this);
        }
    }

    static ScionService defaultService() {
        Object object = LOCK;
        synchronized (object) {
            if (defaultService != null) {
                return defaultService;
            }
            String fileName = ScionUtil.getPropertyOrEnv("org.scion.bootstrap.topoFile", "SCION_BOOTSTRAP_TOPO_FILE");
            if (fileName != null) {
                defaultService = new ScionService(fileName, Mode.BOOTSTRAP_TOPO_FILE);
                return defaultService;
            }
            String server = ScionUtil.getPropertyOrEnv("org.scion.bootstrap.host", "SCION_BOOTSTRAP_HOST");
            if (server != null) {
                defaultService = new ScionService(server, Mode.BOOTSTRAP_SERVER_IP);
                return defaultService;
            }
            String naptrName = ScionUtil.getPropertyOrEnv("org.scion.bootstrap.naptr.name", "SCION_BOOTSTRAP_NAPTR_NAME");
            if (naptrName != null) {
                defaultService = new ScionService(naptrName, Mode.BOOTSTRAP_VIA_DNS);
                return defaultService;
            }
            String daemon = ScionUtil.getPropertyOrEnv("org.scion.daemon", "SCION_DAEMON", "localhost:30255");
            try {
                defaultService = new ScionService(daemon, Mode.DAEMON);
                return defaultService;
            }
            catch (ScionRuntimeException e) {
                LOG.info(e.getMessage());
                if (ScionUtil.getPropertyOrEnv("org.scion.daemon", "SCION_DAEMON") != null) {
                    throw e;
                }
                String searchDomain = ScionUtil.getPropertyOrEnv("org.scion.dnsSearchDomains", "SCION_DNS_SEARCH_DOMAINS");
                if (ScionUtil.getPropertyOrEnv("org.scion.test.useOsSearchDomains", "SCION_USE_OS_SEARCH_DOMAINS", true) || searchDomain != null) {
                    String dnsResolver = DNSHelper.searchForDiscoveryService();
                    if (dnsResolver != null) {
                        defaultService = new ScionService(dnsResolver, Mode.BOOTSTRAP_SERVER_IP);
                        return defaultService;
                    }
                    LOG.info("No DNS record found for bootstrap server.");
                    throw new ScionRuntimeException("No DNS record found for bootstrap server. This means the DNS server may not have NAPTR records for the bootstrap server or your host may not have the search domains configured in /etc/resolv.conf or similar.");
                }
                throw new ScionRuntimeException("Could not connect to daemon, DNS or bootstrap resource.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeDefault() {
        Object object = LOCK;
        synchronized (object) {
            if (defaultService != null) {
                try {
                    defaultService.close();
                }
                catch (IOException e) {
                    throw new ScionRuntimeException(e);
                }
                finally {
                    defaultService = null;
                }
            }
        }
    }

    private Thread addShutdownHook() {
        Thread hook = new Thread(() -> {
            try {
                if (defaultService != null) {
                    ScionService.defaultService.shutdownHook = null;
                    defaultService.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        Runtime.getRuntime().addShutdownHook(hook);
        return hook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            if (!this.channel.shutdown().awaitTermination(1L, TimeUnit.SECONDS) && !this.channel.shutdownNow().awaitTermination(1L, TimeUnit.SECONDS)) {
                LOG.error("Failed to shut down ScionService gRPC ManagedChannel");
            }
            Map<InetAddress, InetAddress> map = this.ifDiscoveryMap;
            synchronized (map) {
                try {
                    if (this.ifDiscoveryChannel != null) {
                        this.ifDiscoveryChannel.close();
                    }
                    this.ifDiscoveryChannel = null;
                    this.ifDiscoveryMap.clear();
                }
                catch (IOException e) {
                    throw new ScionRuntimeException(e);
                }
            }
            if (this.shutdownHook != null) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
    }

    public ScionDatagramChannel openChannel() throws IOException {
        return ScionDatagramChannel.open(this);
    }

    public ScionDatagramChannel openChannel(DatagramChannel channel) throws IOException {
        return ScionDatagramChannel.open(this, channel);
    }

    Daemon.ASResponse getASInfo() {
        Daemon.ASResponse response;
        Daemon.ASRequest request = Daemon.ASRequest.newBuilder().setIsdAs(0L).build();
        try {
            response = this.daemonStub.aS(request);
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() == Status.Code.UNAVAILABLE) {
                throw new ScionRuntimeException("Could not connect to SCION daemon: " + e.getMessage(), e);
            }
            throw new ScionRuntimeException("Error while getting AS info: " + e.getMessage(), e);
        }
        return response;
    }

    Map<Long, Daemon.Interface> getInterfaces() {
        Daemon.InterfacesResponse response;
        Daemon.InterfacesRequest request = Daemon.InterfacesRequest.newBuilder().build();
        try {
            response = this.daemonStub.interfaces(request);
        }
        catch (StatusRuntimeException e) {
            throw new ScionRuntimeException(e);
        }
        return response.getInterfacesMap();
    }

    private List<Daemon.Path> getPathList(long srcIsdAs, long dstIsdAs) {
        if (this.daemonStub != null) {
            return this.getPathListDaemon(srcIsdAs, dstIsdAs);
        }
        return this.getPathListCS(srcIsdAs, dstIsdAs);
    }

    List<Daemon.Path> getPathListDaemon(long srcIsdAs, long dstIsdAs) {
        Daemon.PathsResponse response;
        Daemon.PathsRequest request = Daemon.PathsRequest.newBuilder().setSourceIsdAs(srcIsdAs).setDestinationIsdAs(dstIsdAs).build();
        try {
            response = this.daemonStub.paths(request);
        }
        catch (StatusRuntimeException e) {
            throw new ScionRuntimeException(e);
        }
        return response.getPathsList();
    }

    public List<Path> getPaths(long dstIsdAs, InetSocketAddress dstScionAddress) {
        if (dstScionAddress instanceof ScionSocketAddress) {
            return this.getPaths(((ScionSocketAddress)dstScionAddress).getPath());
        }
        return this.getPaths(dstIsdAs, dstScionAddress.getAddress(), dstScionAddress.getPort());
    }

    public List<Path> getPaths(Path path) {
        return this.getPaths(path.getRemoteIsdAs(), path.getRemoteAddress(), path.getRemotePort());
    }

    public List<Path> getPaths(long dstIsdAs, InetAddress dstAddress, int dstPort) {
        return this.getPaths(ScionAddress.create(dstIsdAs, dstAddress), dstPort);
    }

    public Path lookupAndGetPath(String hostName, int port, PathPolicy policy) throws ScionException {
        if (policy == null) {
            policy = PathPolicy.DEFAULT;
        }
        return policy.filter(this.getPaths(this.lookupAddress(hostName), port));
    }

    public Path lookupAndGetPath(InetSocketAddress dstAddr, PathPolicy policy) throws ScionException {
        if (policy == null) {
            policy = PathPolicy.DEFAULT;
        }
        return policy.filter(this.getPaths(this.lookupAddress(dstAddr.getHostString()), dstAddr.getPort()));
    }

    private List<Path> getPaths(ScionAddress dstAddress, int dstPort) {
        long srcIsdAs = this.getLocalIsdAs();
        List<Daemon.Path> paths = this.getPathList(srcIsdAs, dstAddress.getIsdAs());
        ArrayList<Path> scionPaths = new ArrayList<Path>(paths.size());
        for (Daemon.Path path : paths) {
            scionPaths.add(RequestPath.create(path, dstAddress.getIsdAs(), dstAddress.getInetAddress(), dstPort));
        }
        return scionPaths;
    }

    Map<String, Daemon.ListService> getServices() throws ScionException {
        Daemon.ServicesResponse response;
        Daemon.ServicesRequest request = Daemon.ServicesRequest.newBuilder().build();
        try {
            response = this.daemonStub.services(request);
        }
        catch (StatusRuntimeException e) {
            throw new ScionException(e);
        }
        return response.getServicesMap();
    }

    public long getLocalIsdAs() {
        if (this.localIsdAs.get() == -1L) {
            this.localIsdAs.set(this.getASInfo().getIsdAs());
        }
        return this.localIsdAs.get();
    }

    public long getIsdAs(String hostName) throws ScionException {
        ScionAddress scionAddress = this.scionAddressCache.get(hostName);
        if (scionAddress != null) {
            return scionAddress.getIsdAs();
        }
        String txtFromProperties = this.findTxtRecordInProperties(hostName);
        if (txtFromProperties != null) {
            Long result = this.parseTxtRecordToIA(txtFromProperties);
            if (result != null) {
                return result;
            }
            throw new ScionException(ERR_INVALID_TXT + txtFromProperties);
        }
        HostsFileParser.HostEntry entry = this.hostsFile.find(hostName);
        if (entry != null) {
            return entry.getIsdAs();
        }
        if (IPHelper.isLocalhost(hostName)) {
            return this.getLocalIsdAs();
        }
        Long fromDNS = DNSHelper.queryTXT(hostName, DNS_TXT_KEY, this::parseTxtRecordToIA);
        if (fromDNS != null) {
            return fromDNS;
        }
        throw new ScionException("No DNS TXT entry \"scion\" found for host: " + hostName);
    }

    private ScionAddress lookupAddress(String hostName) throws ScionException {
        ScionAddress scionAddress = this.scionAddressCache.get(hostName);
        if (scionAddress != null) {
            return scionAddress;
        }
        String txtFromProperties = this.findTxtRecordInProperties(hostName);
        if (txtFromProperties != null) {
            ScionAddress address = this.parseTxtRecord(txtFromProperties, hostName);
            if (address == null) {
                throw new ScionException(ERR_INVALID_TXT + txtFromProperties);
            }
            return address;
        }
        HostsFileParser.HostEntry entry = this.hostsFile.find(hostName);
        if (entry != null) {
            return ScionAddress.create(entry.getIsdAs(), entry.getAddress());
        }
        byte[] localBytes = IPHelper.lookupLocalhost(hostName);
        if (localBytes != null) {
            return ScionAddress.create(this.getLocalIsdAs(), hostName, localBytes);
        }
        ScionAddress fromDNS = DNSHelper.queryTXT(hostName, DNS_TXT_KEY, x -> this.parseTxtRecord((String)x, hostName));
        if (fromDNS != null) {
            return this.addToCache(fromDNS);
        }
        throw new ScionException("No DNS TXT entry \"scion\" found for host: " + hostName);
    }

    private ScionAddress addToCache(ScionAddress address) {
        this.scionAddressCache.put(address.getHostName(), address);
        this.scionAddressCache.put(address.getInetAddress().getHostAddress(), address);
        return address;
    }

    private String findTxtRecordInProperties(String hostName) throws ScionException {
        int prevChar;
        String props = System.getProperty("DEBUG_SCION_MOCK_DNS_TXT");
        if (props == null) {
            return null;
        }
        int posHost = props.indexOf(hostName);
        char nextChar = props.charAt(posHost + hostName.length());
        int n = prevChar = posHost <= 0 ? 59 : (int)props.charAt(posHost - 1);
        if (!(posHost < 0 || nextChar != '=' && nextChar != '\"' || prevChar != 59 && prevChar != 44)) {
            int posEnd;
            int posStart;
            if (prevChar == 44) {
                posStart = props.substring(0, posHost).lastIndexOf("=\"");
                posEnd = props.indexOf(59, posHost);
            } else {
                posStart = props.indexOf(61, posHost + 1);
                posEnd = props.indexOf(59, posStart + 1);
            }
            String txtRecord = posEnd > 0 ? props.substring(posStart + 1, posEnd) : props.substring(posStart + 1);
            if (!txtRecord.startsWith("\"scion=") || !txtRecord.endsWith("\"")) {
                throw new ScionException(ERR_INVALID_TXT + txtRecord);
            }
            return txtRecord.substring(DNS_TXT_KEY.length() + 2, txtRecord.length() - 1);
        }
        return null;
    }

    private ScionAddress parseTxtRecord(String txtEntry, String hostName) {
        int posComma = txtEntry.indexOf(44);
        if (posComma < 0) {
            LOG.info(ERR_INVALID_TXT_LOG, (Object)txtEntry);
            return null;
        }
        try {
            long isdAs = ScionUtil.parseIA(txtEntry.substring(0, posComma));
            byte[] bytes = IPHelper.toByteArray(txtEntry.substring(posComma + 1));
            return ScionAddress.create(isdAs, hostName, bytes);
        }
        catch (IllegalArgumentException e) {
            LOG.info(ERR_INVALID_TXT_LOG2, (Object)txtEntry, (Object)e.getMessage());
            return null;
        }
    }

    private Long parseTxtRecordToIA(String txtEntry) {
        int posComma = txtEntry.indexOf(44);
        if (posComma < 0) {
            LOG.info(ERR_INVALID_TXT_LOG, (Object)txtEntry);
            return null;
        }
        return ScionUtil.parseIA(txtEntry.substring(0, posComma));
    }

    List<Daemon.Path> getPathListCS(long srcIsdAs, long dstIsdAs) {
        List<Daemon.Path> list = Segments.getPaths(this.segmentStub, this.bootstrapper, srcIsdAs, dstIsdAs, this.minimizeRequests);
        if (LOG.isInfoEnabled()) {
            LOG.info("Path found between {} and {}: {}", new Object[]{ScionUtil.toStringIA(srcIsdAs), ScionUtil.toStringIA(dstIsdAs), list.size()});
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InetAddress getExternalIP(InetSocketAddress firstHopAddress) {
        Map<InetAddress, InetAddress> map = this.ifDiscoveryMap;
        synchronized (map) {
            return this.ifDiscoveryMap.computeIfAbsent(firstHopAddress.getAddress(), firstHop -> {
                try {
                    if (this.ifDiscoveryChannel == null) {
                        this.ifDiscoveryChannel = DatagramChannel.open();
                    }
                    this.ifDiscoveryChannel.connect(firstHopAddress);
                    SocketAddress address = this.ifDiscoveryChannel.getLocalAddress();
                    this.ifDiscoveryChannel.disconnect();
                    return ((InetSocketAddress)address).getAddress();
                }
                catch (IOException e) {
                    throw new ScionRuntimeException(e);
                }
            });
        }
    }

    LocalTopology.DispatcherPortRange getLocalPortRange() {
        if (this.portRange == null) {
            if (this.bootstrapper != null) {
                this.portRange = this.bootstrapper.getLocalTopology().getPortRange();
            } else if (this.daemonStub != null) {
                try {
                    Daemon.PortRangeResponse response = this.daemonStub.portRange(Empty.getDefaultInstance());
                    this.portRange = LocalTopology.DispatcherPortRange.create(response.getDispatchedPortStart(), response.getDispatchedPortEnd());
                }
                catch (StatusRuntimeException e) {
                    LOG.warn("ERROR getting port range from daemon: {}", (Object)e.getMessage());
                    this.portRange = LocalTopology.DispatcherPortRange.createEmpty();
                }
            } else {
                this.portRange = LocalTopology.DispatcherPortRange.createAll();
            }
        }
        return this.portRange;
    }

    InetSocketAddress getBorderRouterAddress(int interfaceID) {
        if (this.daemonStub != null) {
            String MSG = "No border router found for interfaceID: ";
            String address = ((Daemon.Interface)this.getInterfaces().entrySet().stream().filter(entry -> (Long)entry.getKey() == (long)interfaceID).findAny().orElseThrow(() -> new ScionRuntimeException("No border router found for interfaceID: " + interfaceID)).getValue()).getAddress().getAddress();
            return IPHelper.toInetSocketAddress(address);
        }
        String address = this.bootstrapper.getLocalTopology().getBorderRouterAddress(interfaceID);
        return IPHelper.toInetSocketAddress(address);
    }

    protected static enum Mode {
        DAEMON,
        BOOTSTRAP_SERVER_IP,
        BOOTSTRAP_VIA_DNS,
        BOOTSTRAP_TOPO_FILE;

    }
}

