/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.scion.jpan.AbstractDatagramChannel;
import org.scion.jpan.ResponsePath;
import org.scion.jpan.ScionRuntimeException;
import org.scion.jpan.ScionService;
import org.scion.jpan.Scmp;
import org.scion.jpan.internal.InternalConstants;
import org.scion.jpan.internal.ScionHeaderParser;
import org.scion.jpan.internal.ScmpParser;
import org.scion.jpan.internal.Shim;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScmpResponder
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ScmpResponder.class);
    private final InternalChannel channel;

    private ScmpResponder(ScionService service, int port, DatagramChannel channel, Shim shim) {
        this.channel = new InternalChannel(service, port, channel, shim);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    public Consumer<Scmp.ErrorMessage> setScmpErrorListener(Consumer<Scmp.ErrorMessage> listener) {
        return this.channel.setScmpErrorListener(listener);
    }

    public Predicate<Scmp.EchoMessage> setScmpEchoListener(Predicate<Scmp.EchoMessage> listener) {
        return this.channel.setScmpEchoListener(listener);
    }

    public <T> void setOption(SocketOption<T> option, T t) throws IOException {
        this.channel.setOption(option, t);
    }

    public void start() throws IOException {
        this.channel.start();
        this.channel.sendEchoResponses();
    }

    public InetSocketAddress getLocalAddress() throws IOException {
        return this.channel.getLocalAddress();
    }

    public static class Builder {
        private ScionService service;
        private int port = 30041;
        private DatagramChannel channel;
        private Shim shim;

        public Builder setLocalPort(int localPort) {
            this.port = localPort;
            return this;
        }

        public Builder setService(ScionService service) {
            this.service = service;
            return this;
        }

        public ScmpResponder build() {
            ScionService service2 = this.service == null ? ScionService.defaultService() : this.service;
            try {
                this.channel = this.channel == null ? DatagramChannel.open() : this.channel;
            }
            catch (IOException e) {
                throw new ScionRuntimeException(e);
            }
            return new ScmpResponder(service2, this.port, this.channel, this.shim);
        }

        public Builder setShim(Shim shim) {
            this.shim = shim;
            return this;
        }
    }

    private static class InternalChannel
    extends AbstractDatagramChannel<InternalChannel> {
        private final Selector selector;
        private Predicate<Scmp.EchoMessage> echoListener;
        private final int port;
        private final Shim shim;

        protected InternalChannel(ScionService service, int port, DatagramChannel channel, Shim shim) {
            super(service, channel);
            this.shim = shim;
            this.port = port;
            try {
                this.selector = channel.provider().openSelector();
            }
            catch (IOException e) {
                throw new ScionRuntimeException(e);
            }
        }

        void start() throws IOException {
            super.channel().configureBlocking(false);
            super.channel().register(this.selector, 1);
            super.bind(new InetSocketAddress(this.port));
        }

        private ResponsePath receiveLoop(ByteBuffer buffer) throws IOException {
            while (this.selector.select() > 0) {
                Iterator<SelectionKey> iter = this.selector.selectedKeys().iterator();
                if (!iter.hasNext()) continue;
                SelectionKey key = iter.next();
                iter.remove();
                if (!key.isReadable()) continue;
                DatagramChannel incoming = (DatagramChannel)key.channel();
                buffer.clear();
                InetSocketAddress srcAddress = (InetSocketAddress)incoming.receive(buffer);
                buffer.flip();
                if (!this.validate(buffer)) continue;
                InternalConstants.HdrTypes hdrType = ScionHeaderParser.extractNextHeader(buffer);
                buffer.position(ScionHeaderParser.extractHeaderLength(buffer));
                hdrType = InternalChannel.receiveExtensionHeader(buffer, hdrType);
                if (hdrType != InternalConstants.HdrTypes.SCMP) {
                    if (this.shim == null) continue;
                    this.shim.forward(buffer, super.channel());
                    continue;
                }
                return ScionHeaderParser.extractResponsePath(buffer, srcAddress);
            }
            return null;
        }

        void sendEchoResponses() throws IOException {
            this.readLock().lock();
            this.writeLock().lock();
            try {
                if (this.shim != null) {
                    this.shim.signalReadiness();
                }
                while (true) {
                    ByteBuffer buffer;
                    ResponsePath path;
                    if ((path = this.receiveLoop(buffer = this.getBufferReceive(2000))) == null) {
                        return;
                    }
                    Scmp.Type type = ScmpParser.extractType(buffer);
                    log.info("Received SCMP message {} from {}", (Object)type, (Object)path.getRemoteAddress());
                    if (type == Scmp.Type.INFO_128) {
                        Scmp.EchoMessage msg = (Scmp.EchoMessage)Scmp.createMessage(Scmp.Type.INFO_128, path);
                        ScmpParser.consume(buffer, msg);
                        if (!this.checkEchoListener(msg)) continue;
                        int len = 8 + msg.getData().length;
                        this.buildHeader(buffer, msg.getPath(), len, InternalConstants.HdrTypes.SCMP);
                        int srcPort = msg.getIdentifier();
                        ScmpParser.buildScmpPing(buffer, Scmp.Type.INFO_129, srcPort, msg.getSequenceNumber(), msg.getData());
                        buffer.flip();
                        msg.setSizeSent(buffer.remaining());
                        this.sendRaw(buffer, path);
                        log.info("Responded to SCMP {} from {}", (Object)type, (Object)path.getRemoteAddress());
                        continue;
                    }
                    if (this.shim != null) {
                        this.shim.forward(buffer, super.channel());
                        continue;
                    }
                    log.info("Dropped SCMP message with type {} from {}", (Object)type, (Object)path.getRemoteAddress());
                }
            }
            finally {
                this.writeLock().unlock();
                this.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean checkEchoListener(Scmp.EchoMessage scmpMsg) {
            InternalChannel internalChannel = this;
            synchronized (internalChannel) {
                if (this.echoListener != null && scmpMsg.getTypeCode() == Scmp.TypeCode.TYPE_128) {
                    return this.echoListener.test(scmpMsg);
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Predicate<Scmp.EchoMessage> setScmpEchoListener(Predicate<Scmp.EchoMessage> listener) {
            InternalChannel internalChannel = this;
            synchronized (internalChannel) {
                Predicate<Scmp.EchoMessage> old = this.echoListener;
                this.echoListener = listener;
                return old;
            }
        }

        @Override
        public void close() throws IOException {
            this.selector.close();
            super.close();
        }
    }
}

