/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.scion.jpan.AbstractDatagramChannel;
import org.scion.jpan.Path;
import org.scion.jpan.ResponsePath;
import org.scion.jpan.ScionException;
import org.scion.jpan.ScionRuntimeException;
import org.scion.jpan.ScionService;
import org.scion.jpan.Scmp;
import org.scion.jpan.internal.InternalConstants;
import org.scion.jpan.internal.PathHeaderParser;
import org.scion.jpan.internal.ScionHeaderParser;
import org.scion.jpan.internal.ScmpParser;

public class ScmpSenderAsync
implements AutoCloseable {
    private static final int PORT_NOT_SET = -1;
    private int timeOutMs = 1000;
    private final InternalChannel channel;
    private final AtomicInteger sequenceIDs = new AtomicInteger(0);
    private final ConcurrentHashMap<Integer, TimeOutTask> timers = new ConcurrentHashMap();
    private final Timer timer = new Timer(true);
    private final Thread receiver;
    private final ResponseHandler handler;

    public static Builder newBuilder(ResponseHandler handler) {
        return new Builder(handler);
    }

    private ScmpSenderAsync(ScionService service, int port, ResponseHandler handler, DatagramChannel channel) {
        this.channel = new InternalChannel(service, port, channel);
        this.handler = handler;
        this.receiver = this.startHandler(this::receiveTask, "ScmpSender-receiver");
    }

    private Thread startHandler(Consumer<CountDownLatch> task, String name) {
        CountDownLatch barrier = new CountDownLatch(1);
        Thread thread = new Thread(() -> task.accept(barrier), name);
        thread.setDaemon(true);
        thread.start();
        try {
            if (!barrier.await(1L, TimeUnit.SECONDS)) {
                throw new IllegalStateException("Could not start receiver thread: " + name);
            }
            return thread;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ScionRuntimeException(e);
        }
    }

    private void stopHandler(Thread thread) {
        thread.interrupt();
        try {
            thread.join(100L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void abortAll() {
        for (TimeOutTask task : this.timers.values()) {
            task.cancel();
        }
        this.timers.clear();
    }

    public ResponseHandler getHandler() {
        return this.handler;
    }

    public int sendEcho(Path path, ByteBuffer payload) throws IOException {
        int sequenceId = this.sequenceIDs.getAndIncrement();
        Scmp.EchoMessage request = Scmp.EchoMessage.createRequest(sequenceId, path, payload);
        this.channel.sendEchoRequest(request);
        return sequenceId;
    }

    public List<Integer> sendTraceroute(Path path) throws IOException {
        ArrayList<Integer> requestIDs = new ArrayList<Integer>();
        ArrayList<PathHeaderParser.Node> nodes = PathHeaderParser.getTraceNodes(path.getRawPath());
        for (PathHeaderParser.Node node : nodes) {
            int sequenceId = this.sequenceIDs.getAndIncrement();
            Scmp.TracerouteMessage request = Scmp.TracerouteMessage.createRequest(sequenceId, path);
            requestIDs.add(sequenceId);
            this.channel.sendTracerouteRequest(request, node);
        }
        return requestIDs;
    }

    public int sendTracerouteLast(Path path) throws IOException {
        ArrayList<PathHeaderParser.Node> nodes = PathHeaderParser.getTraceNodes(path.getRawPath());
        if (nodes.isEmpty()) {
            return -1;
        }
        int sequenceId = this.sequenceIDs.getAndIncrement();
        Scmp.TracerouteMessage request = Scmp.TracerouteMessage.createRequest(sequenceId, path);
        this.channel.sendTracerouteRequest(request, (PathHeaderParser.Node)nodes.get(nodes.size() - 1));
        return sequenceId;
    }

    public void setTimeOut(int milliSeconds) {
        this.timeOutMs = milliSeconds;
    }

    public int getTimeOut() {
        return this.timeOutMs;
    }

    @Override
    public void close() throws IOException {
        this.timer.cancel();
        this.stopHandler(this.receiver);
        this.channel.close();
    }

    public <T> T getOption(SocketOption<T> option) throws IOException {
        return this.channel.getOption(option);
    }

    public <T> void setOption(SocketOption<T> option, T t) throws IOException {
        this.channel.setOption(option, t);
    }

    public InetSocketAddress getLocalAddress() throws IOException {
        return this.channel.getLocalAddress();
    }

    public void setOverrideSourceAddress(InetSocketAddress overrideSourceAddress) {
        this.channel.setOverrideSourceAddress(overrideSourceAddress);
    }

    private void receiveTask(CountDownLatch barrier) {
        try {
            barrier.countDown();
            this.channel.receiveAsync();
        }
        catch (Exception e) {
            this.handler.onException(e);
        }
    }

    public static class Builder {
        private ScionService service;
        private int port = -1;
        private final ResponseHandler handler;
        private DatagramChannel channel = null;

        private Builder(ResponseHandler handler) {
            this.handler = handler;
        }

        public Builder setLocalPort(int localPort) {
            this.port = localPort;
            return this;
        }

        public Builder setService(ScionService service) {
            this.service = service;
            return this;
        }

        public Builder setDatagramChannel(DatagramChannel channel) {
            this.channel = channel;
            return this;
        }

        public ScmpSenderAsync build() {
            this.service = this.service == null ? ScionService.defaultService() : this.service;
            try {
                this.channel = this.channel == null ? DatagramChannel.open() : this.channel;
                return new ScmpSenderAsync(this.service, this.port, this.handler, this.channel);
            }
            catch (IOException e) {
                throw new ScionRuntimeException(e);
            }
        }
    }

    private class TimeOutTask
    extends TimerTask {
        private final Scmp.TimedMessage request;

        TimeOutTask(Scmp.TimedMessage request) {
            this.request = request;
        }

        @Override
        public void run() {
            TimeOutTask timerTask = (TimeOutTask)ScmpSenderAsync.this.timers.remove(this.request.getSequenceNumber());
            if (timerTask != null) {
                Scmp.TimedMessage msg = timerTask.request;
                msg.setTimedOut((long)ScmpSenderAsync.this.timeOutMs * 1000000L);
                ScmpSenderAsync.this.handler.onTimeout(msg);
            }
        }
    }

    private class InternalChannel
    extends AbstractDatagramChannel<InternalChannel> {
        private final Selector selector;

        protected InternalChannel(ScionService service, int port, DatagramChannel channel) {
            super(service, channel);
            try {
                this.selector = channel.provider().openSelector();
                super.channel().configureBlocking(false);
                super.channel().register(this.selector, 1);
                if (port == -1) {
                    this.ensureBound();
                } else {
                    super.bind(new InetSocketAddress(port));
                }
            }
            catch (IOException e) {
                throw new ScionRuntimeException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sendEchoRequest(Scmp.EchoMessage request) throws IOException {
            this.writeLock().lock();
            try {
                Path path = request.getPath();
                ByteBuffer buffer = this.getBufferSend(2000);
                int len = 8 + request.getData().length;
                this.buildHeader(buffer, request.getPath(), len, InternalConstants.HdrTypes.SCMP);
                int localPort = this.getLocalPortForSend();
                ScmpParser.buildScmpPing(buffer, Scmp.Type.INFO_128, localPort, request.getSequenceNumber(), request.getData());
                buffer.flip();
                request.setSizeSent(buffer.remaining());
                this.sendRequest(request, buffer, path);
            }
            finally {
                this.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sendTracerouteRequest(Scmp.TracerouteMessage request, PathHeaderParser.Node node) throws IOException {
            this.writeLock().lock();
            try {
                Path path = request.getPath();
                ByteBuffer buffer = this.getBufferSend(2000);
                int len = 24;
                this.buildHeader(buffer, path, len, InternalConstants.HdrTypes.SCMP);
                int interfaceNumber = request.getSequenceNumber();
                int localPort = this.getLocalPortForSend();
                ScmpParser.buildScmpTraceroute(buffer, Scmp.Type.INFO_130, localPort, interfaceNumber);
                buffer.flip();
                int posPath = ScionHeaderParser.extractPathHeaderPosition(buffer);
                buffer.put(posPath + node.posHopFlags, node.hopFlags);
                this.sendRequest(request, buffer, path);
            }
            finally {
                this.writeLock().unlock();
            }
        }

        private void sendRequest(Scmp.TimedMessage request, ByteBuffer buffer, Path path) throws IOException {
            request.setSendNanoSeconds(System.nanoTime());
            TimeOutTask timerTask = new TimeOutTask(request);
            ScmpSenderAsync.this.timer.schedule((TimerTask)timerTask, ScmpSenderAsync.this.timeOutMs);
            ScmpSenderAsync.this.timers.put(request.getSequenceNumber(), timerTask);
            this.sendRaw(buffer, path);
        }

        private void receiveAsync() throws IOException {
            while (this.selector.isOpen() && this.selector.select() > 0) {
                Iterator<SelectionKey> iter = this.selector.selectedKeys().iterator();
                if (!iter.hasNext()) continue;
                SelectionKey key = iter.next();
                iter.remove();
                if (!key.isValid() || !key.isReadable()) continue;
                this.readIncomingScmp(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readIncomingScmp(SelectionKey key) throws IOException {
            this.readLock().lock();
            try {
                DatagramChannel incoming = (DatagramChannel)key.channel();
                ByteBuffer buffer = super.getBufferReceive(2000);
                buffer.clear();
                InetSocketAddress srcAddress = (InetSocketAddress)incoming.receive(buffer);
                buffer.flip();
                if (this.validate(buffer)) {
                    InternalConstants.HdrTypes hdrType = ScionHeaderParser.extractNextHeader(buffer);
                    ResponsePath receivePath = ScionHeaderParser.extractResponsePath(buffer, srcAddress);
                    int packetLength = ScionHeaderParser.extractPacketLength(buffer);
                    buffer.position(ScionHeaderParser.extractHeaderLength(buffer));
                    hdrType = InternalChannel.receiveExtensionHeader(buffer, hdrType);
                    if (hdrType != InternalConstants.HdrTypes.SCMP) {
                        return;
                    }
                    this.handleIncomingScmp(buffer, receivePath, packetLength);
                }
            }
            catch (ScionException e) {
                ScmpSenderAsync.this.handler.onException(e);
            }
            finally {
                this.readLock().unlock();
            }
        }

        private void handleIncomingScmp(ByteBuffer buffer, ResponsePath receivePath, int packetLength) {
            long currentNanos = System.nanoTime();
            int bufferStart = buffer.position();
            Scmp.Message msg = ScmpParser.consume(buffer, receivePath, packetLength);
            if (msg.getTypeCode().isError()) {
                ScmpSenderAsync.this.handler.onError((Scmp.ErrorMessage)msg);
                this.checkListeners(msg);
                return;
            }
            TimeOutTask task = (TimeOutTask)ScmpSenderAsync.this.timers.remove(msg.getSequenceNumber());
            if (task != null) {
                task.cancel();
                Scmp.TimedMessage request = task.request;
                if (msg.getTypeCode() == Scmp.TypeCode.TYPE_131) {
                    ((Scmp.TimedMessage)msg).assignRequest(request, currentNanos);
                    ScmpSenderAsync.this.handler.onResponse((Scmp.TimedMessage)msg);
                } else if (msg.getTypeCode() == Scmp.TypeCode.TYPE_129) {
                    ((Scmp.EchoMessage)msg).setSizeReceived(buffer.position() - bufferStart);
                    ((Scmp.TimedMessage)msg).assignRequest(request, currentNanos);
                    ScmpSenderAsync.this.handler.onResponse((Scmp.TimedMessage)msg);
                } else {
                    return;
                }
            }
            this.checkListeners(msg);
        }

        @Override
        public void close() throws IOException {
            this.selector.close();
            super.close();
        }
    }

    public static interface ResponseHandler {
        public void onResponse(Scmp.TimedMessage var1);

        public void onTimeout(Scmp.TimedMessage var1);

        default public void onError(Scmp.ErrorMessage msg) {
        }

        default public void onException(Throwable t) {
        }
    }
}

