/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan.internal;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.scion.jpan.internal.ByteUtil;
import org.xbill.DNS.Address;

public class IPHelper {
    private IPHelper() {
    }

    public static boolean isLocalhost(String hostName) {
        return hostName.startsWith("127.0.0.") || "::1".equals(hostName) || "0:0:0:0:0:0:0:1".equals(hostName) || "localhost".equals(hostName) || "ip6-localhost".equals(hostName);
    }

    public static byte[] lookupLocalhost(String hostName) {
        if ("localhost".equals(hostName)) {
            return new byte[]{127, 0, 0, 1};
        }
        if (hostName.startsWith("127.0.0.")) {
            return Address.toByteArray((String)hostName, (int)1);
        }
        if ("::1".equals(hostName) || "0:0:0:0:0:0:0:1".equals(hostName) || "ip6-localhost".equals(hostName)) {
            return new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
        }
        return null;
    }

    public static byte[] toByteArray(String s) {
        if ("localhost".equals(s)) {
            return new byte[]{127, 0, 0, 1};
        }
        if ("ip6-localhost".equals(s)) {
            return new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
        }
        if (s.startsWith("[")) {
            if (s.endsWith("]")) {
                s = s.substring(1, s.length() - 1);
            } else {
                return null;
            }
        }
        int family = Address.isDottedQuad((String)s) ? 1 : 2;
        return Address.toByteArray((String)s, (int)family);
    }

    public static int toPort(String s) {
        int posPort = s.lastIndexOf(":");
        return Integer.parseInt(s.substring(posPort + 1));
    }

    public static InetAddress toInetAddress(String s) throws UnknownHostException {
        byte[] bytes = IPHelper.toByteArray(s);
        return InetAddress.getByAddress(bytes);
    }

    public static InetSocketAddress toInetSocketAddress(String s) {
        int posPort = s.lastIndexOf(":");
        int port = Integer.parseInt(s.substring(posPort + 1));
        byte[] bytes = IPHelper.toByteArray(s.substring(0, posPort));
        try {
            return new InetSocketAddress(InetAddress.getByAddress(bytes), port);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String extractIP(String s) {
        int posPort = s.lastIndexOf(":");
        return s.substring(0, posPort);
    }

    public static String ensurePortOrDefault(String address, int port) {
        if (address.indexOf(46) >= 0) {
            if (address.indexOf(58) < 0) {
                return address + ":" + port;
            }
            return address;
        }
        if (address.indexOf(58) != address.lastIndexOf(58)) {
            if (address.endsWith("]")) {
                return address + ":" + port;
            }
            if (address.contains("]")) {
                return address;
            }
            return "[" + address + "]:" + port;
        }
        if (address.contains(":")) {
            return address;
        }
        if (address.matches("\\d+")) {
            return "localhost:" + address;
        }
        return address + ':' + port;
    }

    public static InetAddress getByAddress(int[] ints) {
        byte[] bytes = new byte[ints.length];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = ByteUtil.toByte(ints[i]);
        }
        try {
            return InetAddress.getByAddress(bytes);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

