/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.NotYetConnectedException;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.scion.jpan.Path;
import org.scion.jpan.PathPolicy;
import org.scion.jpan.RequestPath;
import org.scion.jpan.ResponsePath;
import org.scion.jpan.ScionException;
import org.scion.jpan.ScionService;
import org.scion.jpan.ScionSocketAddress;
import org.scion.jpan.ScionSocketOptions;
import org.scion.jpan.ScionUtil;
import org.scion.jpan.Scmp;
import org.scion.jpan.internal.ExtensionHeader;
import org.scion.jpan.internal.InternalConstants;
import org.scion.jpan.internal.LocalTopology;
import org.scion.jpan.internal.PathRawParserLight;
import org.scion.jpan.internal.ScionHeaderParser;
import org.scion.jpan.internal.ScmpParser;

abstract class AbstractDatagramChannel<C extends AbstractDatagramChannel<?>>
implements Closeable {
    protected static final int DEFAULT_BUFFER_SIZE = 2000;
    private final DatagramChannel channel;
    private ByteBuffer bufferReceive;
    private ByteBuffer bufferSend;
    private final Object stateLock = new Object();
    private final ReentrantLock readLock = new ReentrantLock();
    private final ReentrantLock writeLock = new ReentrantLock();
    private RequestPath connectionPath;
    private InetAddress localAddress;
    private boolean isBoundToAddress = false;
    private boolean cfgReportFailedValidation = false;
    private PathPolicy pathPolicy = PathPolicy.DEFAULT;
    private final ScionService service;
    private int cfgExpirationSafetyMargin = ScionUtil.getPropertyOrEnv("org.scion.pathExpiryMargin", "SCION_PATH_EXPIRY_MARGIN", 10);
    private int cfgTrafficClass;
    private Consumer<Scmp.ErrorMessage> errorListener;
    private boolean cfgRemoteDispatcher = false;
    private InetSocketAddress overrideExternalAddress = null;

    protected AbstractDatagramChannel(ScionService service, DatagramChannel channel) {
        this.channel = channel;
        this.service = service;
        this.bufferReceive = ByteBuffer.allocateDirect(2000);
        this.bufferSend = ByteBuffer.allocateDirect(2000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configureBlocking(boolean block) throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.channel.configureBlocking(block);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBlocking() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.channel.isBlocking();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PathPolicy getPathPolicy() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.pathPolicy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPathPolicy(PathPolicy pathPolicy) throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.pathPolicy = pathPolicy;
            if (this.isConnected()) {
                this.connectionPath = (RequestPath)pathPolicy.filter(this.getService().getPaths(this.connectionPath));
                this.updateConnection(this.connectionPath, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScionService getService() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.service;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DatagramChannel channel() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.channel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public C bind(InetSocketAddress address) throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.channel.bind(address);
            this.isBoundToAddress = address != null;
            this.localAddress = ((InetSocketAddress)this.channel.getLocalAddress()).getAddress();
            return (C)this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureBound() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.localAddress == null) {
                LocalTopology.DispatcherPortRange ports = this.getService().getLocalPortRange();
                if (ports.hasPortRange()) {
                    int min = ports.getPortMin();
                    int max = ports.getPortMax();
                    for (int port = min; port <= max; ++port) {
                        try {
                            this.bind(new InetSocketAddress(port));
                            return;
                        }
                        catch (IOException iOException) {
                            continue;
                        }
                    }
                    throw new IOException("No free port found in SCION port range: " + min + "-" + max);
                }
                this.bind(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetSocketAddress getLocalAddress() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.localAddress == null) {
                return null;
            }
            int port = ((InetSocketAddress)this.channel.getLocalAddress()).getPort();
            return new InetSocketAddress(this.localAddress, port);
        }
    }

    public InetSocketAddress getRemoteAddress() throws IOException {
        Path path = this.getConnectionPath();
        if (path != null) {
            return new InetSocketAddress(path.getRemoteAddress(), path.getRemotePort());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.connectionPath = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.channel.isOpen();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.channel.disconnect();
            this.channel.close();
            this.connectionPath = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public C connect(SocketAddress addr) throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.checkConnected(false);
            if (!(addr instanceof InetSocketAddress)) {
                throw new IllegalArgumentException("connect() requires an InetSocketAddress or a ScionSocketAddress.");
            }
            if (addr instanceof ScionSocketAddress) {
                return this.connect(((ScionSocketAddress)addr).getPath());
            }
            Path path = this.getService().lookupAndGetPath((InetSocketAddress)addr, this.pathPolicy);
            return this.connect(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public C connect(Path path) throws IOException {
        if (!(path instanceof RequestPath)) {
            throw new IllegalStateException("The path must be a request path.");
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.checkConnected(false);
            this.ensureBound();
            if (this.localAddress.isAnyLocalAddress()) {
                this.localAddress = this.getService().getExternalIP(path.getFirstHopAddress());
            }
            this.updateConnection((RequestPath)path, false);
            return (C)this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path getConnectionPath() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.connectionPath;
        }
    }

    protected ResponsePath receiveFromChannel(ByteBuffer buffer, InternalConstants.HdrTypes expectedHdrType) throws IOException {
        this.ensureBound();
        while (true) {
            buffer.clear();
            InetSocketAddress srcAddress = (InetSocketAddress)this.channel.receive(buffer);
            if (srcAddress == null) {
                return null;
            }
            buffer.flip();
            if (!this.validate(buffer.asReadOnlyBuffer())) continue;
            InternalConstants.HdrTypes hdrType = ScionHeaderParser.extractNextHeader(buffer);
            buffer.position(ScionHeaderParser.extractHeaderLength(buffer));
            hdrType = AbstractDatagramChannel.receiveExtensionHeader(buffer, hdrType);
            InetSocketAddress firstHopAddress = this.getFirstHopAddress(buffer, srcAddress);
            ResponsePath path = ScionHeaderParser.extractResponsePath(buffer, firstHopAddress);
            if (hdrType == expectedHdrType) {
                return path;
            }
            this.receiveScmp(buffer, path);
        }
    }

    protected InetSocketAddress getFirstHopAddress(ByteBuffer buffer, InetSocketAddress srcAddress) {
        if (this.getService() != null) {
            int oldPos = buffer.position();
            int pathPos = ScionHeaderParser.extractPathHeaderPosition(buffer);
            if (pathPos > 0) {
                buffer.position(pathPos);
                int segCount = PathRawParserLight.extractSegmentCount(buffer);
                buffer.position(pathPos + 4 + segCount * 8);
                int interfaceId1 = PathRawParserLight.extractHopFieldEgress(buffer, segCount, 0);
                int interfaceId2 = PathRawParserLight.extractHopFieldIngress(buffer, segCount, 0);
                buffer.position(oldPos);
                int interfaceId = interfaceId2 == 0 ? interfaceId1 : interfaceId2;
                return this.service.getBorderRouterAddress(interfaceId);
            }
        }
        return srcAddress;
    }

    protected static InternalConstants.HdrTypes receiveExtensionHeader(ByteBuffer buffer, InternalConstants.HdrTypes hdrType) {
        ExtensionHeader extHdr;
        if ((hdrType == InternalConstants.HdrTypes.END_TO_END || hdrType == InternalConstants.HdrTypes.HOP_BY_HOP) && (hdrType = (extHdr = ExtensionHeader.consume(buffer)).nextHdr()) != InternalConstants.HdrTypes.SCMP) {
            throw new UnsupportedOperationException("Extension header not supported: " + hdrType);
        }
        return hdrType;
    }

    protected void receiveScmp(ByteBuffer buffer, Path path) {
        Scmp.Type type = ScmpParser.extractType(buffer);
        Scmp.Message msg = Scmp.createMessage(type, path);
        ScmpParser.consume(buffer, msg);
        this.checkListeners(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkListeners(Scmp.Message scmpMsg) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.errorListener != null && scmpMsg.getTypeCode().isError()) {
                this.errorListener.accept((Scmp.ErrorMessage)scmpMsg);
            }
        }
    }

    @Deprecated
    public void configureRemoteDispatcher(boolean hasDispatcher) {
        this.cfgRemoteDispatcher = hasDispatcher;
    }

    public void setOverrideSourceAddress(InetSocketAddress address) {
        this.overrideExternalAddress = address;
    }

    public InetSocketAddress getOverrideSourceAddress() {
        return this.overrideExternalAddress;
    }

    protected InetAddress getLocalAddressForSend(Path path) throws IOException {
        if (this.overrideExternalAddress != null) {
            return this.overrideExternalAddress.getAddress();
        }
        if (this.localAddress.isAnyLocalAddress()) {
            return this.getService().getExternalIP(path.getFirstHopAddress());
        }
        return this.localAddress;
    }

    protected int getLocalPortForSend() throws IOException {
        if (this.overrideExternalAddress != null) {
            return this.overrideExternalAddress.getPort();
        }
        return ((InetSocketAddress)this.channel.getLocalAddress()).getPort();
    }

    protected int sendRaw(ByteBuffer buffer, Path path) throws IOException {
        if (this.getService() != null && path.getRawPath().length == 0) {
            InetSocketAddress remoteHostIP = path.getFirstHopAddress();
            remoteHostIP = this.getService().getLocalPortRange().mapToLocalPort(remoteHostIP);
            return this.channel.send(buffer, remoteHostIP);
        }
        if (this.cfgRemoteDispatcher && path.getRawPath().length == 0) {
            InetAddress remoteHostIP = path.getFirstHopAddress().getAddress();
            return this.channel.send(buffer, new InetSocketAddress(remoteHostIP, 30041));
        }
        return this.channel.send(buffer, path.getFirstHopAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Consumer<Scmp.ErrorMessage> setScmpErrorListener(Consumer<Scmp.ErrorMessage> listener) {
        Object object = this.stateLock;
        synchronized (object) {
            Consumer<Scmp.ErrorMessage> old = this.errorListener;
            this.errorListener = listener;
            return old;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkOpen() throws ClosedChannelException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.channel.isOpen()) {
                throw new ClosedChannelException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkConnected(boolean requiredState) {
        Object object = this.stateLock;
        synchronized (object) {
            boolean isConnected;
            boolean bl = isConnected = this.connectionPath != null;
            if (requiredState != isConnected) {
                if (isConnected) {
                    throw new AlreadyConnectedException();
                }
                throw new NotYetConnectedException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.connectionPath != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getOption(SocketOption<T> option) throws IOException {
        this.checkOpen();
        Object object = this.stateLock;
        synchronized (object) {
            if (option instanceof ScionSocketOptions.SciSocketOption) {
                if (ScionSocketOptions.SCION_API_THROW_PARSER_FAILURE.equals(option)) {
                    return (T)Boolean.valueOf(this.cfgReportFailedValidation);
                }
                if (ScionSocketOptions.SCION_PATH_EXPIRY_MARGIN.equals(option)) {
                    return (T)Integer.valueOf(this.cfgExpirationSafetyMargin);
                }
                if (ScionSocketOptions.SCION_TRAFFIC_CLASS.equals(option)) {
                    return (T)Integer.valueOf(this.cfgTrafficClass);
                }
                throw new UnsupportedOperationException();
            }
            if (StandardSocketOptions.SO_BROADCAST.equals(option)) {
                throw new UnsupportedOperationException();
            }
            return this.channel.getOption(option);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> C setOption(SocketOption<T> option, T t) throws IOException {
        this.checkOpen();
        Object object = this.stateLock;
        synchronized (object) {
            if (option instanceof ScionSocketOptions.SciSocketOption) {
                if (ScionSocketOptions.SCION_API_THROW_PARSER_FAILURE.equals(option)) {
                    this.cfgReportFailedValidation = (Boolean)t;
                } else if (ScionSocketOptions.SCION_PATH_EXPIRY_MARGIN.equals(option)) {
                    this.cfgExpirationSafetyMargin = (Integer)t;
                } else {
                    if (!ScionSocketOptions.SCION_TRAFFIC_CLASS.equals(option)) throw new UnsupportedOperationException();
                    int trafficClass = (Integer)t;
                    if (trafficClass < 0 || trafficClass > 255) {
                        throw new IllegalArgumentException("trafficClass is not in range 0 -- 255");
                    }
                    this.cfgTrafficClass = trafficClass;
                }
            } else {
                if (StandardSocketOptions.SO_BROADCAST.equals(option)) {
                    throw new UnsupportedOperationException();
                }
                this.channel.setOption((SocketOption)option, (Object)t);
            }
            return (C)this;
        }
    }

    protected int getCfgExpirationSafetyMargin() {
        return this.cfgExpirationSafetyMargin;
    }

    private void checkLockedForRead() {
        if (!this.readLock().isLocked()) {
            throw new IllegalStateException("Access must be READ locked!");
        }
    }

    private void checkLockedForWrite() {
        if (!this.writeLock().isLocked()) {
            throw new IllegalStateException("Access must be WRITE locked!");
        }
    }

    protected final ByteBuffer getBufferSend(int requiredSize) {
        this.checkLockedForWrite();
        if (this.bufferSend.capacity() < requiredSize) {
            this.bufferSend = ByteBuffer.allocateDirect(requiredSize);
        }
        return this.bufferSend;
    }

    protected final ByteBuffer getBufferReceive(int requiredSize) {
        this.checkLockedForRead();
        if (this.bufferReceive.capacity() < requiredSize) {
            this.bufferReceive = ByteBuffer.allocateDirect(requiredSize);
        }
        return this.bufferReceive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildHeader(ByteBuffer buffer, Path path, int payloadLength, InternalConstants.HdrTypes hdrType) throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            InetAddress srcAddress;
            long srcIsdAs;
            this.ensureBound();
            buffer.clear();
            if (path instanceof ResponsePath) {
                ResponsePath rPath = (ResponsePath)path;
                srcIsdAs = rPath.getLocalIsdAs();
                srcAddress = rPath.getLocalAddress();
            } else {
                srcIsdAs = this.getService().getLocalIsdAs();
                srcAddress = this.getLocalAddressForSend(path);
            }
            byte[] rawPath = path.getRawPath();
            ScionHeaderParser.write(buffer, payloadLength, rawPath.length, srcIsdAs, srcAddress.getAddress(), path.getRemoteIsdAs(), path.getRemoteAddress().getAddress(), hdrType, this.cfgTrafficClass);
            ScionHeaderParser.writePath(buffer, rawPath);
        }
    }

    protected void updateConnection(RequestPath newPath, boolean mustBeConnected) throws IOException {
        if (mustBeConnected && !this.isConnected()) {
            return;
        }
        this.connectionPath = newPath;
        if (!this.isBoundToAddress) {
            InetAddress oldLocalAddress = this.localAddress;
            this.localAddress = this.getService().getExternalIP(newPath.getFirstHopAddress());
            if (!Objects.equals(this.localAddress, oldLocalAddress)) {
                throw new UnsupportedOperationException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean validate(ByteBuffer buffer) throws ScionException {
        Object object = this.stateLock;
        synchronized (object) {
            String validationResult = ScionHeaderParser.validate(buffer.asReadOnlyBuffer());
            if (validationResult != null && this.cfgReportFailedValidation) {
                throw new ScionException(validationResult);
            }
            return validationResult == null;
        }
    }

    protected ReentrantLock readLock() {
        return this.readLock;
    }

    protected ReentrantLock writeLock() {
        return this.writeLock;
    }

    protected Object stateLock() {
        return this.stateLock;
    }
}

