/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.scion.jpan.Path;
import org.scion.jpan.ScionRuntimeException;
import org.scion.jpan.ScionService;
import org.scion.jpan.Scmp;
import org.scion.jpan.ScmpSenderAsync;
import org.scion.jpan.internal.PathHeaderParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScmpSender
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ScmpSender.class);
    private final ScmpSenderAsync sender;
    private final UnifyingResponseHandler responseHandler = new UnifyingResponseHandler();
    private Consumer<Scmp.ErrorMessage> errorListener = null;

    private ScmpSender(ScionService service, int port, DatagramChannel channel) {
        this.sender = ScmpSenderAsync.newBuilder(this.responseHandler).setService(service).setLocalPort(port).setDatagramChannel(channel).build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scmp.EchoMessage sendEchoRequest(Path path, ByteBuffer data) throws IOException {
        this.responseHandler.startEcho();
        this.sender.sendEcho(path, data);
        try {
            Scmp.EchoMessage echoMessage = this.responseHandler.getEcho();
            return echoMessage;
        }
        finally {
            this.sender.abortAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Scmp.TracerouteMessage> sendTracerouteRequest(Path path) throws IOException {
        ArrayList<PathHeaderParser.Node> nodes = PathHeaderParser.getTraceNodes(path.getRawPath());
        this.responseHandler.startTrace();
        this.sender.sendTraceroute(path);
        try {
            List<Scmp.TracerouteMessage> result = this.responseHandler.getTraceroute(nodes.size());
            result.sort(Comparator.comparingInt(Scmp.Message::getSequenceNumber));
            List<Scmp.TracerouteMessage> list = result;
            return list;
        }
        finally {
            this.sender.abortAll();
        }
    }

    public void setTimeOut(int milliSeconds) {
        this.sender.setTimeOut(milliSeconds);
    }

    public int getTimeOut() {
        return this.sender.getTimeOut();
    }

    @Override
    public void close() throws IOException {
        this.sender.close();
    }

    public Consumer<Scmp.ErrorMessage> setScmpErrorListener(Consumer<Scmp.ErrorMessage> listener) {
        Consumer<Scmp.ErrorMessage> previous = this.errorListener;
        this.errorListener = listener;
        return previous;
    }

    public <T> void setOption(SocketOption<T> option, T t) throws IOException {
        this.sender.setOption(option, t);
    }

    public InetSocketAddress getLocalAddress() throws IOException {
        return this.sender.getLocalAddress();
    }

    public void setOverrideSourceAddress(InetSocketAddress overrideSourceAddress) {
        this.sender.setOverrideSourceAddress(overrideSourceAddress);
    }

    public static class Builder {
        private ScionService service;
        private int port = -1;
        private DatagramChannel channel = null;

        public Builder setLocalPort(int localPort) {
            this.port = localPort;
            return this;
        }

        public Builder setService(ScionService service) {
            this.service = service;
            return this;
        }

        public Builder setDatagramChannel(DatagramChannel channel) {
            this.channel = channel;
            return this;
        }

        public ScmpSender build() {
            ScionService service2 = this.service == null ? ScionService.defaultService() : this.service;
            return new ScmpSender(service2, this.port, this.channel);
        }
    }

    private class UnifyingResponseHandler
    implements ScmpSenderAsync.ResponseHandler {
        private Scmp.ErrorMessage error = null;
        private Throwable exception = null;
        private Scmp.EchoMessage response = null;
        private ArrayList<Scmp.TracerouteMessage> responses = null;

        private UnifyingResponseHandler() {
        }

        private void start() {
            this.error = null;
            this.exception = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private <T> T waitForResult(Supplier<T> checkResult) throws IOException {
            try {
                while (true) {
                    UnifyingResponseHandler unifyingResponseHandler = this;
                    synchronized (unifyingResponseHandler) {
                        if (this.error != null) {
                            throw new IOException(this.error.getTypeCode().getText());
                        }
                        if (this.exception != null) {
                            throw new IOException(this.exception);
                        }
                        T result = checkResult.get();
                        if (result != null) {
                            return result;
                        }
                        this.wait();
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error("Interrupted: {}", (Object)Thread.currentThread().getName());
                throw new ScionRuntimeException(e);
            }
        }

        synchronized void startEcho() {
            this.start();
            this.response = null;
        }

        synchronized void startTrace() {
            this.start();
            this.responses = new ArrayList();
        }

        @Override
        public synchronized void onResponse(Scmp.TimedMessage msg) {
            if (msg instanceof Scmp.EchoMessage) {
                this.response = (Scmp.EchoMessage)msg;
                this.notifyAll();
            } else if (msg instanceof Scmp.TracerouteMessage) {
                this.responses.add((Scmp.TracerouteMessage)msg);
                this.notifyAll();
            } else {
                throw new IllegalArgumentException("Received: " + msg.getTypeCode().getText());
            }
        }

        @Override
        public synchronized void onTimeout(Scmp.TimedMessage msg) {
            if (msg instanceof Scmp.EchoMessage) {
                this.response = (Scmp.EchoMessage)msg;
                this.notifyAll();
            } else if (msg instanceof Scmp.TracerouteMessage) {
                this.responses.add((Scmp.TracerouteMessage)msg);
                this.notifyAll();
            } else {
                throw new IllegalArgumentException("Received: " + msg.getTypeCode().getText());
            }
        }

        @Override
        public synchronized void onError(Scmp.ErrorMessage msg) {
            if (ScmpSender.this.errorListener != null) {
                ScmpSender.this.errorListener.accept(msg);
            }
            this.error = msg;
            this.notifyAll();
        }

        @Override
        public synchronized void onException(Throwable t) {
            this.exception = t;
            this.notifyAll();
        }

        Scmp.EchoMessage getEcho() throws IOException {
            return this.waitForResult(() -> this.response);
        }

        List<Scmp.TracerouteMessage> getTraceroute(int count) throws IOException {
            return this.waitForResult(() -> this.responses.size() >= count ? this.responses : null);
        }
    }
}

