/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan.internal;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.scion.jpan.ScionRuntimeException;
import org.scion.jpan.ScionUtil;

public class LocalTopology {
    private final List<ServiceNode> controlServices = new ArrayList<ServiceNode>();
    private final List<ServiceNode> discoveryServices = new ArrayList<ServiceNode>();
    private final List<BorderRouter> borderRouters = new ArrayList<BorderRouter>();
    private String localIsdAs;
    private boolean isCoreAs;
    private int localMtu;
    private DispatcherPortRange portRange;

    public static synchronized LocalTopology create(String topologyFile) {
        LocalTopology topo = new LocalTopology();
        topo.parseTopologyFile(topologyFile);
        return topo;
    }

    private static JsonElement safeGet(JsonObject o, String name) {
        JsonElement e = o.get(name);
        if (e == null) {
            throw new ScionRuntimeException("Entry not found in topology file: " + name);
        }
        return e;
    }

    public String getControlServerAddress() {
        return this.controlServices.get((int)0).ipString;
    }

    public boolean isCoreAs() {
        return this.isCoreAs;
    }

    public long getIsdAs() {
        return ScionUtil.parseIA(this.localIsdAs);
    }

    public String getBorderRouterAddress(int interfaceId) {
        for (BorderRouter br : this.borderRouters) {
            for (BorderRouterInterface brif : br.interfaces) {
                if (brif.id != interfaceId) continue;
                return br.internalAddress;
            }
        }
        throw new ScionRuntimeException("No router found with interface ID " + interfaceId);
    }

    public int getMtu() {
        return this.localMtu;
    }

    private void parseTopologyFile(String topologyFile) {
        JsonElement jsonTree = JsonParser.parseString((String)topologyFile);
        if (jsonTree.isJsonObject()) {
            JsonElement dispatchedPorts;
            JsonObject o = jsonTree.getAsJsonObject();
            this.localIsdAs = LocalTopology.safeGet(o, "isd_as").getAsString();
            this.localMtu = LocalTopology.safeGet(o, "mtu").getAsInt();
            JsonObject brs = LocalTopology.safeGet(o, "border_routers").getAsJsonObject();
            for (Object e : brs.entrySet()) {
                JsonObject br = ((JsonElement)e.getValue()).getAsJsonObject();
                String addr = LocalTopology.safeGet(br, "internal_addr").getAsString();
                JsonObject ints = LocalTopology.safeGet(br, "interfaces").getAsJsonObject();
                ArrayList<BorderRouterInterface> interfaces = new ArrayList<BorderRouterInterface>();
                for (Map.Entry ifEntry : ints.entrySet()) {
                    JsonObject ife = ((JsonElement)ifEntry.getValue()).getAsJsonObject();
                    JsonObject underlay = ife.getAsJsonObject("underlay");
                    JsonElement local = underlay.has("local") ? underlay.get("local") : underlay.get("public");
                    JsonElement remote = underlay.get("remote");
                    long isdAs = ScionUtil.parseIA(ife.get("isd_as").getAsString());
                    int mtu = ife.get("mtu").getAsInt();
                    String linkTo = ife.get("link_to").getAsString();
                    interfaces.add(new BorderRouterInterface((String)ifEntry.getKey(), local.getAsString(), remote.getAsString(), isdAs, mtu, linkTo));
                }
                this.borderRouters.add(new BorderRouter((String)e.getKey(), addr, interfaces));
            }
            JsonObject css = LocalTopology.safeGet(o, "control_service").getAsJsonObject();
            for (Object e : css.entrySet()) {
                JsonObject cs = ((JsonElement)e.getValue()).getAsJsonObject();
                this.controlServices.add(new ServiceNode((String)e.getKey(), cs.get("addr").getAsString()));
            }
            JsonElement dss = o.get("discovery_service");
            if (dss != null) {
                for (Map.Entry e : dss.getAsJsonObject().entrySet()) {
                    JsonObject ds = ((JsonElement)e.getValue()).getAsJsonObject();
                    this.discoveryServices.add(new ServiceNode((String)e.getKey(), ds.get("addr").getAsString()));
                }
            }
            this.portRange = (dispatchedPorts = o.get("dispatched_ports")) == null ? DispatcherPortRange.createEmpty() : LocalTopology.parsePortRange(dispatchedPorts.getAsString());
            JsonArray attr = LocalTopology.safeGet(o, "attributes").getAsJsonArray();
            for (int i = 0; i < attr.size(); ++i) {
                if (!"core".equals(attr.get(i).getAsString())) continue;
                this.isCoreAs = true;
            }
        }
    }

    private static DispatcherPortRange parsePortRange(String v) {
        if ("-".equals(v)) {
            return DispatcherPortRange.createEmpty();
        }
        if ("all".equalsIgnoreCase(v)) {
            return DispatcherPortRange.createAll();
        }
        String[] sa = v.split("-");
        if (sa.length != 2) {
            throw new ScionRuntimeException("Illegal expression in topo file dispatched_ports: " + v);
        }
        int portMin = Integer.parseInt(sa[0]);
        int portMax = Integer.parseInt(sa[1]);
        if (portMin < 1 || portMax < 1 || portMax > 65535 || portMin > portMax) {
            throw new ScionRuntimeException("Illegal port values in topo file dispatched_ports: " + v);
        }
        return DispatcherPortRange.create(portMin, portMax);
    }

    public DispatcherPortRange getPortRange() {
        return this.portRange;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ISD/AS: ").append(this.localIsdAs).append('\n');
        sb.append("Core: ").append(this.isCoreAs).append('\n');
        sb.append("MTU: ").append(this.localMtu).append('\n');
        for (ServiceNode sn : this.controlServices) {
            sb.append("Control server:   ").append(sn).append('\n');
        }
        for (ServiceNode sn : this.discoveryServices) {
            sb.append("Discovery server: ").append(sn).append('\n');
        }
        return sb.toString();
    }

    public List<ServiceNode> getControlServices() {
        return Collections.unmodifiableList(this.controlServices);
    }

    public List<BorderRouter> getBorderRouters() {
        return Collections.unmodifiableList(this.borderRouters);
    }

    public static class DispatcherPortRange {
        private final int portMin;
        private final int portMax;

        private DispatcherPortRange(int min, int max) {
            this.portMin = min;
            this.portMax = max;
        }

        public static DispatcherPortRange create(int min, int max) {
            return new DispatcherPortRange(min, max);
        }

        public static DispatcherPortRange createAll() {
            return new DispatcherPortRange(1, 65535);
        }

        public static DispatcherPortRange createEmpty() {
            return new DispatcherPortRange(-1, -2);
        }

        public boolean hasPortRange() {
            return this.portMin >= 1 && this.portMax <= 65535 && this.portMax >= this.portMin;
        }

        public boolean hasPortRangeALL() {
            return this.portMin == 1 && this.portMax == 65535;
        }

        public InetSocketAddress mapToLocalPort(InetSocketAddress address) {
            if (address.getPort() == 30041 || address.getPort() >= this.portMin && address.getPort() <= this.portMax) {
                return address;
            }
            return new InetSocketAddress(address.getAddress(), 30041);
        }

        public int getPortMin() {
            return this.portMin;
        }

        public int getPortMax() {
            return this.portMax;
        }
    }

    public static class ServiceNode {
        final String name;
        final String ipString;

        ServiceNode(String name, String ipString) {
            this.name = name;
            this.ipString = ipString;
        }

        public String toString() {
            return "{name='" + this.name + '\'' + ", ipString='" + this.ipString + '\'' + '}';
        }
    }

    public static class BorderRouterInterface {
        public static final String PARENT = "parent";
        public static final String CHILD = "child";
        public static final String CORE = "core";
        final int id;
        final String publicUnderlay;
        final String remoteUnderlay;
        final long isdAs;
        final int mtu;
        final String linkTo;

        BorderRouterInterface(String id, String publicU, String remoteU, long isdAs, int mtu, String linkTo) {
            this.id = Integer.parseInt(id);
            this.publicUnderlay = publicU;
            this.remoteUnderlay = remoteU;
            this.isdAs = isdAs;
            this.mtu = mtu;
            this.linkTo = linkTo;
        }

        public long getIsdAs() {
            return this.isdAs;
        }

        public int getMtu() {
            return this.mtu;
        }

        public int getId() {
            return this.id;
        }

        public String getLinkTo() {
            return this.linkTo;
        }

        public String getRemoteUnderlay() {
            return this.remoteUnderlay;
        }

        public String getPublicUnderlay() {
            return this.publicUnderlay;
        }
    }

    public static class BorderRouter {
        private final String name;
        private final String internalAddress;
        private final List<BorderRouterInterface> interfaces;

        BorderRouter(String name, String addr, List<BorderRouterInterface> interfaces) {
            this.name = name;
            this.internalAddress = addr;
            this.interfaces = interfaces;
        }

        public Iterable<BorderRouterInterface> getInterfaces() {
            return this.interfaces;
        }
    }
}

