/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.stream.Stream;
import org.scion.jpan.ScionException;
import org.scion.jpan.ScionRuntimeException;
import org.scion.jpan.internal.DNSHelper;
import org.scion.jpan.internal.GlobalTopology;
import org.scion.jpan.internal.IPHelper;
import org.scion.jpan.internal.LocalTopology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScionBootstrapper {
    private static final Logger LOG = LoggerFactory.getLogger((String)ScionBootstrapper.class.getName());
    private static final String TOPOLOGY_ENDPOINT = "topology";
    private static final Duration httpRequestTimeout = Duration.of(2L, ChronoUnit.SECONDS);
    private final String topologyResource;
    private final LocalTopology localAS;
    private final GlobalTopology world;

    protected ScionBootstrapper(String topologyServiceAddress) {
        this.topologyResource = IPHelper.ensurePortOrDefault(topologyServiceAddress, 8041);
        this.localAS = this.initLocal();
        this.world = this.initGlobal();
    }

    protected ScionBootstrapper(Path file) {
        this.topologyResource = file.toString();
        this.localAS = this.init(file);
        this.world = GlobalTopology.createEmpty();
    }

    public static synchronized ScionBootstrapper createViaDns(String host) {
        return new ScionBootstrapper(ScionBootstrapper.bootstrapViaDNS(host));
    }

    public static synchronized ScionBootstrapper createViaBootstrapServerIP(String hostAndPort) {
        return new ScionBootstrapper(hostAndPort);
    }

    public static synchronized ScionBootstrapper createViaTopoFile(Path file) {
        return new ScionBootstrapper(file);
    }

    public LocalTopology getLocalTopology() {
        return this.localAS;
    }

    public GlobalTopology getGlobalTopology() {
        return this.world;
    }

    private static String bootstrapViaDNS(String hostName) {
        try {
            String addr = DNSHelper.getScionDiscoveryAddress(hostName);
            if (addr == null) {
                throw new ScionRuntimeException("No valid DNS NAPTR entry found for host: " + hostName);
            }
            return addr;
        }
        catch (IOException e) {
            throw new ScionRuntimeException("Error while bootstrapping Scion via DNS: " + e.getMessage());
        }
    }

    private LocalTopology initLocal() {
        return LocalTopology.create(this.fetchFile(TOPOLOGY_ENDPOINT));
    }

    private GlobalTopology initGlobal() {
        return GlobalTopology.create(this);
    }

    private LocalTopology init(Path file) {
        try {
            ClassLoader classLoader;
            URL resource;
            if (!Files.exists(file, new LinkOption[0]) && (resource = (classLoader = this.getClass().getClassLoader()).getResource(file.toString())) != null) {
                file = Paths.get(resource.toURI());
            }
        }
        catch (URISyntaxException e) {
            throw new ScionRuntimeException(e);
        }
        StringBuilder contentBuilder = new StringBuilder();
        try (Stream<String> stream = Files.lines(file, StandardCharsets.UTF_8);){
            stream.forEach(s -> contentBuilder.append((String)s).append("\n"));
        }
        catch (IOException e) {
            throw new ScionRuntimeException("Error reading topology file: " + file.toAbsolutePath(), e);
        }
        LocalTopology topo = LocalTopology.create(contentBuilder.toString());
        if (topo.getControlServices().isEmpty()) {
            throw new ScionRuntimeException("No control service found in topology file: " + file);
        }
        return topo;
    }

    public void refreshTopology() {
        throw new UnsupportedOperationException();
    }

    public String fetchFile(String resource) {
        try {
            LOG.info("Fetching resource from bootstrap server: {} {}", (Object)this.topologyResource, (Object)resource);
            URL url = new URL("http://" + this.topologyResource + "/" + resource);
            return ScionBootstrapper.fetchFile(url);
        }
        catch (IOException e) {
            throw new ScionRuntimeException("While fetching resource '" + resource + "' from " + this.topologyResource, e);
        }
    }

    /*
     * Loose catch block
     */
    private static String fetchFile(URL url) throws IOException {
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = (HttpURLConnection)url.openConnection();
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setConnectTimeout((int)httpRequestTimeout.toMillis());
            int responseCode = httpURLConnection.getResponseCode();
            if (responseCode != 200) {
                throw new ScionException("GET request failed (" + responseCode + ") on topology server: " + url);
            }
            try (BufferedReader in = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));){
                String inputLine;
                StringBuilder response = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine).append(System.lineSeparator());
                }
                String string = response.toString();
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }
}

