/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan.internal;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Timestamp;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.scion.jpan.ScionRuntimeException;
import org.scion.jpan.ScionUtil;
import org.scion.jpan.internal.ByteUtil;
import org.scion.jpan.internal.LocalTopology;
import org.scion.jpan.internal.MultiMap;
import org.scion.jpan.internal.PathDuplicationFilter;
import org.scion.jpan.internal.ScionBootstrapper;
import org.scion.jpan.proto.control_plane.Seg;
import org.scion.jpan.proto.control_plane.SegmentLookupServiceGrpc;
import org.scion.jpan.proto.crypto.Signed;
import org.scion.jpan.proto.daemon.Daemon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Segments {
    private static final Logger LOG = LoggerFactory.getLogger((String)Segments.class.getName());

    private Segments() {
    }

    public static List<Daemon.Path> getPaths(SegmentLookupServiceGrpc.SegmentLookupServiceBlockingStub service, ScionBootstrapper bootstrapper, long srcIsdAs, long dstIsdAs, boolean minimizeLookups) {
        LocalTopology localAS = bootstrapper.getLocalTopology();
        List<Daemon.Path> path = Segments.getPaths(service, localAS, srcIsdAs, dstIsdAs, minimizeLookups);
        path.sort(Comparator.comparingInt(Daemon.Path::getInterfacesCount));
        return path;
    }

    private static List<Daemon.Path> getPaths(SegmentLookupServiceGrpc.SegmentLookupServiceBlockingStub service, LocalTopology localAS, long srcIsdAs, long dstIsdAs, boolean minimizeLookups) {
        long srcWildcard = ScionUtil.toWildcard(srcIsdAs);
        long dstWildcard = ScionUtil.toWildcard(dstIsdAs);
        if (srcIsdAs == dstIsdAs) {
            Daemon.Path.Builder path = Daemon.Path.newBuilder();
            path.setMtu(localAS.getMtu());
            path.setExpiration(Timestamp.newBuilder().setSeconds(Instant.now().getEpochSecond()).build());
            return Collections.singletonList(path.build());
        }
        List<Object> segmentsUp = Collections.emptyList();
        if (!localAS.isCoreAs()) {
            List<PathSegment> directUp;
            segmentsUp = Segments.getSegments(service, srcIsdAs, srcWildcard);
            if (segmentsUp.isEmpty()) {
                return Collections.emptyList();
            }
            if (minimizeLookups && !(directUp = Segments.filterForIsdAs(segmentsUp, dstIsdAs)).isEmpty()) {
                PathDuplicationFilter paths = new PathDuplicationFilter();
                Segments.combineSegment(paths, directUp, localAS, srcIsdAs, dstIsdAs);
                return paths.getPaths();
            }
        }
        List<PathSegment> segmentsCore = Segments.getSegments(service, srcWildcard, dstWildcard);
        if (localAS.isCoreAs()) {
            segmentsCore = Segments.filterForEndIsdAs(segmentsCore, srcIsdAs);
        }
        if (Segments.endsWithIsdAs(segmentsCore, dstIsdAs)) {
            return Segments.combineSegments(segmentsUp, segmentsCore, Collections.emptyList(), srcIsdAs, dstIsdAs, localAS);
        }
        List<PathSegment> segmentsDown = Segments.getSegments(service, dstWildcard, dstIsdAs);
        return Segments.combineSegments(segmentsUp, segmentsCore, segmentsDown, srcIsdAs, dstIsdAs, localAS);
    }

    private static List<PathSegment> getSegments(SegmentLookupServiceGrpc.SegmentLookupServiceBlockingStub segmentStub, long srcIsdAs, long dstIsdAs) {
        if (LOG.isInfoEnabled()) {
            LOG.info("Requesting segments: {} {}", (Object)ScionUtil.toStringIA(srcIsdAs), (Object)ScionUtil.toStringIA(dstIsdAs));
        }
        Seg.SegmentsRequest request = Seg.SegmentsRequest.newBuilder().setSrcIsdAs(srcIsdAs).setDstIsdAs(dstIsdAs).build();
        try {
            long t0 = System.nanoTime();
            Seg.SegmentsResponse response = segmentStub.segments(request);
            long t1 = System.nanoTime();
            LOG.info("Segment request took {} ms.", (Object)((t1 - t0) / 1000000L));
            if (response.getSegmentsMap().size() > 1) {
                throw new UnsupportedOperationException();
            }
            return Segments.getPathSegments(response);
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode().equals((Object)Status.Code.UNKNOWN)) {
                if (e.getMessage().contains("TRC not found")) {
                    String msg = ScionUtil.toStringIA(srcIsdAs) + " / " + ScionUtil.toStringIA(dstIsdAs);
                    throw new ScionRuntimeException("Error while getting Segments: unknown src/dst ISD-AS: " + msg, e);
                }
                if (e.getMessage().contains("invalid request")) {
                    LOG.info("Requesting segments: {} {} failed (AS unreachable?): {}", new Object[]{ScionUtil.toStringIA(srcIsdAs), ScionUtil.toStringIA(dstIsdAs), e.getMessage()});
                    return Collections.emptyList();
                }
            }
            if (e.getStatus().getCode().equals((Object)Status.Code.UNAVAILABLE)) {
                throw new ScionRuntimeException("Error while getting Segments: cannot connect to SCION network", e);
            }
            throw new ScionRuntimeException("Error while getting Segment info: " + e.getMessage(), e);
        }
    }

    private static List<PathSegment> getPathSegments(Seg.SegmentsResponse response) {
        ArrayList<PathSegment> pathSegments = new ArrayList<PathSegment>();
        for (Map.Entry<Integer, Seg.SegmentsResponse.Segments> seg : response.getSegmentsMap().entrySet()) {
            SegmentType type = SegmentType.from(Seg.SegmentType.forNumber(seg.getKey()));
            seg.getValue().getSegmentsList().forEach(path -> pathSegments.add(new PathSegment((Seg.PathSegment)path, type)));
            LOG.info("Segments found of type {}: {}", (Object)type.name(), (Object)seg.getValue().getSegmentsCount());
        }
        return pathSegments;
    }

    private static List<Daemon.Path> combineSegments(List<PathSegment> segmentsUp, List<PathSegment> segmentsCore, List<PathSegment> segmentsDown, long srcIsdAs, long dstIsdAs, LocalTopology localAS) {
        int code = !segmentsUp.isEmpty() ? 4 : 0;
        code |= !segmentsCore.isEmpty() ? 2 : 0;
        int n = !segmentsDown.isEmpty() ? 1 : 0;
        PathDuplicationFilter paths = new PathDuplicationFilter();
        switch (code |= n) {
            case 7: {
                Segments.combineThreeSegments(paths, segmentsUp, segmentsCore, segmentsDown, srcIsdAs, dstIsdAs, localAS);
                if (ScionUtil.extractIsd(srcIsdAs) != ScionUtil.extractIsd(dstIsdAs)) break;
                Segments.combineTwoSegments(paths, segmentsUp, segmentsDown, srcIsdAs, dstIsdAs, localAS);
                break;
            }
            case 6: {
                Segments.combineTwoSegments(paths, segmentsUp, segmentsCore, srcIsdAs, dstIsdAs, localAS);
                Segments.combineSegment(paths, Segments.filterForIsdAs(segmentsUp, dstIsdAs), localAS, srcIsdAs, dstIsdAs);
                break;
            }
            case 5: {
                Segments.combineTwoSegments(paths, segmentsUp, segmentsDown, srcIsdAs, dstIsdAs, localAS);
                break;
            }
            case 4: {
                Segments.combineSegment(paths, segmentsUp, localAS, srcIsdAs, dstIsdAs);
                break;
            }
            case 3: {
                Segments.combineTwoSegments(paths, segmentsCore, segmentsDown, srcIsdAs, dstIsdAs, localAS);
                Segments.combineSegment(paths, Segments.filterForIsdAs(segmentsDown, srcIsdAs), localAS, srcIsdAs, dstIsdAs);
                break;
            }
            case 2: {
                Segments.combineSegment(paths, segmentsCore, localAS, srcIsdAs, dstIsdAs);
                break;
            }
            case 1: {
                Segments.combineSegment(paths, segmentsDown, localAS, srcIsdAs, dstIsdAs);
                break;
            }
            default: {
                return paths.getPaths();
            }
        }
        return paths.getPaths();
    }

    private static void combineSegment(PathDuplicationFilter paths, List<PathSegment> segments, LocalTopology localAS, long srcIsdAs, long dstIsdAs) {
        for (PathSegment pathSegment : segments) {
            if (!Segments.containsIsdAses(pathSegment, srcIsdAs, dstIsdAs)) continue;
            Segments.buildPath(paths, localAS, dstIsdAs, pathSegment);
        }
    }

    private static void combineTwoSegments(PathDuplicationFilter paths, List<PathSegment> segments0, List<PathSegment> segments1, long srcIsdAs, long dstIsdAs, LocalTopology localAS) {
        MultiMap<Long, PathSegment> segmentsMap1 = Segments.createSegmentsMap(segments1, dstIsdAs);
        for (PathSegment pathSegment0 : segments0) {
            long middleIsdAs = Segments.getOtherIsdAs(srcIsdAs, pathSegment0);
            for (PathSegment pathSegment1 : segmentsMap1.get(middleIsdAs)) {
                Segments.buildPath(paths, localAS, dstIsdAs, pathSegment0, pathSegment1);
            }
        }
    }

    private static void combineThreeSegments(PathDuplicationFilter paths, List<PathSegment> segmentsUp, List<PathSegment> segmentsCore, List<PathSegment> segmentsDown, long srcIsdAs, long dstIsdAs, LocalTopology localAS) {
        MultiMap<Long, PathSegment> upSegments = Segments.createSegmentsMap(segmentsUp, srcIsdAs);
        MultiMap<Long, PathSegment> downSegments = Segments.createSegmentsMap(segmentsDown, dstIsdAs);
        for (PathSegment pathSeg : segmentsCore) {
            long[] endIAs = Segments.getEndingIAs(pathSeg);
            if (upSegments.contains(endIAs[0]) && downSegments.contains(endIAs[1])) {
                Segments.buildPath(paths, upSegments.get(endIAs[0]), pathSeg, downSegments.get(endIAs[1]), localAS, dstIsdAs);
                continue;
            }
            if (!upSegments.contains(endIAs[1]) || !downSegments.contains(endIAs[0])) continue;
            Segments.buildPath(paths, upSegments.get(endIAs[1]), pathSeg, downSegments.get(endIAs[0]), localAS, dstIsdAs);
        }
    }

    private static void buildPath(PathDuplicationFilter paths, List<PathSegment> segmentsUp, PathSegment segCore, List<PathSegment> segmentsDown, LocalTopology localAS, long dstIA) {
        for (PathSegment segUp : segmentsUp) {
            for (PathSegment segDown : segmentsDown) {
                Segments.buildPath(paths, localAS, dstIA, segUp, segCore, segDown);
            }
        }
    }

    private static void buildPath(PathDuplicationFilter paths, LocalTopology localAS, long dstIsdAs, PathSegment ... segments) {
        int i;
        Daemon.Path.Builder path = Daemon.Path.newBuilder();
        ByteBuffer raw = ByteBuffer.allocate(1000);
        int[][] ranges = new int[segments.length][];
        long startIA = localAS.getIsdAs();
        ByteUtil.MutLong endingIA = new ByteUtil.MutLong(-1L);
        for (int i2 = 0; i2 < segments.length; ++i2) {
            ranges[i2] = Segments.createRange(segments[i2], startIA, endingIA);
            startIA = endingIA.get();
        }
        if (Segments.detectOnPathUp(segments, dstIsdAs, ranges)) {
            segments = new PathSegment[]{segments[0]};
            ranges = new int[][]{ranges[0]};
            LOG.debug("Found on-path AS on UP segment.");
        } else if (Segments.detectOnPathDown(segments, localAS.getIsdAs(), ranges)) {
            segments = new PathSegment[]{segments[segments.length - 1]};
            ranges = new int[][]{ranges[ranges.length - 1]};
            LOG.debug("Found on-path AS on DOWN segment.");
        } else if (Segments.detectShortcut(segments, ranges)) {
            segments = new PathSegment[]{segments[0], segments[segments.length - 1]};
            ranges = new int[][]{ranges[0], ranges[ranges.length - 1]};
            LOG.debug("Found shortcut at hop {}:", (Object)ranges[0][1]);
        }
        int pathMetaHeader = 0;
        for (i = 0; i < segments.length; ++i) {
            int hopCount = Math.abs(ranges[i][1] - ranges[i][0]);
            pathMetaHeader |= hopCount << 6 * (2 - i);
        }
        raw.putInt(pathMetaHeader);
        for (i = 0; i < segments.length; ++i) {
            Segments.writeInfoField(raw, segments[i].info, ranges[i][2]);
            Segments.calcBetaCorrection(raw, 6 + i * 8, segments[i], ranges[i]);
        }
        path.setMtu(localAS.getMtu());
        for (i = 0; i < segments.length; ++i) {
            Segments.writeHopFields(path, raw, 6 + i * 8, segments[i], ranges[i]);
        }
        raw.flip();
        path.setRaw(ByteString.copyFrom((ByteBuffer)raw));
        String firstHop = localAS.getBorderRouterAddress((int)path.getInterfaces(0).getId());
        Daemon.Underlay underlay = Daemon.Underlay.newBuilder().setAddress(firstHop).build();
        Daemon.Interface interfaceAddr = Daemon.Interface.newBuilder().setAddress(underlay).build();
        path.setInterface(interfaceAddr);
        paths.checkDuplicatePaths(path);
    }

    private static void calcBetaCorrection(ByteBuffer raw, int bytePosSegID, PathSegment segment, int[] range) {
        byte[] fix = new byte[2];
        int startRange = range[2] == 1 ? range[0] : range[1] + 1;
        for (int pos = 0; pos < startRange; ++pos) {
            ByteString mac = segment.getAsEntriesList().get(pos).getHopEntry().getHopField().getMac();
            fix[0] = (byte)(fix[0] ^ mac.byteAt(0));
            fix[1] = (byte)(fix[1] ^ mac.byteAt(1));
        }
        raw.put(bytePosSegID, ByteUtil.toByte(raw.get(bytePosSegID) ^ fix[0]));
        raw.put(bytePosSegID + 1, ByteUtil.toByte(raw.get(bytePosSegID + 1) ^ fix[1]));
    }

    private static int[] createRange(PathSegment pathSegment, long startIA, ByteUtil.MutLong endIA) {
        Seg.ASEntrySignedBody body0 = pathSegment.getAsEntriesFirst();
        Seg.ASEntrySignedBody bodyN = pathSegment.getAsEntriesLast();
        if (body0.getIsdAs() == startIA) {
            endIA.set(bodyN.getIsdAs());
            return new int[]{0, pathSegment.getAsEntriesCount(), 1};
        }
        if (bodyN.getIsdAs() == startIA) {
            endIA.set(body0.getIsdAs());
            return new int[]{pathSegment.getAsEntriesCount() - 1, -1, -1};
        }
        throw new UnsupportedOperationException("Relevant IA is not an ending IA!");
    }

    private static long calcExpTime(long baseTime, int deltaTime) {
        return baseTime + (long)(1 + deltaTime) * 24L * 60L * 60L / 256L;
    }

    private static void writeInfoField(ByteBuffer raw, Seg.SegmentInformation info, int direction) {
        int inf0 = (direction == -1 ? 0 : 1) << 24 | info.getSegmentId();
        raw.putInt(inf0);
        raw.putInt(ByteUtil.toInt(info.getTimestamp()));
    }

    private static void writeHopFields(Daemon.Path.Builder path, ByteBuffer raw, int bytePosSegID, PathSegment pathSegment, int[] range) {
        int minExpiry = Integer.MAX_VALUE;
        int pos = range[0];
        int total = 0;
        while (pos != range[1]) {
            boolean addInterfaces;
            boolean reversed = range[2] == -1;
            Seg.ASEntrySignedBody body = pathSegment.getAsEntries(pos);
            Seg.HopEntry hopEntry = body.getHopEntry();
            Seg.HopField hopField = hopEntry.getHopField();
            raw.put((byte)0);
            raw.put(ByteUtil.toByte(hopField.getExpTime()));
            raw.putShort(ByteUtil.toShort(hopField.getIngress()));
            raw.putShort(ByteUtil.toShort(hopField.getEgress()));
            ByteString mac = hopField.getMac();
            for (int j = 0; j < 6; ++j) {
                raw.put(mac.byteAt(j));
            }
            if (reversed && total > 0) {
                raw.put(bytePosSegID, ByteUtil.toByte(raw.get(bytePosSegID) ^ mac.byteAt(0)));
                raw.put(bytePosSegID + 1, ByteUtil.toByte(raw.get(bytePosSegID + 1) ^ mac.byteAt(1)));
            }
            minExpiry = Math.min(minExpiry, hopField.getExpTime());
            path.setMtu(Math.min(path.getMtu(), body.getMtu()));
            if (hopEntry.getIngressMtu() > 0) {
                path.setMtu(Math.min(path.getMtu(), hopEntry.getIngressMtu()));
            }
            boolean bl = addInterfaces = pos + range[2] != range[1];
            if (addInterfaces) {
                Daemon.PathInterface.Builder pib = Daemon.PathInterface.newBuilder();
                pib.setId(reversed ? hopField.getIngress() : hopField.getEgress());
                path.addInterfaces(pib.setIsdAs(body.getIsdAs()).build());
                Daemon.PathInterface.Builder pib2 = Daemon.PathInterface.newBuilder();
                int pos2 = pos + range[2];
                Seg.ASEntrySignedBody body2 = pathSegment.getAsEntries(pos2);
                Seg.HopField hopField2 = body2.getHopEntry().getHopField();
                pib2.setId(reversed ? hopField2.getEgress() : hopField2.getIngress());
                path.addInterfaces(pib2.setIsdAs(body2.getIsdAs()).build());
            }
            pos += range[2];
            ++total;
        }
        long time = Segments.calcExpTime(pathSegment.info.getTimestamp(), minExpiry);
        if (time < path.getExpiration().getSeconds()) {
            path.setExpiration(Timestamp.newBuilder().setSeconds((long)minExpiry).build());
        }
    }

    private static boolean detectShortcut(PathSegment[] segments, int[][] iterators) {
        if (segments.length < 2) {
            return false;
        }
        int idUp = 0;
        int idDown = segments.length - 1;
        if (segments[idUp].isCore() || segments[idDown].isCore()) {
            return false;
        }
        HashMap<Long, Integer> map = new HashMap<Long, Integer>();
        int posUp = -1;
        int[] iterUp = iterators[idUp];
        for (int pos = iterUp[0]; pos != iterUp[1]; pos += iterUp[2]) {
            Seg.ASEntrySignedBody body = segments[idUp].getAsEntries(pos);
            map.putIfAbsent(body.getIsdAs(), pos);
        }
        int posDown = -1;
        int[] iterDown = iterators[idDown];
        for (int pos = iterDown[0]; pos != iterDown[1]; pos += iterDown[2]) {
            Seg.ASEntrySignedBody body = segments[idDown].getAsEntries(pos);
            long isdAs = body.getIsdAs();
            if (!map.containsKey(isdAs)) continue;
            posUp = (Integer)map.get(isdAs);
            posDown = pos;
        }
        if (posUp >= 0) {
            iterators[0][1] = posUp + iterators[0][2];
            iterators[1][0] = posDown;
            return true;
        }
        return false;
    }

    private static boolean detectOnPathUp(PathSegment[] segments, long dstIsdAs, int[][] ranges) {
        int idUp = 0;
        if (segments[idUp].isCore()) {
            return false;
        }
        int[] iterUp = ranges[idUp];
        for (int pos = iterUp[0]; pos != iterUp[1]; pos += iterUp[2]) {
            Seg.ASEntrySignedBody body = segments[idUp].getAsEntries(pos);
            if (body.getIsdAs() != dstIsdAs) continue;
            ranges[idUp][1] = pos + ranges[idUp][2];
            return true;
        }
        return false;
    }

    private static boolean detectOnPathDown(PathSegment[] segments, long srcIA, int[][] ranges) {
        int idDown = segments.length - 1;
        if (segments.length < 2 || segments[idDown].isCore()) {
            return false;
        }
        int[] iterDown = ranges[idDown];
        for (int pos = iterDown[0]; pos != iterDown[1]; pos += iterDown[2]) {
            Seg.ASEntrySignedBody body = segments[idDown].getAsEntries(pos);
            if (body.getIsdAs() != srcIA) continue;
            ranges[idDown][0] = pos;
            return true;
        }
        return false;
    }

    private static MultiMap<Long, PathSegment> createSegmentsMap(List<PathSegment> pathSegments, long knownIsdAs) {
        MultiMap<Long, PathSegment> map = new MultiMap<Long, PathSegment>();
        for (PathSegment pathSeg : pathSegments) {
            long unknownIsdAs = Segments.getOtherIsdAs(knownIsdAs, pathSeg);
            if (unknownIsdAs == -1L) continue;
            map.put(unknownIsdAs, pathSeg);
        }
        return map;
    }

    private static long getOtherIsdAs(long isdAs, PathSegment seg) {
        long[] endings = Segments.getEndingIAs(seg);
        if (endings[0] == isdAs) {
            return endings[1];
        }
        if (endings[1] == isdAs) {
            return endings[0];
        }
        return -1L;
    }

    private static boolean containsIsdAses(PathSegment seg, long isdAs1, long isdAs2) {
        return seg.getAsEntriesList().stream().anyMatch(asEntry -> asEntry.getIsdAs() == isdAs1) && seg.getAsEntriesList().stream().anyMatch(asEntry -> asEntry.getIsdAs() == isdAs2);
    }

    static long[] getEndingIAs(PathSegment seg) {
        Seg.ASEntrySignedBody bodyFirst = seg.getAsEntriesFirst();
        Seg.ASEntrySignedBody bodyLast = seg.getAsEntriesLast();
        return new long[]{bodyFirst.getIsdAs(), bodyLast.getIsdAs()};
    }

    private static Seg.ASEntrySignedBody getBody(Seg.ASEntry asEntry) {
        if (!asEntry.hasSigned()) {
            throw new UnsupportedOperationException("Unsigned entries are not supported");
        }
        Signed.SignedMessage sm = asEntry.getSigned();
        try {
            Signed.HeaderAndBodyInternal habi = Signed.HeaderAndBodyInternal.parseFrom(sm.getHeaderAndBody());
            return Seg.ASEntrySignedBody.parseFrom(habi.getBody());
        }
        catch (InvalidProtocolBufferException e) {
            throw new ScionRuntimeException(e);
        }
    }

    private static Seg.SegmentInformation getInfo(Seg.PathSegment pathSegment) {
        try {
            return Seg.SegmentInformation.parseFrom(pathSegment.getSegmentInfo());
        }
        catch (InvalidProtocolBufferException e) {
            throw new ScionRuntimeException(e);
        }
    }

    private static List<PathSegment> filterForIsdAs(List<PathSegment> segments, long isdAs) {
        return segments.stream().filter(pathSegment -> pathSegment.getAsEntriesList().stream().anyMatch(asEntry -> asEntry.getIsdAs() == isdAs)).collect(Collectors.toList());
    }

    private static List<PathSegment> filterForEndIsdAs(List<PathSegment> segments, long isdAs) {
        return segments.stream().filter(pathSegment -> pathSegment.getAsEntriesFirst().getIsdAs() == isdAs || pathSegment.getAsEntriesLast().getIsdAs() == isdAs).collect(Collectors.toList());
    }

    private static boolean endsWithIsdAs(List<PathSegment> segments, long dstIsdAs) {
        for (PathSegment seg : segments) {
            long iaFirst = seg.getAsEntriesFirst().getIsdAs();
            long iaLast = seg.getAsEntriesLast().getIsdAs();
            if (iaFirst != dstIsdAs && iaLast != dstIsdAs) continue;
            return true;
        }
        return false;
    }

    private static class PathSegment {
        final Seg.PathSegment segment;
        final List<Seg.ASEntrySignedBody> bodies;
        final Seg.SegmentInformation info;
        final SegmentType type;

        PathSegment(Seg.PathSegment segment, SegmentType type) {
            this.segment = segment;
            this.bodies = Collections.unmodifiableList(segment.getAsEntriesList().stream().map(x$0 -> Segments.getBody(x$0)).collect(Collectors.toList()));
            this.info = Segments.getInfo(segment);
            this.type = type;
        }

        public Seg.ASEntrySignedBody getAsEntriesFirst() {
            return this.bodies.get(0);
        }

        public Seg.ASEntrySignedBody getAsEntriesLast() {
            return this.bodies.get(this.bodies.size() - 1);
        }

        public List<Seg.ASEntrySignedBody> getAsEntriesList() {
            return this.bodies;
        }

        public Seg.ASEntrySignedBody getAsEntries(int i) {
            return this.bodies.get(i);
        }

        public int getAsEntriesCount() {
            return this.bodies.size();
        }

        public ByteString getSegmentInfo() {
            return this.segment.getSegmentInfo();
        }

        public boolean isCore() {
            return this.type == SegmentType.CORE;
        }
    }

    private static enum SegmentType {
        UP,
        CORE,
        DOWN;


        public static SegmentType from(Seg.SegmentType segmentType) {
            switch (segmentType) {
                case SEGMENT_TYPE_UP: {
                    return UP;
                }
                case SEGMENT_TYPE_DOWN: {
                    return DOWN;
                }
                case SEGMENT_TYPE_CORE: {
                    return CORE;
                }
            }
            throw new IllegalArgumentException("type=" + (Object)((Object)segmentType));
        }
    }
}

