/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan.internal;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import org.scion.jpan.ResponsePath;
import org.scion.jpan.ScionDatagramChannel;
import org.scion.jpan.ScionService;
import org.scion.jpan.ScionSocketAddress;
import org.scion.jpan.internal.InternalConstants;
import org.scion.jpan.internal.ScionHeaderParser;

public class SelectingDatagramChannel
extends ScionDatagramChannel {
    private final Selector selector;
    private int timeoutMs = 0;

    public SelectingDatagramChannel(ScionService service) throws IOException {
        this(service, null);
    }

    public SelectingDatagramChannel(ScionService service, DatagramChannel channel) throws IOException {
        super(service, channel == null ? DatagramChannel.open() : channel);
        DatagramChannel channel2 = channel == null ? DatagramChannel.open() : channel;
        this.selector = channel2.provider().openSelector();
        super.channel().configureBlocking(false);
        super.channel().register(this.selector, 1);
    }

    public void setTimeOut(int timeoutMilliseconds) {
        this.timeoutMs = timeoutMilliseconds;
    }

    public int getTimeOut() {
        return this.timeoutMs;
    }

    private ResponsePath receiveFromTimeoutChannel(ByteBuffer buffer, InternalConstants.HdrTypes expectedHdrType) throws IOException {
        while (true) {
            buffer.clear();
            if (this.selector.select(this.timeoutMs) == 0) {
                return null;
            }
            Iterator<SelectionKey> iter = this.selector.selectedKeys().iterator();
            if (!iter.hasNext()) continue;
            SelectionKey key = iter.next();
            iter.remove();
            if (!key.isReadable()) continue;
            DatagramChannel incoming = (DatagramChannel)key.channel();
            InetSocketAddress srcAddress = (InetSocketAddress)incoming.receive(buffer);
            buffer.flip();
            if (!this.validate(buffer)) continue;
            InternalConstants.HdrTypes hdrType = ScionHeaderParser.extractNextHeader(buffer);
            buffer.position(ScionHeaderParser.extractHeaderLength(buffer));
            hdrType = SelectingDatagramChannel.receiveExtensionHeader(buffer, hdrType);
            InetSocketAddress firstHopAddress = this.getFirstHopAddress(buffer, srcAddress);
            ResponsePath path = ScionHeaderParser.extractResponsePath(buffer, firstHopAddress);
            if (hdrType == expectedHdrType) {
                return path;
            }
            this.receiveScmp(buffer, path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScionSocketAddress receive(ByteBuffer userBuffer) throws IOException {
        this.readLock().lock();
        try {
            ByteBuffer buffer = this.getBufferReceive(userBuffer.capacity());
            ResponsePath receivePath = this.receiveFromTimeoutChannel(buffer, InternalConstants.HdrTypes.UDP);
            if (receivePath == null) {
                ScionSocketAddress scionSocketAddress = null;
                return scionSocketAddress;
            }
            ScionHeaderParser.extractUserPayload(buffer, userBuffer);
            buffer.clear();
            ScionSocketAddress scionSocketAddress = receivePath.getRemoteSocketAddress();
            return scionSocketAddress;
        }
        finally {
            this.readLock().unlock();
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.selector.close();
    }
}

