/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.scion.jpan.Path;
import org.scion.jpan.PathMetadata;
import org.scion.jpan.ScionUtil;

public interface PathPolicy {
    public static final PathPolicy FIRST = new First();
    public static final PathPolicy MAX_BANDWIDTH = new MaxBandwith();
    public static final PathPolicy MIN_LATENCY = new MinLatency();
    public static final PathPolicy MIN_HOPS;
    public static final PathPolicy DEFAULT;

    public List<Path> filter(List<Path> var1);

    static {
        DEFAULT = MIN_HOPS = new MinHopCount();
    }

    public static class IsdDisallow
    implements PathPolicy {
        private final Set<Integer> disallowedIsds;

        public IsdDisallow(Set<Integer> disallowedIsds) {
            this.disallowedIsds = disallowedIsds;
        }

        @Override
        public List<Path> filter(List<Path> paths) {
            return paths.stream().filter(this::checkPath).collect(Collectors.toList());
        }

        private boolean checkPath(Path path) {
            for (PathMetadata.PathInterface pif : path.getMetadata().getInterfacesList()) {
                int isd = ScionUtil.extractIsd(pif.getIsdAs());
                if (!this.disallowedIsds.contains(isd)) continue;
                return false;
            }
            return true;
        }
    }

    public static class IsdAllow
    implements PathPolicy {
        private final Set<Integer> allowedIsds;

        public IsdAllow(Set<Integer> allowedIsds) {
            this.allowedIsds = allowedIsds;
        }

        @Override
        public List<Path> filter(List<Path> paths) {
            return paths.stream().filter(this::checkPath).collect(Collectors.toList());
        }

        private boolean checkPath(Path path) {
            for (PathMetadata.PathInterface pif : path.getMetadata().getInterfacesList()) {
                int isd = ScionUtil.extractIsd(pif.getIsdAs());
                if (this.allowedIsds.contains(isd)) continue;
                return false;
            }
            return true;
        }
    }

    public static class MinHopCount
    implements PathPolicy {
        @Override
        public List<Path> filter(List<Path> paths) {
            return paths.stream().sorted(Comparator.comparing(path -> path.getMetadata().getInterfacesList().size())).collect(Collectors.toList());
        }
    }

    public static class MinLatency
    implements PathPolicy {
        @Override
        public List<Path> filter(List<Path> paths) {
            return paths.stream().sorted(Comparator.comparing(path -> path.getMetadata().getLatencyList().stream().mapToLong(l -> l >= 0 ? (long)l.intValue() : Integer.MAX_VALUE).reduce(0L, Long::sum))).collect(Collectors.toList());
        }
    }

    public static class MaxBandwith
    implements PathPolicy {
        @Override
        public List<Path> filter(List<Path> paths) {
            ArrayList<Path> result = new ArrayList<Path>(paths);
            result.sort((p1, p2) -> {
                int bw1 = Collections.min(p1.getMetadata().getBandwidthList()).intValue();
                int bw2 = Collections.min(p2.getMetadata().getBandwidthList()).intValue();
                return Integer.compare(bw2, bw1);
            });
            return result;
        }
    }

    public static class First
    implements PathPolicy {
        @Override
        public List<Path> filter(List<Path> paths) {
            return paths;
        }
    }
}

