/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan.internal;

public interface InternalConstants {

    public static enum SvcTypes {
        DS(1),
        CS(2),
        SB(3),
        SIG(4),
        HPS(5);

        public final int code;

        private SvcTypes(int code) {
            this.code = code;
        }
    }

    public static enum HdrTypes implements ParseEnum
    {
        UDP(17),
        HOP_BY_HOP(200),
        END_TO_END(201),
        SCMP(202),
        BFD(203);

        public final int code;

        private HdrTypes(int code) {
            this.code = code;
        }

        public static HdrTypes parse(int code) {
            return ParseEnum.parse(HdrTypes.class, code);
        }

        @Override
        public int code() {
            return this.code;
        }
    }

    public static enum AddrTypes implements ParseEnum
    {
        IPv4(0),
        SVC(4),
        IPv6(3);

        public final int code;

        private AddrTypes(int code) {
            this.code = code;
        }

        public static AddrTypes parse(int code) {
            return ParseEnum.parse(AddrTypes.class, code);
        }

        @Override
        public int code() {
            return this.code;
        }
    }

    public static enum PathTypes implements ParseEnum
    {
        Empty(0),
        SCION(1),
        OneHop(2),
        EPIC(3),
        COLIBRI(4);

        public final int code;

        private PathTypes(int code) {
            this.code = code;
        }

        public static PathTypes parse(int code) {
            return ParseEnum.parse(PathTypes.class, code);
        }

        @Override
        public int code() {
            return this.code;
        }
    }

    public static interface ParseEnum {
        public int code();

        public static <E extends ParseEnum> E parse(Class<E> e, int code) {
            ParseEnum[] values = (ParseEnum[])e.getEnumConstants();
            for (int i = 0; i < values.length; ++i) {
                ParseEnum pe = values[i];
                if (pe.code() != code) continue;
                return (E)pe;
            }
            throw new IllegalArgumentException("Unknown code: " + code);
        }
    }
}

