/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan.internal;

import com.google.protobuf.Duration;
import org.scion.jpan.internal.Segments;
import org.scion.jpan.proto.control_plane.Seg;
import org.scion.jpan.proto.control_plane.SegExtensions;
import org.scion.jpan.proto.daemon.Daemon;

class SegmentMetadataAccumulator {
    private SegmentMetadataAccumulator() {
    }

    static void writeStaticInfoMetadata(Daemon.Path.Builder path, Segments.PathSegment[] pathSegments, int[][] ranges) {
        long prevIsdAs = -1L;
        for (int r = 0; r < ranges.length; ++r) {
            Range range = new Range(ranges[r]);
            Segments.PathSegment pathSegment = pathSegments[r];
            for (int pos = range.startIncl; pos != range.endExcl; pos += range.increment) {
                Seg.ASEntrySignedBody body = pathSegment.getAsEntries(pos);
                boolean addIntraInfo = pathSegments.length == 1 ? pos != range.first() && pos != range.last() : (pathSegments.length == 2 ? (r == 0 ? pos != range.first() : pos != range.first() && pos != range.last()) : (r == 0 ? pos != range.first() : (r == 1 ? pos != range.first() && pos != range.last() : pos != range.last())));
                boolean addIsdAs = prevIsdAs != body.getIsdAs();
                prevIsdAs = body.getIsdAs();
                SegmentMetadataAccumulator.writeStaticInfoMetadata(path, body, range, addIsdAs, addIntraInfo);
            }
        }
    }

    private static void writeStaticInfoMetadata(Daemon.Path.Builder path, Seg.ASEntrySignedBody body, Range range, boolean addIsdAs, boolean addIntraInfo) {
        SegExtensions.PathSegmentExtensions ext = body.getExtensions();
        boolean reversed = range.isReversed();
        Seg.HopField hopField = body.getHopEntry().getHopField();
        long id1 = hopField.getEgress();
        long id2 = hopField.getIngress();
        if (!ext.hasStaticInfo()) {
            if (id1 != 0L) {
                path.addLatency(SegmentMetadataAccumulator.toDuration(null));
                path.addBandwidth(0L);
                path.addGeo(SegmentMetadataAccumulator.toGeo(null));
            }
            if (id2 != 0L) {
                path.addLinkType(Daemon.LinkType.LINK_TYPE_UNSPECIFIED);
                path.addGeo(SegmentMetadataAccumulator.toGeo(null));
            }
            if (addIntraInfo) {
                path.addLatency(SegmentMetadataAccumulator.toDuration(null));
                path.addBandwidth(0L);
                path.addInternalHops(0);
            }
            if (addIsdAs) {
                path.addNotes("");
            }
            return;
        }
        SegExtensions.StaticInfoExtension sie = ext.getStaticInfo();
        if (reversed) {
            if (id1 != 0L) {
                Long bw;
                if (sie.getLatency().getInterMap().containsKey(id1)) {
                    path.addLatency(SegmentMetadataAccumulator.toDuration(sie.getLatency().getInterMap().get(id1)));
                }
                path.addBandwidth((bw = sie.getBandwidth().getInterMap().get(id1)) == null ? 0L : bw);
                path.addGeo(SegmentMetadataAccumulator.toGeo(sie.getGeoMap().get(id1)));
            }
            if (id2 != 0L) {
                path.addGeo(SegmentMetadataAccumulator.toGeo(sie.getGeoMap().get(id2)));
            }
        }
        if (addIntraInfo) {
            if (!sie.getLatency().getIntraMap().isEmpty()) {
                path.addLatency(SegmentMetadataAccumulator.toDuration(sie.getLatency().getIntraMap().values().iterator().next()));
            } else {
                path.addLatency(SegmentMetadataAccumulator.toDuration(null));
            }
            if (!sie.getBandwidth().getIntraMap().isEmpty()) {
                path.addBandwidth(sie.getBandwidth().getIntraMap().values().iterator().next());
            } else {
                path.addBandwidth(0L);
            }
            if (!sie.getInternalHopsMap().isEmpty()) {
                path.addInternalHops(sie.getInternalHopsMap().values().iterator().next());
            } else {
                path.addInternalHops(0);
            }
        }
        if (id2 != 0L) {
            if (!sie.getLinkTypeMap().isEmpty()) {
                path.addLinkType(SegmentMetadataAccumulator.toLinkType(sie.getLinkTypeMap().values().iterator().next()));
            } else {
                path.addLinkType(SegmentMetadataAccumulator.toLinkType(null));
            }
        }
        if (!reversed) {
            if (id2 != 0L) {
                path.addGeo(SegmentMetadataAccumulator.toGeo(sie.getGeoMap().get(id2)));
            }
            if (id1 != 0L) {
                Duration latency = SegmentMetadataAccumulator.toDuration(sie.getLatency().getInterMap().getOrDefault(id1, null));
                path.addLatency(latency);
                Long bw = sie.getBandwidth().getInterMap().get(id1);
                path.addBandwidth(bw == null ? 0L : bw);
                path.addGeo(SegmentMetadataAccumulator.toGeo(sie.getGeoMap().get(id1)));
            }
        }
        if (addIsdAs) {
            path.addNotes(sie.getNote());
        }
    }

    private static Duration toDuration(Integer micros) {
        if (micros == null) {
            return Duration.newBuilder().setSeconds(-1L).setNanos(-1).build();
        }
        int secs = micros / 1000000;
        int nanos = micros % 1000000 * 1000;
        return Duration.newBuilder().setSeconds((long)secs).setNanos(nanos).build();
    }

    private static Daemon.GeoCoordinates toGeo(SegExtensions.GeoCoordinates geo) {
        if (geo == null) {
            return Daemon.GeoCoordinates.newBuilder().build();
        }
        return Daemon.GeoCoordinates.newBuilder().setLatitude(geo.getLatitude()).setLongitude(geo.getLongitude()).setAddress(geo.getAddress()).build();
    }

    private static Daemon.LinkType toLinkType(SegExtensions.LinkType lt) {
        if (lt == null) {
            return Daemon.LinkType.LINK_TYPE_UNSPECIFIED;
        }
        switch (lt) {
            case LINK_TYPE_UNSPECIFIED: {
                return Daemon.LinkType.LINK_TYPE_UNSPECIFIED;
            }
            case LINK_TYPE_DIRECT: {
                return Daemon.LinkType.LINK_TYPE_DIRECT;
            }
            case LINK_TYPE_MULTI_HOP: {
                return Daemon.LinkType.LINK_TYPE_MULTI_HOP;
            }
            case LINK_TYPE_OPEN_NET: {
                return Daemon.LinkType.LINK_TYPE_OPEN_NET;
            }
        }
        return Daemon.LinkType.UNRECOGNIZED;
    }

    static class Range {
        private final int startIncl;
        private final int endExcl;
        private final int increment;

        Range(int[] range) {
            this.startIncl = range[0];
            this.endExcl = range[1];
            this.increment = range[2];
        }

        int last() {
            return this.endExcl - this.increment;
        }

        boolean isReversed() {
            return this.increment == -1;
        }

        public int first() {
            return this.startIncl;
        }
    }
}

