/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan.internal;

import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.scion.jpan.ScionRuntimeException;
import org.scion.jpan.Scmp;
import org.scion.jpan.ScmpResponder;
import org.scion.jpan.internal.ScionHeaderParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Shim
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(Shim.class);
    private static final AtomicReference<Shim> singleton = new AtomicReference();
    private final ScmpResponder scmpResponder;
    private Thread forwarder;
    private Predicate<ByteBuffer> forwardCallback = null;
    private final CountDownLatch scmpResponderBarrier = new CountDownLatch(1);

    private Shim(int port) {
        this.scmpResponder = Scmp.newResponderBuilder().setService(null).setLocalPort(port).setShim(this).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void install() {
        AtomicReference<Shim> atomicReference = singleton;
        synchronized (atomicReference) {
            if (singleton.get() == null) {
                singleton.set(Shim.newBuilder().build());
                singleton.get().start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uninstall() {
        AtomicReference<Shim> atomicReference = singleton;
        synchronized (atomicReference) {
            if (singleton.get() != null) {
                try {
                    ((Shim)singleton.getAndSet(null)).close();
                }
                catch (IOException e) {
                    throw new ScionRuntimeException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setCallback(Predicate<ByteBuffer> cb) {
        AtomicReference<Shim> atomicReference = singleton;
        synchronized (atomicReference) {
            if (singleton.get() != null) {
                Shim.singleton.get().forwardCallback = cb;
            }
        }
    }

    private static Builder newBuilder() {
        return new Builder();
    }

    public static boolean isInstalled() {
        return singleton.get() != null;
    }

    private void start() {
        this.forwarder = new Thread(this::forwardStarter, "Shim-Dispatcher");
        this.forwarder.setDaemon(true);
        this.forwarder.start();
        try {
            if (!this.scmpResponderBarrier.await(100L, TimeUnit.MILLISECONDS)) {
                log.info("Could not start SHIM: {}", (Object)this.forwarder.getName());
            } else {
                log.info("SHIM started.");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ScionRuntimeException(e);
        }
    }

    private void forwardStarter() {
        try {
            this.scmpResponder.start();
        }
        catch (BindException e) {
            log.info("Error while starting SHIM: {}", (Object)e.getMessage());
            singleton.set(null);
        }
        catch (IOException e) {
            throw new ScionRuntimeException(e);
        }
    }

    public void signalReadiness() {
        this.scmpResponderBarrier.countDown();
    }

    private void stopHandler(Thread thread) {
        thread.interrupt();
        try {
            thread.join(100L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void close() throws IOException {
        this.stopHandler(this.forwarder);
        this.scmpResponder.close();
    }

    public void forward(ByteBuffer buf, DatagramChannel channel) {
        buf.rewind();
        try {
            if (this.forwardCallback == null || this.forwardCallback.test(buf)) {
                InetSocketAddress dst = ScionHeaderParser.extractDestinationSocketAddress(buf);
                if (dst == null) {
                    log.error("SCMP error with truncated UDP header");
                    return;
                }
                log.info("Forwarding packet to {}", (Object)dst);
                channel.send(buf, dst);
            }
        }
        catch (Exception e) {
            log.info("ERROR while forwarding packet: {}", (Object)e.getMessage());
        }
    }

    public static class Builder {
        Builder() {
        }

        public Shim build() {
            return new Shim(30041);
        }
    }
}

