/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan.internal;

import java.util.HashMap;
import java.util.TreeMap;

public class SimpleCache<K, V> {
    private final TreeMap<Long, Entry> ageMap = new TreeMap();
    private final HashMap<K, Entry> lookupMap = new HashMap();
    private int capacity;
    private long opCount = 0L;

    public SimpleCache(int capacity) {
        if (capacity < 1) {
            throw new IllegalArgumentException();
        }
        this.capacity = capacity;
    }

    public void put(K key, V value) {
        Entry e = this.lookupMap.get(key);
        if (e == null) {
            e = new Entry(this.opCount++, key, value);
            this.checkCapacity(1);
            this.lookupMap.put(key, e);
        } else {
            this.ageMap.remove(e.age);
            e.age = this.opCount++;
            e.value = value;
        }
        this.ageMap.put(e.age, e);
    }

    public V get(K key) {
        Entry e = this.lookupMap.get(key);
        if (e == null) {
            return null;
        }
        this.ageMap.remove(e.age);
        e.age = this.opCount++;
        this.ageMap.put(e.age, e);
        return (V)e.value;
    }

    public void clear() {
        this.lookupMap.clear();
        this.ageMap.clear();
    }

    public void setCapacity(int capacity) {
        if (capacity < 1) {
            throw new IllegalArgumentException();
        }
        this.capacity = capacity;
        this.checkCapacity(0);
    }

    public int getCapacity() {
        return this.capacity;
    }

    private void checkCapacity(int spare) {
        while (this.lookupMap.size() + spare > this.capacity) {
            Entry e = this.ageMap.pollFirstEntry().getValue();
            this.lookupMap.remove(e.key);
        }
    }

    private class Entry {
        private long age;
        private final K key;
        private V value;

        public Entry(long l, K key, V value) {
            this.age = l;
            this.key = key;
            this.value = value;
        }
    }
}

