/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan.ppl;

import java.util.Arrays;
import java.util.Objects;
import org.scion.jpan.PathMetadata;
import org.scion.jpan.ScionUtil;
import org.scion.jpan.ppl.PplException;
import org.scion.jpan.ppl.PplUtil;

class HopPredicate {
    private int isd;
    private long as;
    private final int[] ifIDs;

    static HopPredicate create(int isd, long as, int[] ifIDs) {
        return new HopPredicate(isd, as, ifIDs);
    }

    private HopPredicate(int isd, int[] ifIDs) {
        this.isd = isd;
        this.ifIDs = ifIDs;
    }

    private HopPredicate(int isd, long as, int[] ifIDs) {
        this.isd = isd;
        this.as = as;
        this.ifIDs = ifIDs;
    }

    static HopPredicate fromString(String str) {
        long as;
        int isd;
        HopPredicate.validateHopPredStr(str);
        int[] ifIDs = new int[1];
        String[] dashParts = str.split("-");
        try {
            isd = ScionUtil.parseISD(dashParts[0]);
        }
        catch (Exception e) {
            throw new PplException("Failed to parse ISD: value=" + str, e);
        }
        if (dashParts.length == 1) {
            return new HopPredicate(isd, ifIDs);
        }
        String[] hashParts = dashParts[1].split("#");
        try {
            as = ScionUtil.parseAS(hashParts[0]);
        }
        catch (Exception e) {
            throw new PplException("Failed to parse AS: value=" + str, e);
        }
        if (hashParts.length == 1) {
            return new HopPredicate(isd, as, ifIDs);
        }
        String[] commaParts = hashParts[1].split(",");
        try {
            ifIDs[0] = HopPredicate.parseIfID(commaParts[0]);
        }
        catch (Exception e) {
            throw new PplException("Failed to parse ifIDs: value=" + str, e);
        }
        if (commaParts.length == 2) {
            try {
                int ifID = HopPredicate.parseIfID(commaParts[1]);
                ifIDs = Arrays.copyOf(ifIDs, ifIDs.length + 1);
                ifIDs[ifIDs.length - 1] = ifID;
            }
            catch (Exception e) {
                throw new PplException("Failed to parse ifIDs: value=" + str, e);
            }
        }
        if (as == 0L && (ifIDs[0] != 0 || ifIDs.length > 1 && ifIDs[1] != 0)) {
            throw new PplException("Failed to parse hop predicate, IfIDs must be 0: value=" + str);
        }
        return new HopPredicate(isd, as, ifIDs);
    }

    boolean pathIFMatch(PathMetadata.PathInterface pi, boolean in) {
        if (this.isd != 0 && ScionUtil.extractIsd(pi.getIsdAs()) != this.isd) {
            return false;
        }
        if (this.as != 0L && ScionUtil.extractAs(pi.getIsdAs()) != this.as) {
            return false;
        }
        int ifInd = 0;
        if (this.ifIDs.length == 2 && !in) {
            ifInd = 1;
        }
        return this.ifIDs[ifInd] == 0 || (long)this.ifIDs[ifInd] == pi.getId();
    }

    boolean matchesAll() {
        return this.isd == 0 && this.as == 0L;
    }

    String string() {
        StringBuilder sb = new StringBuilder();
        for (int ifID : this.ifIDs) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(ifID);
        }
        if (sb.length() == 1 && sb.toString().equals("0")) {
            return PplUtil.toMinimal(this.isd, this.as);
        }
        return ScionUtil.toStringIA(this.isd, this.as) + "#" + sb;
    }

    private static int parseIfID(String str) {
        return Integer.parseInt(str, 10);
    }

    private static void validateHopPredStr(String str) {
        int dashes = HopPredicate.count(str, '-');
        int hashes = HopPredicate.count(str, '#');
        int commas = HopPredicate.count(str, ',');
        if (dashes > 1 || hashes > 1 || commas > 1) {
            throw new PplException("Failed to parse hop predicate, found delimiter too often: dashes=" + dashes + "; hashes=" + hashes + "; commas=" + commas);
        }
        if (dashes == 0 && (hashes > 0 || commas > 0)) {
            throw new PplException("Can't specify IFIDs without AS");
        }
    }

    private static int count(String str, char c) {
        int n = 0;
        for (int i = 0; i < str.length(); ++i) {
            n += str.charAt(i) == c ? 1 : 0;
        }
        return n;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HopPredicate that = (HopPredicate)o;
        return this.isd == that.isd && this.as == that.as && Objects.deepEquals(this.ifIDs, that.ifIDs);
    }

    public int hashCode() {
        return Objects.hash(this.isd, this.as, Arrays.hashCode(this.ifIDs));
    }

    public String toString() {
        return "HopPredicate{isd=" + this.isd + ", as=" + this.as + ", ifIDs=" + Arrays.toString(this.ifIDs) + '}';
    }
}

