/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan.ppl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.scion.jpan.Path;
import org.scion.jpan.PathMetadata;
import org.scion.jpan.PathPolicy;
import org.scion.jpan.ppl.ACL;
import org.scion.jpan.ppl.PplDefaults;
import org.scion.jpan.ppl.PplException;
import org.scion.jpan.ppl.PplExtPolicy;
import org.scion.jpan.ppl.Sequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PplPathFilter
implements PathPolicy {
    private static final Logger log = LoggerFactory.getLogger(PplPathFilter.class);
    private final String name;
    private ACL acl;
    private Sequence sequence;
    private Option[] options;
    private final PplDefaults defaults;

    PplPathFilter(String name, ACL acl, Sequence sequence, PplDefaults defaults, Option ... options) {
        this.name = name;
        this.acl = acl;
        this.sequence = sequence;
        this.defaults = defaults;
        this.options = options == null ? new Option[]{} : options;
        Arrays.sort(this.options, (o1, o2) -> -Integer.compare(((Option)o1).weight, ((Option)o2).weight));
    }

    private static PplPathFilter createCopy(PplPathFilter policy) {
        return new PplPathFilter(policy.name, policy.acl, policy.sequence, policy.defaults, policy.options);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public List<Path> filter(List<Path> paths) {
        return this.filter(paths, null);
    }

    List<Path> filter(List<Path> paths, PplDefaults defaults) {
        return this.filterOpt(paths, defaults, new FilterOptions(false));
    }

    List<Path> filterOpt(List<Path> paths, PplDefaults globalDefaults, FilterOptions opts) {
        if (this.defaults != null) {
            paths = this.defaults.filter(paths, globalDefaults);
        }
        List<Path> list = paths = this.acl == null ? paths : this.acl.eval(paths);
        if (this.sequence != null && !opts.ignoreSequence) {
            paths = this.sequence.eval(paths);
        }
        if (this.options.length > 0) {
            paths = this.evalOptions(paths, globalDefaults, opts);
        }
        if (this.defaults != null) {
            this.defaults.sortPaths(paths);
        }
        return paths;
    }

    public static PplPathFilter policyFromExtPolicy(PplExtPolicy extPolicy, PplExtPolicy[] extended) {
        PplPathFilter policy = PplPathFilter.createCopy(extPolicy);
        policy.applyExtended(extPolicy.getExtensions(), extended);
        return policy;
    }

    private void applyExtended(String[] extensions, PplExtPolicy[] exPolicies) {
        for (int i = extensions.length - 1; i >= 0; --i) {
            PplPathFilter policy = null;
            for (PplExtPolicy exPol : exPolicies) {
                if (!Objects.equals(exPol.getName(), extensions[i])) continue;
                policy = PplPathFilter.policyFromExtPolicy(exPol, exPolicies);
            }
            if (policy == null) {
                throw new PplException("Extended policy could not be found: " + extensions[i]);
            }
            if (this.acl == null && policy.acl != null) {
                this.acl = policy.acl;
            }
            if (this.options.length == 0) {
                this.options = policy.options;
            }
            if (this.sequence != null) continue;
            this.sequence = policy.sequence;
        }
    }

    private List<Path> evalOptions(List<Path> paths, PplDefaults defaults, FilterOptions opts) {
        HashSet<String> subPolicySet = new HashSet<String>();
        int currWeight = this.options[0].weight;
        for (Option option : this.options) {
            if (currWeight > option.weight && !subPolicySet.isEmpty()) break;
            currWeight = option.weight;
            List<Path> subPaths = option.policy.filterOpt(paths, defaults, opts);
            for (Path path : subPaths) {
                subPolicySet.add(PplPathFilter.fingerprint(path));
            }
        }
        ArrayList<Path> result = new ArrayList<Path>();
        for (Path path : paths) {
            if (!subPolicySet.contains(PplPathFilter.fingerprint(path))) continue;
            result.add(path);
        }
        return result;
    }

    private static String fingerprint(Path path) {
        PathMetadata meta = path.getMetadata();
        if (meta == null || meta.getInterfacesList().isEmpty()) {
            return "";
        }
        try {
            MessageDigest h = MessageDigest.getInstance("SHA-256");
            ByteBuffer bb = ByteBuffer.allocate(16 * meta.getInterfacesList().size());
            for (PathMetadata.PathInterface intf : meta.getInterfacesList()) {
                bb.putLong(intf.getIsdAs());
                bb.putLong(intf.getId());
            }
            byte[] digest = h.digest(bb.array());
            return new String(digest, StandardCharsets.UTF_8);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String getSequence(Path path) {
        return Sequence.getSequence(path);
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PplPathFilter policy = (PplPathFilter)o;
        return Objects.equals(this.name, policy.name) && Objects.equals(this.acl, policy.acl) && Objects.equals(this.sequence, policy.sequence) && Objects.deepEquals(this.options, policy.options);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.acl, this.sequence, Arrays.hashCode(this.options));
    }

    public String toString() {
        return "PplPathFilter{name='" + this.name + "', acl=" + this.acl + ", sequence=" + this.sequence + ", options=" + Arrays.toString(this.options) + '}';
    }

    static PplPathFilter fromJson(String name, JsonObject json) {
        Builder b = new Builder();
        b.setName(name);
        block16: for (Map.Entry p : json.getAsJsonObject().entrySet()) {
            switch ((String)p.getKey()) {
                case "acl": {
                    for (JsonElement e : ((JsonElement)p.getValue()).getAsJsonArray()) {
                        b.addAclEntry(e.getAsString());
                    }
                    continue block16;
                }
                case "sequence": {
                    b.setSequence(((JsonElement)p.getValue()).getAsString());
                    break;
                }
                case "min_mtu": {
                    b.minMtu(((JsonElement)p.getValue()).getAsInt());
                    break;
                }
                case "min_validity_sec": {
                    b.minValidity(((JsonElement)p.getValue()).getAsInt());
                    break;
                }
                case "min_meta_bandwidth": {
                    b.minMetaBandwidth(((JsonElement)p.getValue()).getAsLong());
                    break;
                }
                case "ordering": {
                    b.ordering(((JsonElement)p.getValue()).getAsString());
                    break;
                }
                default: {
                    log.warn("Unknown key in filter \"{}\": {}", (Object)name, p.getKey());
                }
            }
        }
        return b.build();
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        if (this.acl != null) {
            json.add("acl", this.acl.toJson());
        }
        if (this.sequence != null) {
            json.addProperty("sequence", this.sequence.getSourceString());
        }
        if (this.defaults != null) {
            this.defaults.toJson(json);
        }
        return json;
    }

    public static class Builder {
        protected String name = "";
        Sequence sequence = null;
        final List<Option> options = new ArrayList<Option>();
        final List<ACL.AclEntry> entries = new ArrayList<ACL.AclEntry>();
        private final PplDefaults.Builder defaults = new PplDefaults.Builder();

        Builder() {
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder addAclEntry(String str) {
            this.entries.add(ACL.AclEntry.create(str));
            return this;
        }

        public Builder addAclEntries(String ... strings) {
            for (String str : strings) {
                this.entries.add(ACL.AclEntry.create(str));
            }
            if (strings.length == 0) {
                throw new PplException("ACL does not have a default");
            }
            return this;
        }

        public Builder addAclEntry(boolean allow, String hopFieldPredicate) {
            this.entries.add(ACL.AclEntry.create(allow, hopFieldPredicate));
            return this;
        }

        public Builder setSequence(String sequence) {
            this.sequence = Sequence.create(sequence);
            return this;
        }

        public Builder minMetaBandwidth(long minBandwidthBytesPerSeconds) {
            this.defaults.minMetaBandwidth(minBandwidthBytesPerSeconds);
            return this;
        }

        public Builder minMtu(int minMtuBytes) {
            this.defaults.minMtu(minMtuBytes);
            return this;
        }

        public Builder minValidity(int minValiditySeconds) {
            this.defaults.minValidity(minValiditySeconds);
            return this;
        }

        public Builder ordering(String ordering) {
            this.defaults.ordering(ordering);
            return this;
        }

        @Deprecated
        public Builder addOption(int weight, PplExtPolicy policy) {
            this.options.add(Option.create(weight, policy));
            return this;
        }

        public PplPathFilter build() {
            if (this.entries.isEmpty() && this.sequence == null && this.options.isEmpty()) {
                throw new PplException("ACL does not have a default");
            }
            ACL acl = this.entries.isEmpty() ? null : ACL.create(this.entries.toArray(new ACL.AclEntry[0]));
            return new PplPathFilter(this.name, acl, this.sequence, this.defaults.build(), this.options.toArray(new Option[0]));
        }

        PplPathFilter buildNoValidate() {
            ACL acl = this.entries.isEmpty() ? null : ACL.createNoValidate(this.entries.toArray(new ACL.AclEntry[0]));
            return new PplPathFilter(this.name, acl, this.sequence, this.defaults.build(), this.options.toArray(new Option[0]));
        }
    }

    @Deprecated
    static class Option {
        private final int weight;
        private final PplExtPolicy policy;

        private Option(int weight, PplExtPolicy policy) {
            this.weight = weight;
            this.policy = policy;
        }

        static Option create(int weight, PplExtPolicy policy) {
            return new Option(weight, policy);
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Option option = (Option)o;
            return this.weight == option.weight && Objects.equals(this.policy, option.policy);
        }

        public int hashCode() {
            return Objects.hash(this.weight, this.policy);
        }

        public String toString() {
            return "Option{weight=" + this.weight + ", policy=" + this.policy + '}';
        }
    }

    static class FilterOptions {
        private final boolean ignoreSequence;

        FilterOptions(boolean ignoreSequence) {
            this.ignoreSequence = ignoreSequence;
        }

        public static FilterOptions create(boolean ignoreSequence) {
            return new FilterOptions(ignoreSequence);
        }
    }
}

