/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan.ppl;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.scion.jpan.Path;
import org.scion.jpan.PathPolicy;
import org.scion.jpan.ScionRuntimeException;
import org.scion.jpan.ScionSocketAddress;
import org.scion.jpan.ScionUtil;
import org.scion.jpan.internal.IPHelper;
import org.scion.jpan.ppl.PplDefaults;
import org.scion.jpan.ppl.PplException;
import org.scion.jpan.ppl.PplPathFilter;
import org.scion.jpan.ppl.PplUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PplPolicy
implements PathPolicy {
    private static final Logger log = LoggerFactory.getLogger(PplPolicy.class);
    private final List<Entry> policies;
    private final PplDefaults defaults;

    private PplPolicy(List<Entry> policies, PplDefaults defaults) {
        this.policies = policies;
        this.defaults = defaults;
    }

    @Override
    public List<Path> filter(List<Path> input) {
        if (input.isEmpty()) {
            return Collections.emptyList();
        }
        List<Path> filtered = new ArrayList<Path>(input);
        ScionSocketAddress destination = ((Path)filtered.get(0)).getRemoteSocketAddress();
        for (Entry entry : this.policies) {
            if (!entry.isMatch(destination)) continue;
            filtered = entry.policy.filter(filtered, this.defaults);
            break;
        }
        this.defaults.sortPaths(filtered);
        return filtered;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static PplPolicy fromJson(java.nio.file.Path file) {
        StringBuilder contentBuilder = new StringBuilder();
        try (Stream<String> stream = Files.lines(file, StandardCharsets.UTF_8);){
            stream.forEach(s -> contentBuilder.append((String)s).append("\n"));
        }
        catch (IOException e) {
            throw new ScionRuntimeException("Error reading topology file: " + file.toAbsolutePath(), e);
        }
        return PplPolicy.fromJson(contentBuilder.toString());
    }

    public static PplPolicy fromJson(String jsonFile) {
        try {
            JsonElement jsonTree = JsonParser.parseString((String)jsonFile);
            if (!jsonTree.isJsonObject()) {
                throw new IllegalArgumentException("Bad file format: " + jsonFile);
            }
            JsonObject parentSet = jsonTree.getAsJsonObject();
            Builder defaultsBuilder = new Builder();
            JsonElement defaultsElement = parentSet.get("defaults");
            if (defaultsElement != null) {
                block14: for (Map.Entry p : defaultsElement.getAsJsonObject().entrySet()) {
                    switch ((String)p.getKey()) {
                        case "min_mtu": {
                            defaultsBuilder.minMtu(((JsonElement)p.getValue()).getAsInt());
                            continue block14;
                        }
                        case "min_validity_sec": {
                            defaultsBuilder.minValidity(((JsonElement)p.getValue()).getAsInt());
                            continue block14;
                        }
                        case "min_meta_bandwidth": {
                            defaultsBuilder.minMetaBandwidth(((JsonElement)p.getValue()).getAsLong());
                            continue block14;
                        }
                        case "ordering": {
                            defaultsBuilder.ordering(((JsonElement)p.getValue()).getAsString());
                            continue block14;
                        }
                    }
                    log.warn("Unknown key in \"defaults\": {}", p.getKey());
                }
            }
            HashMap policies = new HashMap();
            JsonObject filterSet = parentSet.get("filters").getAsJsonObject();
            for (Map.Entry p : filterSet.entrySet()) {
                PplPathFilter pf = PplPathFilter.fromJson((String)p.getKey(), ((JsonElement)p.getValue()).getAsJsonObject());
                policies.put(p.getKey(), pf);
            }
            JsonObject destinationSet = parentSet.get("destinations").getAsJsonObject();
            for (Map.Entry entry : destinationSet.entrySet()) {
                String destination = (String)entry.getKey();
                String policyName = ((JsonElement)entry.getValue()).getAsString();
                PplPathFilter policy = (PplPathFilter)policies.get(policyName);
                if (policy == null) {
                    throw new IllegalArgumentException("Policy not found: " + policyName);
                }
                defaultsBuilder.add(destination, policy);
            }
            if (defaultsBuilder.list.isEmpty()) {
                throw new IllegalArgumentException("No entries in group");
            }
            PplPathFilter defaultPolicy = (PplPathFilter)policies.get("default");
            Entry defaultEntry = (Entry)defaultsBuilder.list.get(defaultsBuilder.list.size() - 1);
            if (defaultPolicy == null || defaultEntry.dstISD != 0) {
                throw new IllegalArgumentException("No default in group");
            }
            return defaultsBuilder.build();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error parsing JSON: " + e.getMessage(), e);
        }
    }

    public String toJson(boolean prettyPrint) {
        JsonObject rootObj = new JsonObject();
        JsonObject destObj = new JsonObject();
        for (Entry entry : this.policies) {
            String key = PplUtil.toMinimal(entry.dstISD, entry.dstAS, entry.dstIP, entry.dstPort);
            destObj.addProperty(key, entry.policy.getName());
        }
        destObj.addProperty("0", "default");
        rootObj.add("destinations", (JsonElement)destObj);
        JsonObject defaultsObj = new JsonObject();
        this.defaults.toJson(defaultsObj);
        rootObj.add("defaults", (JsonElement)defaultsObj);
        JsonObject filtersObj = new JsonObject();
        for (Entry entry : this.policies) {
            filtersObj.add(entry.policy.getName(), (JsonElement)entry.policy.toJson());
        }
        rootObj.add("filters", (JsonElement)filtersObj);
        GsonBuilder gsonBuilder = new GsonBuilder();
        if (prettyPrint) {
            gsonBuilder.setPrettyPrinting();
        }
        return gsonBuilder.create().toJson((JsonElement)rootObj);
    }

    public static class Builder {
        private final List<Entry> list = new ArrayList<Entry>();
        private final PplDefaults.Builder defaults = new PplDefaults.Builder();

        public Builder add(String destination, PplPathFilter policy) {
            this.list.add(new Entry(destination, policy));
            return this;
        }

        public Builder minMetaBandwidth(long minBandwidthBytesPerSeconds) {
            this.defaults.minMetaBandwidth(minBandwidthBytesPerSeconds);
            return this;
        }

        public Builder minMtu(int minMtuBytes) {
            this.defaults.minMtu(minMtuBytes);
            return this;
        }

        public Builder minValidity(int minValiditySeconds) {
            this.defaults.minValidity(minValiditySeconds);
            return this;
        }

        public Builder ordering(String ordering) {
            this.defaults.ordering(ordering);
            return this;
        }

        public PplPolicy build() {
            if (this.list.isEmpty()) {
                throw new PplException("Policy has no default filter");
            }
            return new PplPolicy(this.list, this.defaults.build());
        }
    }

    private static class Entry {
        private final int dstISD;
        private final long dstAS;
        private final byte[] dstIP;
        private final int dstPort;
        private final PplPathFilter policy;

        private Entry(String destination, PplPathFilter policy) {
            this.policy = policy;
            String[] parts = destination.split("-");
            if (parts.length < 1 || parts.length > 2) {
                throw new IllegalArgumentException("Bad destination format: " + destination);
            }
            this.dstISD = Integer.parseInt(parts[0]);
            if (parts.length == 1) {
                this.dstAS = 0L;
                this.dstIP = null;
                this.dstPort = 0;
                return;
            }
            parts = parts[1].split(",");
            this.dstAS = ScionUtil.parseAS(parts[0]);
            if (parts.length > 2) {
                throw new IllegalArgumentException("Bad destination format: " + destination);
            }
            if (parts.length == 1) {
                this.dstIP = null;
                this.dstPort = 0;
                return;
            }
            String[] partsIP = parts[1].split(":");
            if (partsIP.length == 1) {
                this.dstIP = IPHelper.toByteArray(partsIP[0]);
                this.dstPort = 0;
                return;
            }
            if (partsIP.length == 2) {
                this.dstIP = IPHelper.toByteArray(partsIP[0]);
                this.dstPort = Integer.parseInt(partsIP[1]);
                return;
            }
            String[] partsIPv6 = parts[1].split("]");
            this.dstIP = IPHelper.toByteArray(partsIPv6[0].substring(1));
            if (partsIPv6.length == 1) {
                this.dstPort = 0;
                return;
            }
            this.dstPort = Integer.parseInt(partsIPv6[1].substring(1));
        }

        public boolean isMatch(ScionSocketAddress destination) {
            if (!(this.dstISD != 0 && this.dstISD != ScionUtil.extractIsd(destination.getIsdAs()) || this.dstAS != 0L && this.dstAS != ScionUtil.extractAs(destination.getIsdAs()) || this.dstIP != null && !Arrays.equals(this.dstIP, destination.getAddress().getAddress()))) {
                return this.dstPort == 0 || this.dstPort == destination.getPort();
            }
            return false;
        }
    }
}

