/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.NotYetConnectedException;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.scion.jpan.Path;
import org.scion.jpan.PathPolicy;
import org.scion.jpan.RequestPath;
import org.scion.jpan.ResponsePath;
import org.scion.jpan.ScionException;
import org.scion.jpan.ScionRuntimeException;
import org.scion.jpan.ScionService;
import org.scion.jpan.ScionSocketAddress;
import org.scion.jpan.ScionSocketOptions;
import org.scion.jpan.ScionUtil;
import org.scion.jpan.Scmp;
import org.scion.jpan.internal.ByteUtil;
import org.scion.jpan.internal.ExtensionHeader;
import org.scion.jpan.internal.InternalConstants;
import org.scion.jpan.internal.LocalTopology;
import org.scion.jpan.internal.NatMapping;
import org.scion.jpan.internal.PathRawParserLight;
import org.scion.jpan.internal.ScionHeaderParser;
import org.scion.jpan.internal.ScmpParser;

abstract class AbstractDatagramChannel<C extends AbstractDatagramChannel<?>>
implements Closeable {
    protected static final int DEFAULT_BUFFER_SIZE = 2000;
    private final DatagramChannel channel;
    private ByteBuffer bufferReceive;
    private ByteBuffer bufferSend;
    private final Object stateLock = new Object();
    private final ReentrantLock readLock = new ReentrantLock();
    private final ReentrantLock writeLock = new ReentrantLock();
    private RequestPath connectionPath;
    private InetAddress localAddress;
    private boolean isBoundToAddress = false;
    private boolean cfgReportFailedValidation = false;
    private PathPolicy pathPolicy = PathPolicy.DEFAULT;
    private final ScionService service;
    private int cfgExpirationSafetyMargin = ScionUtil.getPropertyOrEnv("org.scion.pathExpiryMargin", "SCION_PATH_EXPIRY_MARGIN", 10);
    private int cfgTrafficClass;
    private Consumer<Scmp.ErrorMessage> errorListener;
    private boolean cfgRemoteDispatcher = false;
    private InetSocketAddress overrideExternalAddress = null;
    private NatMapping natMapping = null;

    protected AbstractDatagramChannel(ScionService service, DatagramChannel channel) {
        this.channel = channel;
        this.service = service;
        this.bufferReceive = ByteBuffer.allocateDirect(2000);
        this.bufferSend = ByteBuffer.allocateDirect(2000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configureBlocking(boolean block) throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.channel.configureBlocking(block);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBlocking() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.channel.isBlocking();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PathPolicy getPathPolicy() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.pathPolicy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPathPolicy(PathPolicy pathPolicy) {
        Object object = this.stateLock;
        synchronized (object) {
            this.pathPolicy = pathPolicy;
            if (this.isConnected()) {
                ScionSocketAddress destination = this.connectionPath.getRemoteSocketAddress();
                this.connectionPath = (RequestPath)this.applyFilter(this.getService().getPaths(this.connectionPath), destination).get(0);
                this.updateConnection(this.connectionPath, true);
            }
        }
    }

    protected List<Path> applyFilter(List<Path> paths, Object address) throws ScionRuntimeException {
        List<Path> filtered = this.getPathPolicy().filter(paths);
        if (filtered.isEmpty()) {
            String isdAs = ScionUtil.toStringIA(paths.get(0).getRemoteIsdAs());
            throw new ScionRuntimeException("No path found to destination: " + isdAs + " --- " + address);
        }
        return filtered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScionService getService() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.service;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DatagramChannel channel() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.channel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public C bind(InetSocketAddress address) throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.channel.bind(address);
            this.isBoundToAddress = address != null;
            this.localAddress = ((InetSocketAddress)this.channel.getLocalAddress()).getAddress();
            if (this.service != null) {
                this.getNatMapping();
            }
            return (C)this;
        }
    }

    private NatMapping getNatMapping() {
        this.checkService();
        if (this.natMapping == null) {
            this.natMapping = this.getService().getNatMapping(this.channel);
        }
        return this.natMapping;
    }

    private void ensureNatMapping() {
        if (this.service != null) {
            this.getNatMapping();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureBound() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.localAddress == null) {
                LocalTopology.DispatcherPortRange ports = this.getService().getLocalPortRange();
                if (ports.hasPortRange()) {
                    int min = ports.getPortMin();
                    int max = ports.getPortMax();
                    for (int port = min; port <= max; ++port) {
                        try {
                            this.bind(new InetSocketAddress(port));
                            return;
                        }
                        catch (IOException iOException) {
                            continue;
                        }
                    }
                    throw new IOException("No free port found in SCION port range: " + min + "-" + max);
                }
                this.bind(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetSocketAddress getLocalAddress() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.localAddress == null) {
                return null;
            }
            int port = ((InetSocketAddress)this.channel.getLocalAddress()).getPort();
            return new InetSocketAddress(this.localAddress, port);
        }
    }

    public InetSocketAddress getRemoteAddress() throws IOException {
        Path path = this.getConnectionPath();
        if (path != null) {
            return path.getRemoteSocketAddress();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.connectionPath = null;
            this.natMapping = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.channel.isOpen();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.natMapping != null) {
                this.natMapping.close();
            }
            this.channel.disconnect();
            this.channel.close();
            this.connectionPath = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public C connect(SocketAddress addr) throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.checkConnected(false);
            if (!(addr instanceof InetSocketAddress)) {
                throw new IllegalArgumentException("connect() requires an InetSocketAddress or a ScionSocketAddress.");
            }
            if (addr instanceof ScionSocketAddress) {
                return this.connect(((ScionSocketAddress)addr).getPath());
            }
            InetSocketAddress destination = (InetSocketAddress)addr;
            Path path = this.applyFilter(this.getService().lookupPaths(destination), destination).get(0);
            return this.connect(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public C connect(Path path) throws IOException {
        if (!(path instanceof RequestPath)) {
            throw new IllegalStateException("The path must be a request path.");
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.checkConnected(false);
            this.ensureBound();
            if (this.localAddress.isAnyLocalAddress()) {
                this.localAddress = this.getNatMapping().getExternalIP();
            }
            this.updateConnection((RequestPath)path, false);
            return (C)this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path getConnectionPath() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.connectionPath;
        }
    }

    protected ResponsePath receiveFromChannel(ByteBuffer buffer, InternalConstants.HdrTypes expectedHdrType) throws IOException {
        this.ensureBound();
        this.ensureNatMapping();
        while (true) {
            buffer.clear();
            InetSocketAddress srcAddress = (InetSocketAddress)this.channel.receive(buffer);
            if (srcAddress == null) {
                return null;
            }
            buffer.flip();
            if (this.natMapping != null) {
                this.natMapping.touch(srcAddress);
            }
            if (!this.validate(buffer.asReadOnlyBuffer())) continue;
            InternalConstants.HdrTypes hdrType = ScionHeaderParser.extractNextHeader(buffer);
            buffer.position(ScionHeaderParser.extractHeaderLength(buffer));
            hdrType = AbstractDatagramChannel.receiveExtensionHeader(buffer, hdrType);
            InetSocketAddress firstHopAddress = this.getFirstHopAddress(buffer, srcAddress);
            ResponsePath path = ScionHeaderParser.extractResponsePath(buffer, firstHopAddress);
            if (hdrType == expectedHdrType) {
                return path;
            }
            this.receiveScmp(buffer, path);
        }
    }

    protected InetSocketAddress getFirstHopAddress(ByteBuffer buffer, InetSocketAddress srcAddress) {
        if (this.getService() != null) {
            int oldPos = buffer.position();
            int pathPos = ScionHeaderParser.extractPathHeaderPosition(buffer);
            if (pathPos > 0) {
                buffer.position(pathPos);
                int segCount = PathRawParserLight.extractSegmentCount(buffer);
                buffer.position(pathPos + 4 + segCount * 8);
                int interfaceId1 = PathRawParserLight.extractHopFieldEgress(buffer, segCount, 0);
                int interfaceId2 = PathRawParserLight.extractHopFieldIngress(buffer, segCount, 0);
                buffer.position(oldPos);
                int interfaceId = interfaceId2 == 0 ? interfaceId1 : interfaceId2;
                return this.service.getBorderRouterAddress(interfaceId);
            }
        }
        return srcAddress;
    }

    protected static InternalConstants.HdrTypes receiveExtensionHeader(ByteBuffer buffer, InternalConstants.HdrTypes hdrType) {
        ExtensionHeader extHdr;
        if ((hdrType == InternalConstants.HdrTypes.END_TO_END || hdrType == InternalConstants.HdrTypes.HOP_BY_HOP) && (hdrType = (extHdr = ExtensionHeader.consume(buffer)).nextHdr()) != InternalConstants.HdrTypes.SCMP) {
            throw new UnsupportedOperationException("Extension header not supported: " + hdrType);
        }
        return hdrType;
    }

    protected void receiveScmp(ByteBuffer buffer, Path path) {
        Scmp.Type type = ScmpParser.extractType(buffer);
        Scmp.Message msg = Scmp.createMessage(type, path);
        ScmpParser.consume(buffer, msg);
        this.checkListeners(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkListeners(Scmp.Message scmpMsg) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.errorListener != null && scmpMsg.getTypeCode().isError()) {
                this.errorListener.accept((Scmp.ErrorMessage)scmpMsg);
            }
        }
    }

    @Deprecated
    public void configureRemoteDispatcher(boolean hasDispatcher) {
        this.cfgRemoteDispatcher = hasDispatcher;
    }

    public void setOverrideSourceAddress(InetSocketAddress address) {
        this.overrideExternalAddress = address;
    }

    public InetSocketAddress getOverrideSourceAddress() {
        return this.overrideExternalAddress;
    }

    private InetSocketAddress getSourceAddress(Path path) {
        if (this.overrideExternalAddress != null) {
            return this.overrideExternalAddress;
        }
        return this.getNatMapping().getMappedAddress(path);
    }

    protected int sendRaw(ByteBuffer buffer, Path path) throws IOException {
        InetSocketAddress remoteHost = path.getFirstHopAddress();
        if (this.cfgRemoteDispatcher && path.getRawPath().length == 0) {
            InetAddress remoteHostIP = remoteHost.getAddress();
            return this.channel.send(buffer, new InetSocketAddress(remoteHostIP, 30041));
        }
        if (this.getService() != null && path.getRawPath().length == 0) {
            remoteHost = path.getRemoteSocketAddress();
            remoteHost = this.getService().getLocalPortRange().mapToLocalPort(remoteHost);
        }
        return this.channel.send(buffer, remoteHost);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Consumer<Scmp.ErrorMessage> setScmpErrorListener(Consumer<Scmp.ErrorMessage> listener) {
        Object object = this.stateLock;
        synchronized (object) {
            Consumer<Scmp.ErrorMessage> old = this.errorListener;
            this.errorListener = listener;
            return old;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkService() throws IllegalStateException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.service == null) {
                throw new IllegalStateException("This operation requires a ScionService.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkOpen() throws ClosedChannelException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.channel.isOpen()) {
                throw new ClosedChannelException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkConnected(boolean requiredState) {
        Object object = this.stateLock;
        synchronized (object) {
            boolean isConnected;
            boolean bl = isConnected = this.connectionPath != null;
            if (requiredState != isConnected) {
                if (isConnected) {
                    throw new AlreadyConnectedException();
                }
                throw new NotYetConnectedException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.connectionPath != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getOption(SocketOption<T> option) throws IOException {
        this.checkOpen();
        Object object = this.stateLock;
        synchronized (object) {
            if (option instanceof ScionSocketOptions.SciSocketOption) {
                if (ScionSocketOptions.SCION_API_THROW_PARSER_FAILURE.equals(option)) {
                    return (T)Boolean.valueOf(this.cfgReportFailedValidation);
                }
                if (ScionSocketOptions.SCION_PATH_EXPIRY_MARGIN.equals(option)) {
                    return (T)Integer.valueOf(this.cfgExpirationSafetyMargin);
                }
                if (ScionSocketOptions.SCION_TRAFFIC_CLASS.equals(option)) {
                    return (T)Integer.valueOf(this.cfgTrafficClass);
                }
                throw new UnsupportedOperationException();
            }
            if (StandardSocketOptions.SO_BROADCAST.equals(option)) {
                throw new UnsupportedOperationException();
            }
            return this.channel.getOption(option);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> C setOption(SocketOption<T> option, T t) throws IOException {
        this.checkOpen();
        Object object = this.stateLock;
        synchronized (object) {
            if (option instanceof ScionSocketOptions.SciSocketOption) {
                if (ScionSocketOptions.SCION_API_THROW_PARSER_FAILURE.equals(option)) {
                    this.cfgReportFailedValidation = (Boolean)t;
                } else if (ScionSocketOptions.SCION_PATH_EXPIRY_MARGIN.equals(option)) {
                    this.cfgExpirationSafetyMargin = (Integer)t;
                } else {
                    if (!ScionSocketOptions.SCION_TRAFFIC_CLASS.equals(option)) throw new UnsupportedOperationException();
                    int trafficClass = (Integer)t;
                    if (trafficClass < 0 || trafficClass > 255) {
                        throw new IllegalArgumentException("trafficClass is not in range 0 -- 255");
                    }
                    this.cfgTrafficClass = trafficClass;
                }
            } else {
                if (StandardSocketOptions.SO_BROADCAST.equals(option)) {
                    throw new UnsupportedOperationException();
                }
                this.channel.setOption((SocketOption)option, (Object)t);
            }
            return (C)this;
        }
    }

    protected int getCfgExpirationSafetyMargin() {
        return this.cfgExpirationSafetyMargin;
    }

    private void checkLockedForRead() {
        if (!this.readLock().isLocked()) {
            throw new IllegalStateException("Access must be READ locked!");
        }
    }

    private void checkLockedForWrite() {
        if (!this.writeLock().isLocked()) {
            throw new IllegalStateException("Access must be WRITE locked!");
        }
    }

    protected final ByteBuffer getBufferSend(int requiredSize) {
        this.checkLockedForWrite();
        if (this.bufferSend.capacity() < requiredSize) {
            this.bufferSend = ByteBuffer.allocateDirect(requiredSize);
        }
        return this.bufferSend;
    }

    protected final ByteBuffer getBufferReceive(int requiredSize) {
        this.checkLockedForRead();
        if (this.bufferReceive.capacity() < requiredSize) {
            this.bufferReceive = ByteBuffer.allocateDirect(requiredSize);
        }
        return this.bufferReceive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildHeader(ByteBuffer buffer, Path path, int payloadLength, InternalConstants.HdrTypes hdrType, ByteUtil.MutInt port) throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            InetAddress srcAddress;
            long srcIsdAs;
            this.ensureBound();
            buffer.clear();
            if (path instanceof ResponsePath) {
                ResponsePath rPath = (ResponsePath)path;
                srcIsdAs = rPath.getLocalIsdAs();
                srcAddress = rPath.getLocalAddress();
                port.set(rPath.getLocalPort());
            } else {
                this.checkService();
                srcIsdAs = this.getService().getLocalIsdAs();
                InetSocketAddress src = this.getSourceAddress(path);
                srcAddress = src.getAddress();
                port.set(src.getPort());
            }
            byte[] rawPath = path.getRawPath();
            ScionHeaderParser.write(buffer, payloadLength, rawPath.length, srcIsdAs, srcAddress.getAddress(), path.getRemoteIsdAs(), path.getRemoteAddress().getAddress(), hdrType, this.cfgTrafficClass);
            ScionHeaderParser.writePath(buffer, rawPath);
        }
    }

    protected void updateConnection(RequestPath newPath, boolean mustBeConnected) {
        if (mustBeConnected && !this.isConnected()) {
            return;
        }
        this.connectionPath = newPath;
        if (!this.isBoundToAddress) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean validate(ByteBuffer buffer) throws ScionException {
        Object object = this.stateLock;
        synchronized (object) {
            String validationResult = ScionHeaderParser.validate(buffer.asReadOnlyBuffer());
            if (validationResult != null && this.cfgReportFailedValidation) {
                throw new ScionException(validationResult);
            }
            return validationResult == null;
        }
    }

    protected ReentrantLock readLock() {
        return this.readLock;
    }

    protected ReentrantLock writeLock() {
        return this.writeLock;
    }

    protected Object stateLock() {
        return this.stateLock;
    }
}

