/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.DatagramSocketImpl;
import java.net.DatagramSocketImplFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.SocketTimeoutException;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyBoundException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.IllegalBlockingModeException;
import java.time.Instant;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.scion.jpan.Path;
import org.scion.jpan.PathPolicy;
import org.scion.jpan.RequestPath;
import org.scion.jpan.Scion;
import org.scion.jpan.ScionDatagramChannel;
import org.scion.jpan.ScionRuntimeException;
import org.scion.jpan.ScionService;
import org.scion.jpan.ScionSocketAddress;
import org.scion.jpan.ScionSocketOptions;
import org.scion.jpan.internal.SelectingDatagramChannel;
import org.scion.jpan.internal.SimpleCache;

public class ScionDatagramSocket
extends DatagramSocket {
    private static final Set<SocketOption<?>> supportedOptions;
    private final SelectingDatagramChannel channel;
    private boolean isBound = false;
    private final SimpleCache<InetSocketAddress, Path> pathCache = new SimpleCache(100);
    private final Object closeLock = new Object();

    public ScionDatagramSocket() throws SocketException {
        this(new InetSocketAddress(0), Scion.defaultService());
    }

    public ScionDatagramSocket(int port) throws SocketException {
        this(port, null);
    }

    public ScionDatagramSocket(int port, InetAddress bindAddress) throws SocketException {
        this(new InetSocketAddress(bindAddress, port));
    }

    public ScionDatagramSocket(SocketAddress bindAddress) throws SocketException {
        this(bindAddress, Scion.defaultService());
    }

    protected ScionDatagramSocket(ScionService service, DatagramChannel channel) throws SocketException {
        super(new DummyDatagramSocketImpl());
        try {
            this.channel = new SelectingDatagramChannel(service, channel);
        }
        catch (IOException e) {
            throw new SocketException(e.getMessage());
        }
    }

    protected ScionDatagramSocket(SocketAddress bindAddress, ScionService service) throws SocketException {
        this(service, null);
        if (bindAddress != null) {
            try {
                this.channel.bind(ScionDatagramSocket.checkAddress(bindAddress));
                this.isBound = true;
            }
            catch (IOException e) {
                throw new SocketException(e.getMessage());
            }
        }
    }

    public static ScionDatagramSocket create(ScionService service) throws SocketException {
        return new ScionDatagramSocket(service, null);
    }

    public static ScionDatagramSocket create(ScionService service, DatagramChannel channel) throws SocketException {
        return new ScionDatagramSocket(service, channel);
    }

    public static ScionDatagramSocket create(SocketAddress bindAddress, ScionService service) throws SocketException {
        return new ScionDatagramSocket(bindAddress, service);
    }

    public static synchronized void setDatagramSocketImplFactory(DatagramSocketImplFactory factory) throws IOException {
        throw new UnsupportedOperationException();
    }

    private void checkOpen() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
    }

    private void checkBlockingMode() {
        if (this.channel.isBlocking()) {
            throw new IllegalBlockingModeException();
        }
    }

    private static InetSocketAddress checkAddress(SocketAddress address) {
        if (!(address instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Address must be an InetSocketAddress");
        }
        return (InetSocketAddress)address;
    }

    private static InetSocketAddress checkAddressOrNull(SocketAddress address) {
        if (address != null && !(address instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Address must be an InetSocketAddress");
        }
        return (InetSocketAddress)address;
    }

    private static void checkAddress(InetAddress address) {
        if (address == null) {
            throw new IllegalArgumentException("Address must not be null");
        }
    }

    private static void checkPort(int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Port out of range");
        }
    }

    @Override
    public synchronized void bind(SocketAddress address) throws SocketException {
        try {
            this.channel.bind(ScionDatagramSocket.checkAddressOrNull(address));
            this.isBound = true;
        }
        catch (AlreadyBoundException e) {
            throw new SocketException("already bound");
        }
        catch (IOException e) {
            throw new SocketException(e.getMessage());
        }
    }

    public synchronized void connect(Path path) {
        try {
            this.channel.connect(path);
        }
        catch (IOException e) {
            throw new UncheckedIOException("connect failed", e);
        }
    }

    @Override
    public synchronized void connect(InetAddress address, int port) {
        ScionDatagramSocket.checkAddress(address);
        try {
            this.connect(new InetSocketAddress(address, port));
        }
        catch (IOException e) {
            throw new UncheckedIOException("connect failed", e);
        }
    }

    @Override
    public synchronized void connect(SocketAddress address) throws SocketException {
        try {
            if (this.channel.isConnected()) {
                this.channel.disconnect();
            }
            this.channel.connect(ScionDatagramSocket.checkAddress(address));
        }
        catch (IOException e) {
            throw new SocketException(e.getMessage());
        }
    }

    @Override
    public synchronized void disconnect() {
        try {
            this.channel.disconnect();
        }
        catch (IOException e) {
            throw new ScionRuntimeException(e);
        }
    }

    @Override
    public boolean isBound() {
        return this.isBound;
    }

    @Override
    public boolean isConnected() {
        return this.channel.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        Object object = this.closeLock;
        synchronized (object) {
            try {
                this.channel.close();
            }
            catch (IOException e) {
                throw new ScionRuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosed() {
        Object object = this.closeLock;
        synchronized (object) {
            return !this.channel.isOpen();
        }
    }

    @Override
    public InetAddress getInetAddress() {
        try {
            return this.channel.getLocalAddress().getAddress();
        }
        catch (IOException e) {
            throw new ScionRuntimeException(e);
        }
    }

    @Override
    public int getPort() {
        try {
            return this.channel.getLocalAddress().getPort();
        }
        catch (IOException e) {
            throw new ScionRuntimeException(e);
        }
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        try {
            return this.channel.getRemoteAddress();
        }
        catch (IOException e) {
            throw new ScionRuntimeException(e);
        }
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        try {
            return this.channel.getLocalAddress();
        }
        catch (IOException e) {
            throw new ScionRuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(DatagramPacket packet) throws IOException {
        this.checkOpen();
        this.checkBlockingMode();
        ScionDatagramSocket.checkAddress(packet.getAddress());
        ScionDatagramSocket.checkPort(packet.getPort());
        DatagramPacket datagramPacket = packet;
        synchronized (datagramPacket) {
            Path path;
            if (this.isConnected() && !this.channel.getRemoteAddress().equals(packet.getSocketAddress())) {
                throw new IllegalArgumentException("Packet address does not match connected address");
            }
            if (this.channel.isConnected()) {
                path = this.channel.getConnectionPath();
            } else {
                InetSocketAddress addr = (InetSocketAddress)packet.getSocketAddress();
                SimpleCache<InetSocketAddress, Path> simpleCache = this.pathCache;
                synchronized (simpleCache) {
                    path = this.pathCache.get(addr);
                    if (path == null) {
                        path = this.channel.applyFilter(this.channel.getService().lookupPaths(addr), addr).get(0);
                    } else if (path instanceof RequestPath && path.getMetadata().getExpiration() > Instant.now().getEpochSecond()) {
                        RequestPath request = (RequestPath)path;
                        path = this.channel.applyFilter(this.channel.getService().getPaths(request), addr).get(0);
                    }
                    if (path == null) {
                        throw new IOException("Address is not resolvable in SCION: " + addr.getAddress());
                    }
                    this.pathCache.put(addr, path);
                }
            }
            ByteBuffer buf = ByteBuffer.wrap(packet.getData(), packet.getOffset(), packet.getLength());
            this.channel.send(buf, path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void receive(DatagramPacket packet) throws IOException {
        this.checkOpen();
        this.checkBlockingMode();
        DatagramPacket datagramPacket = packet;
        synchronized (datagramPacket) {
            ByteBuffer receiveBuffer = ByteBuffer.wrap(packet.getData(), packet.getOffset(), packet.getLength());
            ScionSocketAddress responseAddress = this.channel.receive(receiveBuffer);
            if (responseAddress == null) {
                throw new SocketTimeoutException();
            }
            Path path = responseAddress.getPath();
            if (!this.channel.isConnected()) {
                SimpleCache<InetSocketAddress, Path> simpleCache = this.pathCache;
                synchronized (simpleCache) {
                    InetAddress ip = path.getRemoteAddress();
                    this.pathCache.put(new InetSocketAddress(ip, path.getRemotePort()), path);
                }
            }
            receiveBuffer.flip();
            packet.setLength(receiveBuffer.limit());
            packet.setAddress(path.getRemoteAddress());
            packet.setPort(path.getRemotePort());
        }
    }

    @Override
    public InetAddress getLocalAddress() {
        try {
            InetSocketAddress address = this.channel.getLocalAddress();
            if (address == null) {
                return null;
            }
            return address.getAddress();
        }
        catch (IOException e) {
            throw new ScionRuntimeException(e);
        }
    }

    @Override
    public int getLocalPort() {
        try {
            return this.channel.getLocalAddress().getPort();
        }
        catch (IOException e) {
            throw new ScionRuntimeException(e);
        }
    }

    @Override
    public synchronized boolean getBroadcast() throws SocketException {
        this.checkOpen();
        try {
            return (Boolean)this.channel.getOption((SocketOption)StandardSocketOptions.SO_BROADCAST);
        }
        catch (IOException e) {
            throw new SocketException(e.getMessage());
        }
    }

    @Override
    public synchronized void setBroadcast(boolean flag) throws SocketException {
        this.checkOpen();
        try {
            this.channel.setOption(StandardSocketOptions.SO_BROADCAST, flag);
        }
        catch (IOException e) {
            throw new SocketException(e.getMessage());
        }
    }

    @Override
    public synchronized boolean getReuseAddress() throws SocketException {
        this.checkOpen();
        try {
            return (Boolean)this.channel.getOption((SocketOption)StandardSocketOptions.SO_REUSEADDR);
        }
        catch (IOException e) {
            throw new SocketException(e.getMessage());
        }
    }

    @Override
    public synchronized void setReuseAddress(boolean flag) throws SocketException {
        this.checkOpen();
        try {
            this.channel.setOption(StandardSocketOptions.SO_REUSEADDR, flag);
        }
        catch (IOException e) {
            throw new SocketException(e.getMessage());
        }
    }

    @Override
    public synchronized int getReceiveBufferSize() throws SocketException {
        this.checkOpen();
        try {
            return (Integer)this.channel.getOption((SocketOption)StandardSocketOptions.SO_RCVBUF);
        }
        catch (IOException e) {
            throw new SocketException(e.getMessage());
        }
    }

    @Override
    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        this.checkOpen();
        try {
            this.channel.setOption(StandardSocketOptions.SO_RCVBUF, size);
        }
        catch (IOException e) {
            throw new SocketException(e.getMessage());
        }
    }

    @Override
    public synchronized int getSendBufferSize() throws SocketException {
        this.checkOpen();
        try {
            return (Integer)this.channel.getOption((SocketOption)StandardSocketOptions.SO_SNDBUF);
        }
        catch (IOException e) {
            throw new SocketException(e.getMessage());
        }
    }

    @Override
    public synchronized void setSendBufferSize(int size) throws SocketException {
        this.checkOpen();
        try {
            this.channel.setOption(StandardSocketOptions.SO_SNDBUF, size);
        }
        catch (IOException e) {
            throw new SocketException(e.getMessage());
        }
    }

    @Override
    public synchronized int getSoTimeout() throws SocketException {
        this.checkOpen();
        return this.channel.getTimeOut();
    }

    @Override
    public synchronized void setSoTimeout(int timeOut) throws SocketException {
        this.checkOpen();
        this.channel.setTimeOut(timeOut);
    }

    @Override
    public synchronized int getTrafficClass() throws SocketException {
        this.checkOpen();
        try {
            return (Integer)this.channel.getOption((SocketOption)ScionSocketOptions.SCION_TRAFFIC_CLASS);
        }
        catch (IOException e) {
            throw new SocketException(e.getMessage());
        }
    }

    @Override
    public synchronized void setTrafficClass(int trafficClass) throws SocketException {
        this.checkOpen();
        try {
            this.channel.setOption(ScionSocketOptions.SCION_TRAFFIC_CLASS, trafficClass);
        }
        catch (IOException e) {
            throw new SocketException(e.getMessage());
        }
    }

    @Override
    public synchronized DatagramChannel getChannel() {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized <T> ScionDatagramSocket setOption(SocketOption<T> name, T value) throws IOException {
        this.channel.setOption(name, value);
        return this;
    }

    @Override
    public synchronized <T> T getOption(SocketOption<T> name) throws IOException {
        return (T)this.channel.getOption((SocketOption)name);
    }

    @Override
    public synchronized Set<SocketOption<?>> supportedOptions() {
        return supportedOptions;
    }

    @Override
    public void joinGroup(SocketAddress mcastaddr, NetworkInterface netIf) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void leaveGroup(SocketAddress mcastaddr, NetworkInterface netIf) {
        throw new UnsupportedOperationException();
    }

    public Path getConnectionPath() {
        return this.channel.getConnectionPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Path getCachedPath(InetSocketAddress address) {
        SimpleCache<InetSocketAddress, Path> simpleCache = this.pathCache;
        synchronized (simpleCache) {
            return this.pathCache.get(address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setPathCacheCapacity(int capacity) {
        SimpleCache<InetSocketAddress, Path> simpleCache = this.pathCache;
        synchronized (simpleCache) {
            this.pathCache.setCapacity(capacity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getPathCacheCapacity() {
        SimpleCache<InetSocketAddress, Path> simpleCache = this.pathCache;
        synchronized (simpleCache) {
            return this.pathCache.getCapacity();
        }
    }

    @Deprecated
    public synchronized ScionDatagramChannel getScionChannel() {
        return this.channel;
    }

    public synchronized ScionService getService() {
        return this.channel.getService();
    }

    public synchronized PathPolicy getPathPolicy() {
        return this.channel.getPathPolicy();
    }

    public synchronized void setPathPolicy(PathPolicy pathPolicy) throws IOException {
        this.channel.setPathPolicy(pathPolicy);
    }

    @Deprecated
    public synchronized ScionDatagramSocket setRemoteDispatcher(boolean hasDispatcher) {
        this.channel.configureRemoteDispatcher(hasDispatcher);
        return this;
    }

    public synchronized void setOverrideSourceAddress(InetSocketAddress overrideSourceAddress) {
        this.channel.setOverrideSourceAddress(overrideSourceAddress);
    }

    static {
        HashSet<SocketOption<Comparable<Boolean>>> options = new HashSet<SocketOption<Comparable<Boolean>>>();
        options.add(ScionSocketOptions.SCION_API_THROW_PARSER_FAILURE);
        options.add(ScionSocketOptions.SCION_PATH_EXPIRY_MARGIN);
        options.add(StandardSocketOptions.SO_SNDBUF);
        options.add(StandardSocketOptions.SO_RCVBUF);
        options.add(StandardSocketOptions.SO_REUSEADDR);
        options.add(StandardSocketOptions.IP_TOS);
        supportedOptions = Collections.unmodifiableSet(options);
    }

    private static class DummyDatagramSocketImpl
    extends DatagramSocketImpl {
        private DummyDatagramSocketImpl() {
        }

        @Override
        protected void create() {
        }

        @Override
        protected void bind(int i, InetAddress inetAddress) {
        }

        @Override
        protected void send(DatagramPacket datagramPacket) {
        }

        @Override
        protected int peek(InetAddress inetAddress) {
            return 0;
        }

        @Override
        protected int peekData(DatagramPacket datagramPacket) {
            return 0;
        }

        @Override
        protected void receive(DatagramPacket datagramPacket) {
        }

        @Override
        protected void setTTL(byte b) {
        }

        @Override
        protected byte getTTL() {
            return 0;
        }

        @Override
        protected void setTimeToLive(int i) {
        }

        @Override
        protected int getTimeToLive() {
            return 0;
        }

        @Override
        protected void join(InetAddress inetAddress) {
        }

        @Override
        protected void leave(InetAddress inetAddress) {
        }

        @Override
        protected void joinGroup(SocketAddress socketAddress, NetworkInterface networkInterface) {
        }

        @Override
        protected void leaveGroup(SocketAddress socketAddress, NetworkInterface networkInterface) {
        }

        @Override
        protected void close() {
        }

        @Override
        public void setOption(int i, Object o) {
        }

        @Override
        public Object getOption(int i) {
            return null;
        }
    }
}

